# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ConsumerAclArgs', 'ConsumerAcl']

@pulumi.input_type
class ConsumerAclArgs:
    def __init__(__self__, *,
                 consumer_id: pulumi.Input[builtins.str],
                 group: pulumi.Input[builtins.str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ConsumerAcl resource.
        :param pulumi.Input[builtins.str] consumer_id: the id of the consumer to be configured
        :param pulumi.Input[builtins.str] group: the acl group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer acl for grouping and filtering
        """
        pulumi.set(__self__, "consumer_id", consumer_id)
        pulumi.set(__self__, "group", group)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> pulumi.Input[builtins.str]:
        """
        the id of the consumer to be configured
        """
        return pulumi.get(self, "consumer_id")

    @consumer_id.setter
    def consumer_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "consumer_id", value)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Input[builtins.str]:
        """
        the acl group
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the consumer acl for grouping and filtering
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ConsumerAclState:
    def __init__(__self__, *,
                 consumer_id: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ConsumerAcl resources.
        :param pulumi.Input[builtins.str] consumer_id: the id of the consumer to be configured
        :param pulumi.Input[builtins.str] group: the acl group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer acl for grouping and filtering
        """
        if consumer_id is not None:
            pulumi.set(__self__, "consumer_id", consumer_id)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        the id of the consumer to be configured
        """
        return pulumi.get(self, "consumer_id")

    @consumer_id.setter
    def consumer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumer_id", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        the acl group
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the consumer acl for grouping and filtering
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("kong:index/consumerAcl:ConsumerAcl")
class ConsumerAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumer_id: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## # ConsumerAcl

        Consumer ACL is a resource that allows you to configure the acl plugin for a consumer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        my_consumer = kong.Consumer("my_consumer",
            username="User1",
            custom_id="123")
        acl_plugin = kong.Plugin("acl_plugin",
            name="acl",
            config_json=\"\"\"\\x09{
        \\x09\\x09"allow": ["group1", "group2"]
        \\x09}
        \"\"\")
        consumer_acl = kong.ConsumerAcl("consumer_acl",
            consumer_id=my_consumer.id,
            group="group2",
            tags=[
                "myTag",
                "otherTag",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] consumer_id: the id of the consumer to be configured
        :param pulumi.Input[builtins.str] group: the acl group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer acl for grouping and filtering
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConsumerAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # ConsumerAcl

        Consumer ACL is a resource that allows you to configure the acl plugin for a consumer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        my_consumer = kong.Consumer("my_consumer",
            username="User1",
            custom_id="123")
        acl_plugin = kong.Plugin("acl_plugin",
            name="acl",
            config_json=\"\"\"\\x09{
        \\x09\\x09"allow": ["group1", "group2"]
        \\x09}
        \"\"\")
        consumer_acl = kong.ConsumerAcl("consumer_acl",
            consumer_id=my_consumer.id,
            group="group2",
            tags=[
                "myTag",
                "otherTag",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param ConsumerAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConsumerAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumer_id: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConsumerAclArgs.__new__(ConsumerAclArgs)

            if consumer_id is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_id'")
            __props__.__dict__["consumer_id"] = consumer_id
            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            __props__.__dict__["tags"] = tags
        super(ConsumerAcl, __self__).__init__(
            'kong:index/consumerAcl:ConsumerAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            consumer_id: Optional[pulumi.Input[builtins.str]] = None,
            group: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'ConsumerAcl':
        """
        Get an existing ConsumerAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] consumer_id: the id of the consumer to be configured
        :param pulumi.Input[builtins.str] group: the acl group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer acl for grouping and filtering
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConsumerAclState.__new__(_ConsumerAclState)

        __props__.__dict__["consumer_id"] = consumer_id
        __props__.__dict__["group"] = group
        __props__.__dict__["tags"] = tags
        return ConsumerAcl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> pulumi.Output[builtins.str]:
        """
        the id of the consumer to be configured
        """
        return pulumi.get(self, "consumer_id")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[builtins.str]:
        """
        the acl group
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of strings associated with the consumer acl for grouping and filtering
        """
        return pulumi.get(self, "tags")

