# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ConsumerBasicAuthArgs', 'ConsumerBasicAuth']

@pulumi.input_type
class ConsumerBasicAuthArgs:
    def __init__(__self__, *,
                 consumer_id: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ConsumerBasicAuth resource.
        :param pulumi.Input[builtins.str] consumer_id: the id of the consumer to be configured with basic auth
        :param pulumi.Input[builtins.str] password: password to be used for basic auth
        :param pulumi.Input[builtins.str] username: username to be used for basic auth
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer basic auth for grouping and filtering
        """
        pulumi.set(__self__, "consumer_id", consumer_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> pulumi.Input[builtins.str]:
        """
        the id of the consumer to be configured with basic auth
        """
        return pulumi.get(self, "consumer_id")

    @consumer_id.setter
    def consumer_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "consumer_id", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        password to be used for basic auth
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        username to be used for basic auth
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the consumer basic auth for grouping and filtering
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ConsumerBasicAuthState:
    def __init__(__self__, *,
                 consumer_id: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConsumerBasicAuth resources.
        :param pulumi.Input[builtins.str] consumer_id: the id of the consumer to be configured with basic auth
        :param pulumi.Input[builtins.str] password: password to be used for basic auth
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer basic auth for grouping and filtering
        :param pulumi.Input[builtins.str] username: username to be used for basic auth
        """
        if consumer_id is not None:
            pulumi.set(__self__, "consumer_id", consumer_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        the id of the consumer to be configured with basic auth
        """
        return pulumi.get(self, "consumer_id")

    @consumer_id.setter
    def consumer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumer_id", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        password to be used for basic auth
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the consumer basic auth for grouping and filtering
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        username to be used for basic auth
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("kong:index/consumerBasicAuth:ConsumerBasicAuth")
class ConsumerBasicAuth(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumer_id: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## # ConsumerBasicAuth

        Consumer basic auth is a resource that allows you to configure the basic auth plugin for a consumer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        my_consumer = kong.Consumer("my_consumer",
            username="User1",
            custom_id="123")
        basic_auth_plugin = kong.Plugin("basic_auth_plugin", name="basic-auth")
        consumer_basic_auth = kong.ConsumerBasicAuth("consumer_basic_auth",
            consumer_id=my_consumer.id,
            username="foo_updated",
            password="bar_updated",
            tags=[
                "myTag",
                "anotherTag",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] consumer_id: the id of the consumer to be configured with basic auth
        :param pulumi.Input[builtins.str] password: password to be used for basic auth
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer basic auth for grouping and filtering
        :param pulumi.Input[builtins.str] username: username to be used for basic auth
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConsumerBasicAuthArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # ConsumerBasicAuth

        Consumer basic auth is a resource that allows you to configure the basic auth plugin for a consumer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        my_consumer = kong.Consumer("my_consumer",
            username="User1",
            custom_id="123")
        basic_auth_plugin = kong.Plugin("basic_auth_plugin", name="basic-auth")
        consumer_basic_auth = kong.ConsumerBasicAuth("consumer_basic_auth",
            consumer_id=my_consumer.id,
            username="foo_updated",
            password="bar_updated",
            tags=[
                "myTag",
                "anotherTag",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param ConsumerBasicAuthArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConsumerBasicAuthArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumer_id: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConsumerBasicAuthArgs.__new__(ConsumerBasicAuthArgs)

            if consumer_id is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_id'")
            __props__.__dict__["consumer_id"] = consumer_id
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["tags"] = tags
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        super(ConsumerBasicAuth, __self__).__init__(
            'kong:index/consumerBasicAuth:ConsumerBasicAuth',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            consumer_id: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'ConsumerBasicAuth':
        """
        Get an existing ConsumerBasicAuth resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] consumer_id: the id of the consumer to be configured with basic auth
        :param pulumi.Input[builtins.str] password: password to be used for basic auth
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer basic auth for grouping and filtering
        :param pulumi.Input[builtins.str] username: username to be used for basic auth
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConsumerBasicAuthState.__new__(_ConsumerBasicAuthState)

        __props__.__dict__["consumer_id"] = consumer_id
        __props__.__dict__["password"] = password
        __props__.__dict__["tags"] = tags
        __props__.__dict__["username"] = username
        return ConsumerBasicAuth(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> pulumi.Output[builtins.str]:
        """
        the id of the consumer to be configured with basic auth
        """
        return pulumi.get(self, "consumer_id")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        password to be used for basic auth
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of strings associated with the consumer basic auth for grouping and filtering
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        username to be used for basic auth
        """
        return pulumi.get(self, "username")

