# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ConsumerOauth2Args', 'ConsumerOauth2']

@pulumi.input_type
class ConsumerOauth2Args:
    def __init__(__self__, *,
                 consumer_id: pulumi.Input[builtins.str],
                 redirect_uris: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 hash_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ConsumerOauth2 resource.
        :param pulumi.Input[builtins.str] consumer_id: The id of the consumer to be configured with oauth2.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] redirect_uris: An array with one or more URLs in your app where users will be sent after authorization ([RFC 6742 Section 3.1.2](https://tools.ietf.org/html/rfc6749#section-3.1.2)).
        :param pulumi.Input[builtins.str] client_id: Unique oauth2 client id. If not set, the oauth2 plugin will generate one
        :param pulumi.Input[builtins.str] client_secret: Unique oauth2 client secret. If not set, the oauth2 plugin will generate one
        :param pulumi.Input[builtins.bool] hash_secret: A boolean flag that indicates whether the client_secret field will be stored in hashed form. If enabled on existing plugin instances, client secrets are hashed on the fly upon first usage. Default: `false`.
        :param pulumi.Input[builtins.str] name: The name associated with the credential.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer for grouping and filtering.
        """
        pulumi.set(__self__, "consumer_id", consumer_id)
        pulumi.set(__self__, "redirect_uris", redirect_uris)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if hash_secret is not None:
            pulumi.set(__self__, "hash_secret", hash_secret)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> pulumi.Input[builtins.str]:
        """
        The id of the consumer to be configured with oauth2.
        """
        return pulumi.get(self, "consumer_id")

    @consumer_id.setter
    def consumer_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "consumer_id", value)

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        An array with one or more URLs in your app where users will be sent after authorization ([RFC 6742 Section 3.1.2](https://tools.ietf.org/html/rfc6749#section-3.1.2)).
        """
        return pulumi.get(self, "redirect_uris")

    @redirect_uris.setter
    def redirect_uris(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "redirect_uris", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique oauth2 client id. If not set, the oauth2 plugin will generate one
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique oauth2 client secret. If not set, the oauth2 plugin will generate one
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="hashSecret")
    def hash_secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean flag that indicates whether the client_secret field will be stored in hashed form. If enabled on existing plugin instances, client secrets are hashed on the fly upon first usage. Default: `false`.
        """
        return pulumi.get(self, "hash_secret")

    @hash_secret.setter
    def hash_secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "hash_secret", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name associated with the credential.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the consumer for grouping and filtering.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ConsumerOauth2State:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 consumer_id: Optional[pulumi.Input[builtins.str]] = None,
                 hash_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ConsumerOauth2 resources.
        :param pulumi.Input[builtins.str] client_id: Unique oauth2 client id. If not set, the oauth2 plugin will generate one
        :param pulumi.Input[builtins.str] client_secret: Unique oauth2 client secret. If not set, the oauth2 plugin will generate one
        :param pulumi.Input[builtins.str] consumer_id: The id of the consumer to be configured with oauth2.
        :param pulumi.Input[builtins.bool] hash_secret: A boolean flag that indicates whether the client_secret field will be stored in hashed form. If enabled on existing plugin instances, client secrets are hashed on the fly upon first usage. Default: `false`.
        :param pulumi.Input[builtins.str] name: The name associated with the credential.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] redirect_uris: An array with one or more URLs in your app where users will be sent after authorization ([RFC 6742 Section 3.1.2](https://tools.ietf.org/html/rfc6749#section-3.1.2)).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer for grouping and filtering.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if consumer_id is not None:
            pulumi.set(__self__, "consumer_id", consumer_id)
        if hash_secret is not None:
            pulumi.set(__self__, "hash_secret", hash_secret)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_uris is not None:
            pulumi.set(__self__, "redirect_uris", redirect_uris)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique oauth2 client id. If not set, the oauth2 plugin will generate one
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique oauth2 client secret. If not set, the oauth2 plugin will generate one
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the consumer to be configured with oauth2.
        """
        return pulumi.get(self, "consumer_id")

    @consumer_id.setter
    def consumer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumer_id", value)

    @property
    @pulumi.getter(name="hashSecret")
    def hash_secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean flag that indicates whether the client_secret field will be stored in hashed form. If enabled on existing plugin instances, client secrets are hashed on the fly upon first usage. Default: `false`.
        """
        return pulumi.get(self, "hash_secret")

    @hash_secret.setter
    def hash_secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "hash_secret", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name associated with the credential.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array with one or more URLs in your app where users will be sent after authorization ([RFC 6742 Section 3.1.2](https://tools.ietf.org/html/rfc6749#section-3.1.2)).
        """
        return pulumi.get(self, "redirect_uris")

    @redirect_uris.setter
    def redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "redirect_uris", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the consumer for grouping and filtering.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("kong:index/consumerOauth2:ConsumerOauth2")
class ConsumerOauth2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 consumer_id: Optional[pulumi.Input[builtins.str]] = None,
                 hash_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## # ConsumerOauth2

        Resource that allows you to configure the OAuth2 plugin credentials for a consumer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        my_consumer = kong.Consumer("my_consumer",
            username="User1",
            custom_id="123")
        oauth2_plugin = kong.Plugin("oauth2_plugin",
            name="oauth2",
            config_json=\"\"\"\\x09{
        \\x09\\x09"global_credentials": true,
        \\x09\\x09"enable_password_grant": true,
        \\x09\\x09"token_expiration": 180,
        \\x09\\x09"refresh_token_ttl": 180,
        \\x09\\x09"provision_key": "testprovisionkey"
        \\x09}
        \"\"\")
        consumer_oauth2 = kong.ConsumerOauth2("consumer_oauth2",
            name="test_application",
            consumer_id=my_consumer.id,
            client_id="client_id",
            client_secret="client_secret",
            redirect_uris=[
                "https://asdf.com/callback",
                "https://test.cl/callback",
            ],
            tags=["myTag"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_id: Unique oauth2 client id. If not set, the oauth2 plugin will generate one
        :param pulumi.Input[builtins.str] client_secret: Unique oauth2 client secret. If not set, the oauth2 plugin will generate one
        :param pulumi.Input[builtins.str] consumer_id: The id of the consumer to be configured with oauth2.
        :param pulumi.Input[builtins.bool] hash_secret: A boolean flag that indicates whether the client_secret field will be stored in hashed form. If enabled on existing plugin instances, client secrets are hashed on the fly upon first usage. Default: `false`.
        :param pulumi.Input[builtins.str] name: The name associated with the credential.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] redirect_uris: An array with one or more URLs in your app where users will be sent after authorization ([RFC 6742 Section 3.1.2](https://tools.ietf.org/html/rfc6749#section-3.1.2)).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer for grouping and filtering.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConsumerOauth2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # ConsumerOauth2

        Resource that allows you to configure the OAuth2 plugin credentials for a consumer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        my_consumer = kong.Consumer("my_consumer",
            username="User1",
            custom_id="123")
        oauth2_plugin = kong.Plugin("oauth2_plugin",
            name="oauth2",
            config_json=\"\"\"\\x09{
        \\x09\\x09"global_credentials": true,
        \\x09\\x09"enable_password_grant": true,
        \\x09\\x09"token_expiration": 180,
        \\x09\\x09"refresh_token_ttl": 180,
        \\x09\\x09"provision_key": "testprovisionkey"
        \\x09}
        \"\"\")
        consumer_oauth2 = kong.ConsumerOauth2("consumer_oauth2",
            name="test_application",
            consumer_id=my_consumer.id,
            client_id="client_id",
            client_secret="client_secret",
            redirect_uris=[
                "https://asdf.com/callback",
                "https://test.cl/callback",
            ],
            tags=["myTag"])
        ```

        :param str resource_name: The name of the resource.
        :param ConsumerOauth2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConsumerOauth2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 consumer_id: Optional[pulumi.Input[builtins.str]] = None,
                 hash_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConsumerOauth2Args.__new__(ConsumerOauth2Args)

            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = client_secret
            if consumer_id is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_id'")
            __props__.__dict__["consumer_id"] = consumer_id
            __props__.__dict__["hash_secret"] = hash_secret
            __props__.__dict__["name"] = name
            if redirect_uris is None and not opts.urn:
                raise TypeError("Missing required property 'redirect_uris'")
            __props__.__dict__["redirect_uris"] = redirect_uris
            __props__.__dict__["tags"] = tags
        super(ConsumerOauth2, __self__).__init__(
            'kong:index/consumerOauth2:ConsumerOauth2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            client_secret: Optional[pulumi.Input[builtins.str]] = None,
            consumer_id: Optional[pulumi.Input[builtins.str]] = None,
            hash_secret: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'ConsumerOauth2':
        """
        Get an existing ConsumerOauth2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_id: Unique oauth2 client id. If not set, the oauth2 plugin will generate one
        :param pulumi.Input[builtins.str] client_secret: Unique oauth2 client secret. If not set, the oauth2 plugin will generate one
        :param pulumi.Input[builtins.str] consumer_id: The id of the consumer to be configured with oauth2.
        :param pulumi.Input[builtins.bool] hash_secret: A boolean flag that indicates whether the client_secret field will be stored in hashed form. If enabled on existing plugin instances, client secrets are hashed on the fly upon first usage. Default: `false`.
        :param pulumi.Input[builtins.str] name: The name associated with the credential.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] redirect_uris: An array with one or more URLs in your app where users will be sent after authorization ([RFC 6742 Section 3.1.2](https://tools.ietf.org/html/rfc6749#section-3.1.2)).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the consumer for grouping and filtering.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConsumerOauth2State.__new__(_ConsumerOauth2State)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["consumer_id"] = consumer_id
        __props__.__dict__["hash_secret"] = hash_secret
        __props__.__dict__["name"] = name
        __props__.__dict__["redirect_uris"] = redirect_uris
        __props__.__dict__["tags"] = tags
        return ConsumerOauth2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Unique oauth2 client id. If not set, the oauth2 plugin will generate one
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Unique oauth2 client secret. If not set, the oauth2 plugin will generate one
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the consumer to be configured with oauth2.
        """
        return pulumi.get(self, "consumer_id")

    @property
    @pulumi.getter(name="hashSecret")
    def hash_secret(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A boolean flag that indicates whether the client_secret field will be stored in hashed form. If enabled on existing plugin instances, client secrets are hashed on the fly upon first usage. Default: `false`.
        """
        return pulumi.get(self, "hash_secret")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name associated with the credential.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        An array with one or more URLs in your app where users will be sent after authorization ([RFC 6742 Section 3.1.2](https://tools.ietf.org/html/rfc6749#section-3.1.2)).
        """
        return pulumi.get(self, "redirect_uris")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of strings associated with the consumer for grouping and filtering.
        """
        return pulumi.get(self, "tags")

