# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteArgs', 'Route']

@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 protocols: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 service_id: pulumi.Input[builtins.str],
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['RouteHeaderArgs']]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 https_redirect_status_code: Optional[pulumi.Input[builtins.int]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_handling: Optional[pulumi.Input[builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preserve_host: Optional[pulumi.Input[builtins.bool]] = None,
                 regex_priority: Optional[pulumi.Input[builtins.int]] = None,
                 request_buffering: Optional[pulumi.Input[builtins.bool]] = None,
                 response_buffering: Optional[pulumi.Input[builtins.bool]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]] = None,
                 strip_path: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Route resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] protocols: The list of protocols to use
        :param pulumi.Input[builtins.str] service_id: Service ID to map to
        :param pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]] destinations: A list of destination `ip` and `port`
        :param pulumi.Input[Sequence[pulumi.Input['RouteHeaderArgs']]] headers: One or more blocks of `name` to set name of header and `values` which is a list of `string` for the header values to match on.  See above example of how to set.  These headers will cause this Route to match if present in the request. The Host header cannot be used with this attribute: hosts should be specified using the hosts attribute.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hosts: A list of domain names that match this Route
        :param pulumi.Input[builtins.int] https_redirect_status_code: The status code Kong responds with when all properties of a Route match except the protocol i.e. if the protocol of the request is HTTP instead of HTTPS. Location header is injected by Kong if the field is set to `301`, `302`, `307` or `308`. Accepted values are: `426`, `301`, `302`, `307`, `308`. Default: `426`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] methods: A list of HTTP methods that match this Route
        :param pulumi.Input[builtins.str] name: The name of the route
        :param pulumi.Input[builtins.str] path_handling: Controls how the Service path, Route path and requested path are combined when sending a request to the upstream.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] paths: A list of paths that match this Route
        :param pulumi.Input[builtins.bool] preserve_host: When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        :param pulumi.Input[builtins.int] regex_priority: A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        :param pulumi.Input[builtins.bool] request_buffering: Whether to enable request body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that receive data with chunked transfer encoding. Default: true.
        :param pulumi.Input[builtins.bool] response_buffering: Whether to enable response body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that send data with chunked transfer encoding. Default: true.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snis: A list of SNIs that match this Route when using stream routing.
        :param pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]] sources: A list of source `ip` and `port`
        :param pulumi.Input[builtins.bool] strip_path: When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Route for grouping and filtering.
        """
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "service_id", service_id)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if https_redirect_status_code is not None:
            pulumi.set(__self__, "https_redirect_status_code", https_redirect_status_code)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_handling is not None:
            pulumi.set(__self__, "path_handling", path_handling)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if preserve_host is not None:
            pulumi.set(__self__, "preserve_host", preserve_host)
        if regex_priority is not None:
            pulumi.set(__self__, "regex_priority", regex_priority)
        if request_buffering is not None:
            pulumi.set(__self__, "request_buffering", request_buffering)
        if response_buffering is not None:
            pulumi.set(__self__, "response_buffering", response_buffering)
        if snis is not None:
            pulumi.set(__self__, "snis", snis)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if strip_path is not None:
            pulumi.set(__self__, "strip_path", strip_path)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of protocols to use
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[builtins.str]:
        """
        Service ID to map to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]]:
        """
        A list of destination `ip` and `port`
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteHeaderArgs']]]]:
        """
        One or more blocks of `name` to set name of header and `values` which is a list of `string` for the header values to match on.  See above example of how to set.  These headers will cause this Route to match if present in the request. The Host header cannot be used with this attribute: hosts should be specified using the hosts attribute.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of domain names that match this Route
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="httpsRedirectStatusCode")
    def https_redirect_status_code(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The status code Kong responds with when all properties of a Route match except the protocol i.e. if the protocol of the request is HTTP instead of HTTPS. Location header is injected by Kong if the field is set to `301`, `302`, `307` or `308`. Accepted values are: `426`, `301`, `302`, `307`, `308`. Default: `426`.
        """
        return pulumi.get(self, "https_redirect_status_code")

    @https_redirect_status_code.setter
    def https_redirect_status_code(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "https_redirect_status_code", value)

    @property
    @pulumi.getter
    def methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of HTTP methods that match this Route
        """
        return pulumi.get(self, "methods")

    @methods.setter
    def methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "methods", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the route
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathHandling")
    def path_handling(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls how the Service path, Route path and requested path are combined when sending a request to the upstream.
        """
        return pulumi.get(self, "path_handling")

    @path_handling.setter
    def path_handling(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path_handling", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of paths that match this Route
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter(name="preserveHost")
    def preserve_host(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        """
        return pulumi.get(self, "preserve_host")

    @preserve_host.setter
    def preserve_host(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "preserve_host", value)

    @property
    @pulumi.getter(name="regexPriority")
    def regex_priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        """
        return pulumi.get(self, "regex_priority")

    @regex_priority.setter
    def regex_priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "regex_priority", value)

    @property
    @pulumi.getter(name="requestBuffering")
    def request_buffering(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable request body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that receive data with chunked transfer encoding. Default: true.
        """
        return pulumi.get(self, "request_buffering")

    @request_buffering.setter
    def request_buffering(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "request_buffering", value)

    @property
    @pulumi.getter(name="responseBuffering")
    def response_buffering(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable response body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that send data with chunked transfer encoding. Default: true.
        """
        return pulumi.get(self, "response_buffering")

    @response_buffering.setter
    def response_buffering(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "response_buffering", value)

    @property
    @pulumi.getter
    def snis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of SNIs that match this Route when using stream routing.
        """
        return pulumi.get(self, "snis")

    @snis.setter
    def snis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "snis", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]]:
        """
        A list of source `ip` and `port`
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter(name="stripPath")
    def strip_path(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        """
        return pulumi.get(self, "strip_path")

    @strip_path.setter
    def strip_path(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "strip_path", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the Route for grouping and filtering.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RouteState:
    def __init__(__self__, *,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['RouteHeaderArgs']]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 https_redirect_status_code: Optional[pulumi.Input[builtins.int]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_handling: Optional[pulumi.Input[builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preserve_host: Optional[pulumi.Input[builtins.bool]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 regex_priority: Optional[pulumi.Input[builtins.int]] = None,
                 request_buffering: Optional[pulumi.Input[builtins.bool]] = None,
                 response_buffering: Optional[pulumi.Input[builtins.bool]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]] = None,
                 strip_path: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Route resources.
        :param pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]] destinations: A list of destination `ip` and `port`
        :param pulumi.Input[Sequence[pulumi.Input['RouteHeaderArgs']]] headers: One or more blocks of `name` to set name of header and `values` which is a list of `string` for the header values to match on.  See above example of how to set.  These headers will cause this Route to match if present in the request. The Host header cannot be used with this attribute: hosts should be specified using the hosts attribute.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hosts: A list of domain names that match this Route
        :param pulumi.Input[builtins.int] https_redirect_status_code: The status code Kong responds with when all properties of a Route match except the protocol i.e. if the protocol of the request is HTTP instead of HTTPS. Location header is injected by Kong if the field is set to `301`, `302`, `307` or `308`. Accepted values are: `426`, `301`, `302`, `307`, `308`. Default: `426`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] methods: A list of HTTP methods that match this Route
        :param pulumi.Input[builtins.str] name: The name of the route
        :param pulumi.Input[builtins.str] path_handling: Controls how the Service path, Route path and requested path are combined when sending a request to the upstream.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] paths: A list of paths that match this Route
        :param pulumi.Input[builtins.bool] preserve_host: When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] protocols: The list of protocols to use
        :param pulumi.Input[builtins.int] regex_priority: A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        :param pulumi.Input[builtins.bool] request_buffering: Whether to enable request body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that receive data with chunked transfer encoding. Default: true.
        :param pulumi.Input[builtins.bool] response_buffering: Whether to enable response body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that send data with chunked transfer encoding. Default: true.
        :param pulumi.Input[builtins.str] service_id: Service ID to map to
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snis: A list of SNIs that match this Route when using stream routing.
        :param pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]] sources: A list of source `ip` and `port`
        :param pulumi.Input[builtins.bool] strip_path: When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Route for grouping and filtering.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if https_redirect_status_code is not None:
            pulumi.set(__self__, "https_redirect_status_code", https_redirect_status_code)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_handling is not None:
            pulumi.set(__self__, "path_handling", path_handling)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if preserve_host is not None:
            pulumi.set(__self__, "preserve_host", preserve_host)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if regex_priority is not None:
            pulumi.set(__self__, "regex_priority", regex_priority)
        if request_buffering is not None:
            pulumi.set(__self__, "request_buffering", request_buffering)
        if response_buffering is not None:
            pulumi.set(__self__, "response_buffering", response_buffering)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if snis is not None:
            pulumi.set(__self__, "snis", snis)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if strip_path is not None:
            pulumi.set(__self__, "strip_path", strip_path)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]]:
        """
        A list of destination `ip` and `port`
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteHeaderArgs']]]]:
        """
        One or more blocks of `name` to set name of header and `values` which is a list of `string` for the header values to match on.  See above example of how to set.  These headers will cause this Route to match if present in the request. The Host header cannot be used with this attribute: hosts should be specified using the hosts attribute.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of domain names that match this Route
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="httpsRedirectStatusCode")
    def https_redirect_status_code(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The status code Kong responds with when all properties of a Route match except the protocol i.e. if the protocol of the request is HTTP instead of HTTPS. Location header is injected by Kong if the field is set to `301`, `302`, `307` or `308`. Accepted values are: `426`, `301`, `302`, `307`, `308`. Default: `426`.
        """
        return pulumi.get(self, "https_redirect_status_code")

    @https_redirect_status_code.setter
    def https_redirect_status_code(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "https_redirect_status_code", value)

    @property
    @pulumi.getter
    def methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of HTTP methods that match this Route
        """
        return pulumi.get(self, "methods")

    @methods.setter
    def methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "methods", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the route
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathHandling")
    def path_handling(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls how the Service path, Route path and requested path are combined when sending a request to the upstream.
        """
        return pulumi.get(self, "path_handling")

    @path_handling.setter
    def path_handling(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path_handling", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of paths that match this Route
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter(name="preserveHost")
    def preserve_host(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        """
        return pulumi.get(self, "preserve_host")

    @preserve_host.setter
    def preserve_host(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "preserve_host", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of protocols to use
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="regexPriority")
    def regex_priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        """
        return pulumi.get(self, "regex_priority")

    @regex_priority.setter
    def regex_priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "regex_priority", value)

    @property
    @pulumi.getter(name="requestBuffering")
    def request_buffering(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable request body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that receive data with chunked transfer encoding. Default: true.
        """
        return pulumi.get(self, "request_buffering")

    @request_buffering.setter
    def request_buffering(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "request_buffering", value)

    @property
    @pulumi.getter(name="responseBuffering")
    def response_buffering(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable response body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that send data with chunked transfer encoding. Default: true.
        """
        return pulumi.get(self, "response_buffering")

    @response_buffering.setter
    def response_buffering(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "response_buffering", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service ID to map to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def snis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of SNIs that match this Route when using stream routing.
        """
        return pulumi.get(self, "snis")

    @snis.setter
    def snis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "snis", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]]:
        """
        A list of source `ip` and `port`
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter(name="stripPath")
    def strip_path(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        """
        return pulumi.get(self, "strip_path")

    @strip_path.setter
    def strip_path(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "strip_path", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the Route for grouping and filtering.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("kong:index/route:Route")
class Route(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteDestinationArgs', 'RouteDestinationArgsDict']]]]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteHeaderArgs', 'RouteHeaderArgsDict']]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 https_redirect_status_code: Optional[pulumi.Input[builtins.int]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_handling: Optional[pulumi.Input[builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preserve_host: Optional[pulumi.Input[builtins.bool]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 regex_priority: Optional[pulumi.Input[builtins.int]] = None,
                 request_buffering: Optional[pulumi.Input[builtins.bool]] = None,
                 response_buffering: Optional[pulumi.Input[builtins.bool]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteSourceArgs', 'RouteSourceArgsDict']]]]] = None,
                 strip_path: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## # Route

        The route resource maps directly onto the json for the route endpoint in Kong. For more information on the parameters [see the Kong Route create documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#route-object).

        To create a tcp/tls route you set `sources` and `destinations` by repeating the corresponding element (`source` or `destination`) for each source or destination you want.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        route = kong.Route("route",
            name="MyRoute",
            protocols=[
                "http",
                "https",
            ],
            methods=[
                "GET",
                "POST",
            ],
            hosts=["example2.com"],
            paths=["/test"],
            strip_path=False,
            preserve_host=True,
            regex_priority=1,
            service_id=service["id"],
            headers=[{
                "name": "x-test-1",
                "values": [
                    "a",
                    "b",
                ],
            }])
        ```

        To create a tcp/tls route you set `sources` and `destinations` by repeating the corresponding element (`source` or `destination`) for each source or destination you want, for example:

        ```python
        import pulumi
        import pulumi_kong as kong

        route = kong.Route("route",
            protocols=["tcp"],
            strip_path=True,
            preserve_host=False,
            sources=[
                {
                    "ip": "192.168.1.1",
                    "port": 80,
                },
                {
                    "ip": "192.168.1.2",
                },
            ],
            destinations=[{
                "ip": "172.10.1.1",
                "port": 81,
            }],
            snis=["foo.com"],
            service_id=service["id"])
        ```

        ## Import

        To import a route:

        ```sh
        $ pulumi import kong:index/route:Route <route_identifier> <route_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouteDestinationArgs', 'RouteDestinationArgsDict']]]] destinations: A list of destination `ip` and `port`
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouteHeaderArgs', 'RouteHeaderArgsDict']]]] headers: One or more blocks of `name` to set name of header and `values` which is a list of `string` for the header values to match on.  See above example of how to set.  These headers will cause this Route to match if present in the request. The Host header cannot be used with this attribute: hosts should be specified using the hosts attribute.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hosts: A list of domain names that match this Route
        :param pulumi.Input[builtins.int] https_redirect_status_code: The status code Kong responds with when all properties of a Route match except the protocol i.e. if the protocol of the request is HTTP instead of HTTPS. Location header is injected by Kong if the field is set to `301`, `302`, `307` or `308`. Accepted values are: `426`, `301`, `302`, `307`, `308`. Default: `426`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] methods: A list of HTTP methods that match this Route
        :param pulumi.Input[builtins.str] name: The name of the route
        :param pulumi.Input[builtins.str] path_handling: Controls how the Service path, Route path and requested path are combined when sending a request to the upstream.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] paths: A list of paths that match this Route
        :param pulumi.Input[builtins.bool] preserve_host: When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] protocols: The list of protocols to use
        :param pulumi.Input[builtins.int] regex_priority: A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        :param pulumi.Input[builtins.bool] request_buffering: Whether to enable request body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that receive data with chunked transfer encoding. Default: true.
        :param pulumi.Input[builtins.bool] response_buffering: Whether to enable response body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that send data with chunked transfer encoding. Default: true.
        :param pulumi.Input[builtins.str] service_id: Service ID to map to
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snis: A list of SNIs that match this Route when using stream routing.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouteSourceArgs', 'RouteSourceArgsDict']]]] sources: A list of source `ip` and `port`
        :param pulumi.Input[builtins.bool] strip_path: When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Route for grouping and filtering.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Route

        The route resource maps directly onto the json for the route endpoint in Kong. For more information on the parameters [see the Kong Route create documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#route-object).

        To create a tcp/tls route you set `sources` and `destinations` by repeating the corresponding element (`source` or `destination`) for each source or destination you want.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        route = kong.Route("route",
            name="MyRoute",
            protocols=[
                "http",
                "https",
            ],
            methods=[
                "GET",
                "POST",
            ],
            hosts=["example2.com"],
            paths=["/test"],
            strip_path=False,
            preserve_host=True,
            regex_priority=1,
            service_id=service["id"],
            headers=[{
                "name": "x-test-1",
                "values": [
                    "a",
                    "b",
                ],
            }])
        ```

        To create a tcp/tls route you set `sources` and `destinations` by repeating the corresponding element (`source` or `destination`) for each source or destination you want, for example:

        ```python
        import pulumi
        import pulumi_kong as kong

        route = kong.Route("route",
            protocols=["tcp"],
            strip_path=True,
            preserve_host=False,
            sources=[
                {
                    "ip": "192.168.1.1",
                    "port": 80,
                },
                {
                    "ip": "192.168.1.2",
                },
            ],
            destinations=[{
                "ip": "172.10.1.1",
                "port": 81,
            }],
            snis=["foo.com"],
            service_id=service["id"])
        ```

        ## Import

        To import a route:

        ```sh
        $ pulumi import kong:index/route:Route <route_identifier> <route_id>
        ```

        :param str resource_name: The name of the resource.
        :param RouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteDestinationArgs', 'RouteDestinationArgsDict']]]]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteHeaderArgs', 'RouteHeaderArgsDict']]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 https_redirect_status_code: Optional[pulumi.Input[builtins.int]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_handling: Optional[pulumi.Input[builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 preserve_host: Optional[pulumi.Input[builtins.bool]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 regex_priority: Optional[pulumi.Input[builtins.int]] = None,
                 request_buffering: Optional[pulumi.Input[builtins.bool]] = None,
                 response_buffering: Optional[pulumi.Input[builtins.bool]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteSourceArgs', 'RouteSourceArgsDict']]]]] = None,
                 strip_path: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteArgs.__new__(RouteArgs)

            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["headers"] = headers
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["https_redirect_status_code"] = https_redirect_status_code
            __props__.__dict__["methods"] = methods
            __props__.__dict__["name"] = name
            __props__.__dict__["path_handling"] = path_handling
            __props__.__dict__["paths"] = paths
            __props__.__dict__["preserve_host"] = preserve_host
            if protocols is None and not opts.urn:
                raise TypeError("Missing required property 'protocols'")
            __props__.__dict__["protocols"] = protocols
            __props__.__dict__["regex_priority"] = regex_priority
            __props__.__dict__["request_buffering"] = request_buffering
            __props__.__dict__["response_buffering"] = response_buffering
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["snis"] = snis
            __props__.__dict__["sources"] = sources
            __props__.__dict__["strip_path"] = strip_path
            __props__.__dict__["tags"] = tags
        super(Route, __self__).__init__(
            'kong:index/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteDestinationArgs', 'RouteDestinationArgsDict']]]]] = None,
            headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteHeaderArgs', 'RouteHeaderArgsDict']]]]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            https_redirect_status_code: Optional[pulumi.Input[builtins.int]] = None,
            methods: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            path_handling: Optional[pulumi.Input[builtins.str]] = None,
            paths: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            preserve_host: Optional[pulumi.Input[builtins.bool]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            regex_priority: Optional[pulumi.Input[builtins.int]] = None,
            request_buffering: Optional[pulumi.Input[builtins.bool]] = None,
            response_buffering: Optional[pulumi.Input[builtins.bool]] = None,
            service_id: Optional[pulumi.Input[builtins.str]] = None,
            snis: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteSourceArgs', 'RouteSourceArgsDict']]]]] = None,
            strip_path: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Route':
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouteDestinationArgs', 'RouteDestinationArgsDict']]]] destinations: A list of destination `ip` and `port`
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouteHeaderArgs', 'RouteHeaderArgsDict']]]] headers: One or more blocks of `name` to set name of header and `values` which is a list of `string` for the header values to match on.  See above example of how to set.  These headers will cause this Route to match if present in the request. The Host header cannot be used with this attribute: hosts should be specified using the hosts attribute.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hosts: A list of domain names that match this Route
        :param pulumi.Input[builtins.int] https_redirect_status_code: The status code Kong responds with when all properties of a Route match except the protocol i.e. if the protocol of the request is HTTP instead of HTTPS. Location header is injected by Kong if the field is set to `301`, `302`, `307` or `308`. Accepted values are: `426`, `301`, `302`, `307`, `308`. Default: `426`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] methods: A list of HTTP methods that match this Route
        :param pulumi.Input[builtins.str] name: The name of the route
        :param pulumi.Input[builtins.str] path_handling: Controls how the Service path, Route path and requested path are combined when sending a request to the upstream.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] paths: A list of paths that match this Route
        :param pulumi.Input[builtins.bool] preserve_host: When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] protocols: The list of protocols to use
        :param pulumi.Input[builtins.int] regex_priority: A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        :param pulumi.Input[builtins.bool] request_buffering: Whether to enable request body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that receive data with chunked transfer encoding. Default: true.
        :param pulumi.Input[builtins.bool] response_buffering: Whether to enable response body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that send data with chunked transfer encoding. Default: true.
        :param pulumi.Input[builtins.str] service_id: Service ID to map to
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snis: A list of SNIs that match this Route when using stream routing.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouteSourceArgs', 'RouteSourceArgsDict']]]] sources: A list of source `ip` and `port`
        :param pulumi.Input[builtins.bool] strip_path: When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Route for grouping and filtering.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteState.__new__(_RouteState)

        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["headers"] = headers
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["https_redirect_status_code"] = https_redirect_status_code
        __props__.__dict__["methods"] = methods
        __props__.__dict__["name"] = name
        __props__.__dict__["path_handling"] = path_handling
        __props__.__dict__["paths"] = paths
        __props__.__dict__["preserve_host"] = preserve_host
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["regex_priority"] = regex_priority
        __props__.__dict__["request_buffering"] = request_buffering
        __props__.__dict__["response_buffering"] = response_buffering
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["snis"] = snis
        __props__.__dict__["sources"] = sources
        __props__.__dict__["strip_path"] = strip_path
        __props__.__dict__["tags"] = tags
        return Route(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Optional[Sequence['outputs.RouteDestination']]]:
        """
        A list of destination `ip` and `port`
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Sequence['outputs.RouteHeader']]]:
        """
        One or more blocks of `name` to set name of header and `values` which is a list of `string` for the header values to match on.  See above example of how to set.  These headers will cause this Route to match if present in the request. The Host header cannot be used with this attribute: hosts should be specified using the hosts attribute.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of domain names that match this Route
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="httpsRedirectStatusCode")
    def https_redirect_status_code(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The status code Kong responds with when all properties of a Route match except the protocol i.e. if the protocol of the request is HTTP instead of HTTPS. Location header is injected by Kong if the field is set to `301`, `302`, `307` or `308`. Accepted values are: `426`, `301`, `302`, `307`, `308`. Default: `426`.
        """
        return pulumi.get(self, "https_redirect_status_code")

    @property
    @pulumi.getter
    def methods(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of HTTP methods that match this Route
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the route
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathHandling")
    def path_handling(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Controls how the Service path, Route path and requested path are combined when sending a request to the upstream.
        """
        return pulumi.get(self, "path_handling")

    @property
    @pulumi.getter
    def paths(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of paths that match this Route
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="preserveHost")
    def preserve_host(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        """
        return pulumi.get(self, "preserve_host")

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of protocols to use
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="regexPriority")
    def regex_priority(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        """
        return pulumi.get(self, "regex_priority")

    @property
    @pulumi.getter(name="requestBuffering")
    def request_buffering(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable request body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that receive data with chunked transfer encoding. Default: true.
        """
        return pulumi.get(self, "request_buffering")

    @property
    @pulumi.getter(name="responseBuffering")
    def response_buffering(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable response body buffering or not. With HTTP 1.1, it may make sense to turn this off on services that send data with chunked transfer encoding. Default: true.
        """
        return pulumi.get(self, "response_buffering")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[builtins.str]:
        """
        Service ID to map to
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter
    def snis(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of SNIs that match this Route when using stream routing.
        """
        return pulumi.get(self, "snis")

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence['outputs.RouteSource']]]:
        """
        A list of source `ip` and `port`
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="stripPath")
    def strip_path(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        """
        return pulumi.get(self, "strip_path")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of strings associated with the Route for grouping and filtering.
        """
        return pulumi.get(self, "tags")

