# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[builtins.str],
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 connect_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 read_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 tls_verify_depth: Optional[pulumi.Input[builtins.int]] = None,
                 write_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[builtins.str] protocol: Protocol to use
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ca_certificate_ids: A of CA Certificate IDs (created from the certificate resource). that are used to build the trust store while verifying upstream server’s TLS certificate.
        :param pulumi.Input[builtins.str] client_certificate_id: ID of Certificate to be used as client certificate while TLS handshaking to the upstream server. Use ID from `Certificate` resource
        :param pulumi.Input[builtins.int] connect_timeout: Connection timeout. Default(ms): 60000
        :param pulumi.Input[builtins.str] host: Host to map to
        :param pulumi.Input[builtins.str] name: Service name
        :param pulumi.Input[builtins.str] path: Path to map to
        :param pulumi.Input[builtins.int] port: Port to map to. Default: 80
        :param pulumi.Input[builtins.int] read_timeout: Read timeout. Default(ms): 60000
        :param pulumi.Input[builtins.int] retries: Number of retries. Default: 5
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Service for grouping and filtering.
        :param pulumi.Input[builtins.bool] tls_verify: Whether to enable verification of upstream server TLS certificate. If not set then the nginx default is respected.
        :param pulumi.Input[builtins.int] tls_verify_depth: Maximum depth of chain while verifying Upstream server’s TLS certificate.
        :param pulumi.Input[builtins.int] write_timeout: Write timout. Default(ms): 60000
        """
        pulumi.set(__self__, "protocol", protocol)
        if ca_certificate_ids is not None:
            pulumi.set(__self__, "ca_certificate_ids", ca_certificate_ids)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_verify is not None:
            pulumi.set(__self__, "tls_verify", tls_verify)
        if tls_verify_depth is not None:
            pulumi.set(__self__, "tls_verify_depth", tls_verify_depth)
        if write_timeout is not None:
            pulumi.set(__self__, "write_timeout", write_timeout)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        Protocol to use
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A of CA Certificate IDs (created from the certificate resource). that are used to build the trust store while verifying upstream server’s TLS certificate.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @ca_certificate_ids.setter
    def ca_certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ca_certificate_ids", value)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of Certificate to be used as client certificate while TLS handshaking to the upstream server. Use ID from `Certificate` resource
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_id", value)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Connection timeout. Default(ms): 60000
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Host to map to
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to map to
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port to map to. Default: 80
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Read timeout. Default(ms): 60000
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "read_timeout", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of retries. Default: 5
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the Service for grouping and filtering.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsVerify")
    def tls_verify(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable verification of upstream server TLS certificate. If not set then the nginx default is respected.
        """
        return pulumi.get(self, "tls_verify")

    @tls_verify.setter
    def tls_verify(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_verify", value)

    @property
    @pulumi.getter(name="tlsVerifyDepth")
    def tls_verify_depth(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum depth of chain while verifying Upstream server’s TLS certificate.
        """
        return pulumi.get(self, "tls_verify_depth")

    @tls_verify_depth.setter
    def tls_verify_depth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tls_verify_depth", value)

    @property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Write timout. Default(ms): 60000
        """
        return pulumi.get(self, "write_timeout")

    @write_timeout.setter
    def write_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "write_timeout", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 connect_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 read_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 tls_verify_depth: Optional[pulumi.Input[builtins.int]] = None,
                 write_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ca_certificate_ids: A of CA Certificate IDs (created from the certificate resource). that are used to build the trust store while verifying upstream server’s TLS certificate.
        :param pulumi.Input[builtins.str] client_certificate_id: ID of Certificate to be used as client certificate while TLS handshaking to the upstream server. Use ID from `Certificate` resource
        :param pulumi.Input[builtins.int] connect_timeout: Connection timeout. Default(ms): 60000
        :param pulumi.Input[builtins.str] host: Host to map to
        :param pulumi.Input[builtins.str] name: Service name
        :param pulumi.Input[builtins.str] path: Path to map to
        :param pulumi.Input[builtins.int] port: Port to map to. Default: 80
        :param pulumi.Input[builtins.str] protocol: Protocol to use
        :param pulumi.Input[builtins.int] read_timeout: Read timeout. Default(ms): 60000
        :param pulumi.Input[builtins.int] retries: Number of retries. Default: 5
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Service for grouping and filtering.
        :param pulumi.Input[builtins.bool] tls_verify: Whether to enable verification of upstream server TLS certificate. If not set then the nginx default is respected.
        :param pulumi.Input[builtins.int] tls_verify_depth: Maximum depth of chain while verifying Upstream server’s TLS certificate.
        :param pulumi.Input[builtins.int] write_timeout: Write timout. Default(ms): 60000
        """
        if ca_certificate_ids is not None:
            pulumi.set(__self__, "ca_certificate_ids", ca_certificate_ids)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_verify is not None:
            pulumi.set(__self__, "tls_verify", tls_verify)
        if tls_verify_depth is not None:
            pulumi.set(__self__, "tls_verify_depth", tls_verify_depth)
        if write_timeout is not None:
            pulumi.set(__self__, "write_timeout", write_timeout)

    @property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A of CA Certificate IDs (created from the certificate resource). that are used to build the trust store while verifying upstream server’s TLS certificate.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @ca_certificate_ids.setter
    def ca_certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ca_certificate_ids", value)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of Certificate to be used as client certificate while TLS handshaking to the upstream server. Use ID from `Certificate` resource
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_id", value)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Connection timeout. Default(ms): 60000
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Host to map to
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to map to
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port to map to. Default: 80
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol to use
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Read timeout. Default(ms): 60000
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "read_timeout", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of retries. Default: 5
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the Service for grouping and filtering.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsVerify")
    def tls_verify(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable verification of upstream server TLS certificate. If not set then the nginx default is respected.
        """
        return pulumi.get(self, "tls_verify")

    @tls_verify.setter
    def tls_verify(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_verify", value)

    @property
    @pulumi.getter(name="tlsVerifyDepth")
    def tls_verify_depth(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum depth of chain while verifying Upstream server’s TLS certificate.
        """
        return pulumi.get(self, "tls_verify_depth")

    @tls_verify_depth.setter
    def tls_verify_depth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tls_verify_depth", value)

    @property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Write timout. Default(ms): 60000
        """
        return pulumi.get(self, "write_timeout")

    @write_timeout.setter
    def write_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "write_timeout", value)


@pulumi.type_token("kong:index/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 connect_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 read_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 tls_verify_depth: Optional[pulumi.Input[builtins.int]] = None,
                 write_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        ## # Service

        The service resource maps directly onto the json for the service endpoint in Kong.  For more information on the parameters [see the Kong Service create documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#service-object).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        service = kong.Service("service",
            name="test",
            protocol="http",
            host="test.org",
            port=8080,
            path="/mypath",
            retries=5,
            connect_timeout=1000,
            write_timeout=2000,
            read_timeout=3000)
        ```

        To use a client certificate and ca certificates combine with certificate resource (note protocol must be `https`):

        ```python
        import pulumi
        import pulumi_kong as kong

        certificate = kong.Certificate("certificate",
            certificate=\"\"\"    -----BEGIN CERTIFICATE-----
            ......
            -----END CERTIFICATE-----
        \"\"\",
            private_key=\"\"\"    -----BEGIN PRIVATE KEY-----
            .....
            -----END PRIVATE KEY-----
        \"\"\",
            snis=["foo.com"])
        ca = kong.Certificate("ca",
            certificate=\"\"\"    -----BEGIN CERTIFICATE-----
            ......
            -----END CERTIFICATE-----
        \"\"\",
            private_key=\"\"\"    -----BEGIN PRIVATE KEY-----
            .....
            -----END PRIVATE KEY-----
        \"\"\",
            snis=["ca.com"])
        service = kong.Service("service",
            name="test",
            protocol="https",
            host="test.org",
            tls_verify=True,
            tls_verify_depth=2,
            client_certificate_id=certificate.id,
            ca_certificate_ids=[ca.id])
        ```

        ## Import

        To import a service:

        ```sh
        $ pulumi import kong:index/service:Service <service_identifier> <service_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ca_certificate_ids: A of CA Certificate IDs (created from the certificate resource). that are used to build the trust store while verifying upstream server’s TLS certificate.
        :param pulumi.Input[builtins.str] client_certificate_id: ID of Certificate to be used as client certificate while TLS handshaking to the upstream server. Use ID from `Certificate` resource
        :param pulumi.Input[builtins.int] connect_timeout: Connection timeout. Default(ms): 60000
        :param pulumi.Input[builtins.str] host: Host to map to
        :param pulumi.Input[builtins.str] name: Service name
        :param pulumi.Input[builtins.str] path: Path to map to
        :param pulumi.Input[builtins.int] port: Port to map to. Default: 80
        :param pulumi.Input[builtins.str] protocol: Protocol to use
        :param pulumi.Input[builtins.int] read_timeout: Read timeout. Default(ms): 60000
        :param pulumi.Input[builtins.int] retries: Number of retries. Default: 5
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Service for grouping and filtering.
        :param pulumi.Input[builtins.bool] tls_verify: Whether to enable verification of upstream server TLS certificate. If not set then the nginx default is respected.
        :param pulumi.Input[builtins.int] tls_verify_depth: Maximum depth of chain while verifying Upstream server’s TLS certificate.
        :param pulumi.Input[builtins.int] write_timeout: Write timout. Default(ms): 60000
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Service

        The service resource maps directly onto the json for the service endpoint in Kong.  For more information on the parameters [see the Kong Service create documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#service-object).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        service = kong.Service("service",
            name="test",
            protocol="http",
            host="test.org",
            port=8080,
            path="/mypath",
            retries=5,
            connect_timeout=1000,
            write_timeout=2000,
            read_timeout=3000)
        ```

        To use a client certificate and ca certificates combine with certificate resource (note protocol must be `https`):

        ```python
        import pulumi
        import pulumi_kong as kong

        certificate = kong.Certificate("certificate",
            certificate=\"\"\"    -----BEGIN CERTIFICATE-----
            ......
            -----END CERTIFICATE-----
        \"\"\",
            private_key=\"\"\"    -----BEGIN PRIVATE KEY-----
            .....
            -----END PRIVATE KEY-----
        \"\"\",
            snis=["foo.com"])
        ca = kong.Certificate("ca",
            certificate=\"\"\"    -----BEGIN CERTIFICATE-----
            ......
            -----END CERTIFICATE-----
        \"\"\",
            private_key=\"\"\"    -----BEGIN PRIVATE KEY-----
            .....
            -----END PRIVATE KEY-----
        \"\"\",
            snis=["ca.com"])
        service = kong.Service("service",
            name="test",
            protocol="https",
            host="test.org",
            tls_verify=True,
            tls_verify_depth=2,
            client_certificate_id=certificate.id,
            ca_certificate_ids=[ca.id])
        ```

        ## Import

        To import a service:

        ```sh
        $ pulumi import kong:index/service:Service <service_identifier> <service_id>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 connect_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 read_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 tls_verify_depth: Optional[pulumi.Input[builtins.int]] = None,
                 write_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["ca_certificate_ids"] = ca_certificate_ids
            __props__.__dict__["client_certificate_id"] = client_certificate_id
            __props__.__dict__["connect_timeout"] = connect_timeout
            __props__.__dict__["host"] = host
            __props__.__dict__["name"] = name
            __props__.__dict__["path"] = path
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["read_timeout"] = read_timeout
            __props__.__dict__["retries"] = retries
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls_verify"] = tls_verify
            __props__.__dict__["tls_verify_depth"] = tls_verify_depth
            __props__.__dict__["write_timeout"] = write_timeout
        super(Service, __self__).__init__(
            'kong:index/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
            connect_timeout: Optional[pulumi.Input[builtins.int]] = None,
            host: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            path: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            read_timeout: Optional[pulumi.Input[builtins.int]] = None,
            retries: Optional[pulumi.Input[builtins.int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tls_verify: Optional[pulumi.Input[builtins.bool]] = None,
            tls_verify_depth: Optional[pulumi.Input[builtins.int]] = None,
            write_timeout: Optional[pulumi.Input[builtins.int]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ca_certificate_ids: A of CA Certificate IDs (created from the certificate resource). that are used to build the trust store while verifying upstream server’s TLS certificate.
        :param pulumi.Input[builtins.str] client_certificate_id: ID of Certificate to be used as client certificate while TLS handshaking to the upstream server. Use ID from `Certificate` resource
        :param pulumi.Input[builtins.int] connect_timeout: Connection timeout. Default(ms): 60000
        :param pulumi.Input[builtins.str] host: Host to map to
        :param pulumi.Input[builtins.str] name: Service name
        :param pulumi.Input[builtins.str] path: Path to map to
        :param pulumi.Input[builtins.int] port: Port to map to. Default: 80
        :param pulumi.Input[builtins.str] protocol: Protocol to use
        :param pulumi.Input[builtins.int] read_timeout: Read timeout. Default(ms): 60000
        :param pulumi.Input[builtins.int] retries: Number of retries. Default: 5
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Service for grouping and filtering.
        :param pulumi.Input[builtins.bool] tls_verify: Whether to enable verification of upstream server TLS certificate. If not set then the nginx default is respected.
        :param pulumi.Input[builtins.int] tls_verify_depth: Maximum depth of chain while verifying Upstream server’s TLS certificate.
        :param pulumi.Input[builtins.int] write_timeout: Write timout. Default(ms): 60000
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["ca_certificate_ids"] = ca_certificate_ids
        __props__.__dict__["client_certificate_id"] = client_certificate_id
        __props__.__dict__["connect_timeout"] = connect_timeout
        __props__.__dict__["host"] = host
        __props__.__dict__["name"] = name
        __props__.__dict__["path"] = path
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["read_timeout"] = read_timeout
        __props__.__dict__["retries"] = retries
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls_verify"] = tls_verify
        __props__.__dict__["tls_verify_depth"] = tls_verify_depth
        __props__.__dict__["write_timeout"] = write_timeout
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A of CA Certificate IDs (created from the certificate resource). that are used to build the trust store while verifying upstream server’s TLS certificate.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID of Certificate to be used as client certificate while TLS handshaking to the upstream server. Use ID from `Certificate` resource
        """
        return pulumi.get(self, "client_certificate_id")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Connection timeout. Default(ms): 60000
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Host to map to
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Path to map to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Port to map to. Default: 80
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        Protocol to use
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Read timeout. Default(ms): 60000
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter
    def retries(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Number of retries. Default: 5
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of strings associated with the Service for grouping and filtering.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsVerify")
    def tls_verify(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable verification of upstream server TLS certificate. If not set then the nginx default is respected.
        """
        return pulumi.get(self, "tls_verify")

    @property
    @pulumi.getter(name="tlsVerifyDepth")
    def tls_verify_depth(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Maximum depth of chain while verifying Upstream server’s TLS certificate.
        """
        return pulumi.get(self, "tls_verify_depth")

    @property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Write timout. Default(ms): 60000
        """
        return pulumi.get(self, "write_timeout")

