# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UpstreamArgs', 'Upstream']

@pulumi.input_type
class UpstreamArgs:
    def __init__(__self__, *,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 hash_fallback: Optional[pulumi.Input[builtins.str]] = None,
                 hash_fallback_header: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_cookie: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_cookie_path: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_header: Optional[pulumi.Input[builtins.str]] = None,
                 healthchecks: Optional[pulumi.Input['UpstreamHealthchecksArgs']] = None,
                 host_header: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slots: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Upstream resource.
        :param pulumi.Input[builtins.str] client_certificate_id: The ID of the client certificate to use (from certificate resource) while TLS handshaking to the upstream server.
        :param pulumi.Input[builtins.str] hash_fallback: is a hashing input type if the primary `hash_on` does not return a hash (eg. header is missing, or no consumer identified). One of: `none`, `consumer`, `ip`, `header`, or `cookie`. Not available if `hash_on` is set to `cookie`. Defaults to `none`.
        :param pulumi.Input[builtins.str] hash_fallback_header: is a header name to take the value from as hash input. Only required when `hash_fallback` is set to `header`. Default `nil`.
        :param pulumi.Input[builtins.str] hash_on: is a hashing input type: `none `(resulting in a weighted*round*robin scheme with no hashing), `consumer`, `ip`, `header`, or `cookie`. Defaults to `none`.
        :param pulumi.Input[builtins.str] hash_on_cookie: is a cookie name to take the value from as hash input. Only required when `hash_on` or `hash_fallback` is set to `cookie`. If the specified cookie is not in the request, Kong will generate a value and set the cookie in the response. Default `nil`.
        :param pulumi.Input[builtins.str] hash_on_cookie_path: is a cookie path to set in the response headers. Only required when `hash_on` or `hash_fallback` is set to `cookie`. Defaults to `/`.
               * `healthchecks.active.type` - (Optional) is a active health check type. HTTP or HTTPS, or just attempt a TCP connection. Possible values are `tcp`, `http` or `https`. Defaults to `http`.
               * `healthchecks.active.timeout` - (Optional) is a socket timeout for active health checks (in seconds). Defaults to `1`.
               * `healthchecks.active.concurrency` - (Optional) is a number of targets to check concurrently in active health checks. Defaults to `10`.
               * `healthchecks.active.http_path` - (Optional) is a path to use in GET HTTP request to run as a probe on active health checks. Defaults to `/`.
               * `healthchecks.active.https_verify_certificate` - (Optional) check the validity of the SSL certificate of the remote host when performing active health checks using HTTPS. Defaults to `true`.
               * `healthchecks.active.https_sni` - (Optional) is the hostname to use as an SNI (Server Name Identification) when performing active health checks using HTTPS. This is particularly useful when Targets are configured using IPs, so that the target host’s certificate can be verified with the proper SNI. Default `nil`.
               * `healthchecks.active.healthy.interval` - (Optional) is an interval between active health checks for healthy targets (in seconds). A value of zero indicates that active probes for healthy targets should not be performed. Defaults to `0`.
               * `healthchecks.active.healthy.successes` - (Optional) is a number of successes in active probes (as defined by `healthchecks.active.healthy.http_statuses`) to consider a target healthy. Defaults to `0`.
               * `healthchecks.active.healthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a success, indicating healthiness, when returned by a probe in active health checks. Defaults to `[200, 302]`.
               * `healthchecks.active.unhealthy.interval` - (Optional) is an interval between active health checks for unhealthy targets (in seconds). A value of zero indicates that active probes for unhealthy targets should not be performed. Defaults to `0`.
               * `healthchecks.active.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in active probes to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.http_failures` - (Optional) is a number of HTTP failures in active probes (as defined by `healthchecks.active.unhealthy.http_statuses`) to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.timeouts` - (Optional) is a number of timeouts in active probes to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a failure, indicating unhealthiness, when returned by a probe in active health checks. Defaults to `[429, 404, 500, 501, 502, 503, 504, 505]`.
               * `healthchecks.passive.type` - (Optional) is a passive health check type. Interpreting HTTP/HTTPS statuses, or just check for TCP connection success. Possible values are `tcp`, `http` or `https` (in passive checks, `http` and `https` options are equivalent.). Defaults to `http`.
               * `healthchecks.passive.healthy.successes` - (Optional) is a Number of successes in proxied traffic (as defined by `healthchecks.passive.healthy.http_statuses`) to consider a target healthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.healthy.http_statuses` - (Optional) is an array of HTTP statuses which represent healthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[200, 201, 202, 203, 204, 205, 206, 207, 208, 226, 300, 301, 302, 303, 304, 305, 306, 307, 308]`.
               * `healthchecks.passive.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.http_failures` - (Optional) is a number of HTTP failures in proxied traffic (as defined by `healthchecks.passive.unhealthy.http_statuses`) to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.timeouts` - (Optional) is a number of timeouts in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses which represent unhealthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[429, 500, 503]`.
        :param pulumi.Input[builtins.str] hash_on_header: is a header name to take the value from as hash input. Only required when `hash_on` is set to `header`. Default `nil`.
        :param pulumi.Input[builtins.str] host_header: The hostname to be used as Host header when proxying requests through Kong.
        :param pulumi.Input[builtins.str] name: is a hostname, which must be equal to the host of a Service.
        :param pulumi.Input[builtins.int] slots: is the number of slots in the load balancer algorithm (10*65536, defaults to 10000).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Upstream for grouping and filtering.
        """
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if hash_fallback is not None:
            pulumi.set(__self__, "hash_fallback", hash_fallback)
        if hash_fallback_header is not None:
            pulumi.set(__self__, "hash_fallback_header", hash_fallback_header)
        if hash_on is not None:
            pulumi.set(__self__, "hash_on", hash_on)
        if hash_on_cookie is not None:
            pulumi.set(__self__, "hash_on_cookie", hash_on_cookie)
        if hash_on_cookie_path is not None:
            pulumi.set(__self__, "hash_on_cookie_path", hash_on_cookie_path)
        if hash_on_header is not None:
            pulumi.set(__self__, "hash_on_header", hash_on_header)
        if healthchecks is not None:
            pulumi.set(__self__, "healthchecks", healthchecks)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slots is not None:
            pulumi.set(__self__, "slots", slots)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the client certificate to use (from certificate resource) while TLS handshaking to the upstream server.
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_id", value)

    @property
    @pulumi.getter(name="hashFallback")
    def hash_fallback(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a hashing input type if the primary `hash_on` does not return a hash (eg. header is missing, or no consumer identified). One of: `none`, `consumer`, `ip`, `header`, or `cookie`. Not available if `hash_on` is set to `cookie`. Defaults to `none`.
        """
        return pulumi.get(self, "hash_fallback")

    @hash_fallback.setter
    def hash_fallback(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_fallback", value)

    @property
    @pulumi.getter(name="hashFallbackHeader")
    def hash_fallback_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a header name to take the value from as hash input. Only required when `hash_fallback` is set to `header`. Default `nil`.
        """
        return pulumi.get(self, "hash_fallback_header")

    @hash_fallback_header.setter
    def hash_fallback_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_fallback_header", value)

    @property
    @pulumi.getter(name="hashOn")
    def hash_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a hashing input type: `none `(resulting in a weighted*round*robin scheme with no hashing), `consumer`, `ip`, `header`, or `cookie`. Defaults to `none`.
        """
        return pulumi.get(self, "hash_on")

    @hash_on.setter
    def hash_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_on", value)

    @property
    @pulumi.getter(name="hashOnCookie")
    def hash_on_cookie(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a cookie name to take the value from as hash input. Only required when `hash_on` or `hash_fallback` is set to `cookie`. If the specified cookie is not in the request, Kong will generate a value and set the cookie in the response. Default `nil`.
        """
        return pulumi.get(self, "hash_on_cookie")

    @hash_on_cookie.setter
    def hash_on_cookie(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_on_cookie", value)

    @property
    @pulumi.getter(name="hashOnCookiePath")
    def hash_on_cookie_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a cookie path to set in the response headers. Only required when `hash_on` or `hash_fallback` is set to `cookie`. Defaults to `/`.
        * `healthchecks.active.type` - (Optional) is a active health check type. HTTP or HTTPS, or just attempt a TCP connection. Possible values are `tcp`, `http` or `https`. Defaults to `http`.
        * `healthchecks.active.timeout` - (Optional) is a socket timeout for active health checks (in seconds). Defaults to `1`.
        * `healthchecks.active.concurrency` - (Optional) is a number of targets to check concurrently in active health checks. Defaults to `10`.
        * `healthchecks.active.http_path` - (Optional) is a path to use in GET HTTP request to run as a probe on active health checks. Defaults to `/`.
        * `healthchecks.active.https_verify_certificate` - (Optional) check the validity of the SSL certificate of the remote host when performing active health checks using HTTPS. Defaults to `true`.
        * `healthchecks.active.https_sni` - (Optional) is the hostname to use as an SNI (Server Name Identification) when performing active health checks using HTTPS. This is particularly useful when Targets are configured using IPs, so that the target host’s certificate can be verified with the proper SNI. Default `nil`.
        * `healthchecks.active.healthy.interval` - (Optional) is an interval between active health checks for healthy targets (in seconds). A value of zero indicates that active probes for healthy targets should not be performed. Defaults to `0`.
        * `healthchecks.active.healthy.successes` - (Optional) is a number of successes in active probes (as defined by `healthchecks.active.healthy.http_statuses`) to consider a target healthy. Defaults to `0`.
        * `healthchecks.active.healthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a success, indicating healthiness, when returned by a probe in active health checks. Defaults to `[200, 302]`.
        * `healthchecks.active.unhealthy.interval` - (Optional) is an interval between active health checks for unhealthy targets (in seconds). A value of zero indicates that active probes for unhealthy targets should not be performed. Defaults to `0`.
        * `healthchecks.active.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in active probes to consider a target unhealthy. Defaults to `0`.
        * `healthchecks.active.unhealthy.http_failures` - (Optional) is a number of HTTP failures in active probes (as defined by `healthchecks.active.unhealthy.http_statuses`) to consider a target unhealthy. Defaults to `0`.
        * `healthchecks.active.unhealthy.timeouts` - (Optional) is a number of timeouts in active probes to consider a target unhealthy. Defaults to `0`.
        * `healthchecks.active.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a failure, indicating unhealthiness, when returned by a probe in active health checks. Defaults to `[429, 404, 500, 501, 502, 503, 504, 505]`.
        * `healthchecks.passive.type` - (Optional) is a passive health check type. Interpreting HTTP/HTTPS statuses, or just check for TCP connection success. Possible values are `tcp`, `http` or `https` (in passive checks, `http` and `https` options are equivalent.). Defaults to `http`.
        * `healthchecks.passive.healthy.successes` - (Optional) is a Number of successes in proxied traffic (as defined by `healthchecks.passive.healthy.http_statuses`) to consider a target healthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.healthy.http_statuses` - (Optional) is an array of HTTP statuses which represent healthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[200, 201, 202, 203, 204, 205, 206, 207, 208, 226, 300, 301, 302, 303, 304, 305, 306, 307, 308]`.
        * `healthchecks.passive.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.unhealthy.http_failures` - (Optional) is a number of HTTP failures in proxied traffic (as defined by `healthchecks.passive.unhealthy.http_statuses`) to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.unhealthy.timeouts` - (Optional) is a number of timeouts in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses which represent unhealthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[429, 500, 503]`.
        """
        return pulumi.get(self, "hash_on_cookie_path")

    @hash_on_cookie_path.setter
    def hash_on_cookie_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_on_cookie_path", value)

    @property
    @pulumi.getter(name="hashOnHeader")
    def hash_on_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a header name to take the value from as hash input. Only required when `hash_on` is set to `header`. Default `nil`.
        """
        return pulumi.get(self, "hash_on_header")

    @hash_on_header.setter
    def hash_on_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_on_header", value)

    @property
    @pulumi.getter
    def healthchecks(self) -> Optional[pulumi.Input['UpstreamHealthchecksArgs']]:
        return pulumi.get(self, "healthchecks")

    @healthchecks.setter
    def healthchecks(self, value: Optional[pulumi.Input['UpstreamHealthchecksArgs']]):
        pulumi.set(self, "healthchecks", value)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname to be used as Host header when proxying requests through Kong.
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a hostname, which must be equal to the host of a Service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def slots(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        is the number of slots in the load balancer algorithm (10*65536, defaults to 10000).
        """
        return pulumi.get(self, "slots")

    @slots.setter
    def slots(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "slots", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the Upstream for grouping and filtering.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _UpstreamState:
    def __init__(__self__, *,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 hash_fallback: Optional[pulumi.Input[builtins.str]] = None,
                 hash_fallback_header: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_cookie: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_cookie_path: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_header: Optional[pulumi.Input[builtins.str]] = None,
                 healthchecks: Optional[pulumi.Input['UpstreamHealthchecksArgs']] = None,
                 host_header: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slots: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Upstream resources.
        :param pulumi.Input[builtins.str] client_certificate_id: The ID of the client certificate to use (from certificate resource) while TLS handshaking to the upstream server.
        :param pulumi.Input[builtins.str] hash_fallback: is a hashing input type if the primary `hash_on` does not return a hash (eg. header is missing, or no consumer identified). One of: `none`, `consumer`, `ip`, `header`, or `cookie`. Not available if `hash_on` is set to `cookie`. Defaults to `none`.
        :param pulumi.Input[builtins.str] hash_fallback_header: is a header name to take the value from as hash input. Only required when `hash_fallback` is set to `header`. Default `nil`.
        :param pulumi.Input[builtins.str] hash_on: is a hashing input type: `none `(resulting in a weighted*round*robin scheme with no hashing), `consumer`, `ip`, `header`, or `cookie`. Defaults to `none`.
        :param pulumi.Input[builtins.str] hash_on_cookie: is a cookie name to take the value from as hash input. Only required when `hash_on` or `hash_fallback` is set to `cookie`. If the specified cookie is not in the request, Kong will generate a value and set the cookie in the response. Default `nil`.
        :param pulumi.Input[builtins.str] hash_on_cookie_path: is a cookie path to set in the response headers. Only required when `hash_on` or `hash_fallback` is set to `cookie`. Defaults to `/`.
               * `healthchecks.active.type` - (Optional) is a active health check type. HTTP or HTTPS, or just attempt a TCP connection. Possible values are `tcp`, `http` or `https`. Defaults to `http`.
               * `healthchecks.active.timeout` - (Optional) is a socket timeout for active health checks (in seconds). Defaults to `1`.
               * `healthchecks.active.concurrency` - (Optional) is a number of targets to check concurrently in active health checks. Defaults to `10`.
               * `healthchecks.active.http_path` - (Optional) is a path to use in GET HTTP request to run as a probe on active health checks. Defaults to `/`.
               * `healthchecks.active.https_verify_certificate` - (Optional) check the validity of the SSL certificate of the remote host when performing active health checks using HTTPS. Defaults to `true`.
               * `healthchecks.active.https_sni` - (Optional) is the hostname to use as an SNI (Server Name Identification) when performing active health checks using HTTPS. This is particularly useful when Targets are configured using IPs, so that the target host’s certificate can be verified with the proper SNI. Default `nil`.
               * `healthchecks.active.healthy.interval` - (Optional) is an interval between active health checks for healthy targets (in seconds). A value of zero indicates that active probes for healthy targets should not be performed. Defaults to `0`.
               * `healthchecks.active.healthy.successes` - (Optional) is a number of successes in active probes (as defined by `healthchecks.active.healthy.http_statuses`) to consider a target healthy. Defaults to `0`.
               * `healthchecks.active.healthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a success, indicating healthiness, when returned by a probe in active health checks. Defaults to `[200, 302]`.
               * `healthchecks.active.unhealthy.interval` - (Optional) is an interval between active health checks for unhealthy targets (in seconds). A value of zero indicates that active probes for unhealthy targets should not be performed. Defaults to `0`.
               * `healthchecks.active.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in active probes to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.http_failures` - (Optional) is a number of HTTP failures in active probes (as defined by `healthchecks.active.unhealthy.http_statuses`) to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.timeouts` - (Optional) is a number of timeouts in active probes to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a failure, indicating unhealthiness, when returned by a probe in active health checks. Defaults to `[429, 404, 500, 501, 502, 503, 504, 505]`.
               * `healthchecks.passive.type` - (Optional) is a passive health check type. Interpreting HTTP/HTTPS statuses, or just check for TCP connection success. Possible values are `tcp`, `http` or `https` (in passive checks, `http` and `https` options are equivalent.). Defaults to `http`.
               * `healthchecks.passive.healthy.successes` - (Optional) is a Number of successes in proxied traffic (as defined by `healthchecks.passive.healthy.http_statuses`) to consider a target healthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.healthy.http_statuses` - (Optional) is an array of HTTP statuses which represent healthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[200, 201, 202, 203, 204, 205, 206, 207, 208, 226, 300, 301, 302, 303, 304, 305, 306, 307, 308]`.
               * `healthchecks.passive.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.http_failures` - (Optional) is a number of HTTP failures in proxied traffic (as defined by `healthchecks.passive.unhealthy.http_statuses`) to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.timeouts` - (Optional) is a number of timeouts in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses which represent unhealthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[429, 500, 503]`.
        :param pulumi.Input[builtins.str] hash_on_header: is a header name to take the value from as hash input. Only required when `hash_on` is set to `header`. Default `nil`.
        :param pulumi.Input[builtins.str] host_header: The hostname to be used as Host header when proxying requests through Kong.
        :param pulumi.Input[builtins.str] name: is a hostname, which must be equal to the host of a Service.
        :param pulumi.Input[builtins.int] slots: is the number of slots in the load balancer algorithm (10*65536, defaults to 10000).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Upstream for grouping and filtering.
        """
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if hash_fallback is not None:
            pulumi.set(__self__, "hash_fallback", hash_fallback)
        if hash_fallback_header is not None:
            pulumi.set(__self__, "hash_fallback_header", hash_fallback_header)
        if hash_on is not None:
            pulumi.set(__self__, "hash_on", hash_on)
        if hash_on_cookie is not None:
            pulumi.set(__self__, "hash_on_cookie", hash_on_cookie)
        if hash_on_cookie_path is not None:
            pulumi.set(__self__, "hash_on_cookie_path", hash_on_cookie_path)
        if hash_on_header is not None:
            pulumi.set(__self__, "hash_on_header", hash_on_header)
        if healthchecks is not None:
            pulumi.set(__self__, "healthchecks", healthchecks)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slots is not None:
            pulumi.set(__self__, "slots", slots)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the client certificate to use (from certificate resource) while TLS handshaking to the upstream server.
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_id", value)

    @property
    @pulumi.getter(name="hashFallback")
    def hash_fallback(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a hashing input type if the primary `hash_on` does not return a hash (eg. header is missing, or no consumer identified). One of: `none`, `consumer`, `ip`, `header`, or `cookie`. Not available if `hash_on` is set to `cookie`. Defaults to `none`.
        """
        return pulumi.get(self, "hash_fallback")

    @hash_fallback.setter
    def hash_fallback(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_fallback", value)

    @property
    @pulumi.getter(name="hashFallbackHeader")
    def hash_fallback_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a header name to take the value from as hash input. Only required when `hash_fallback` is set to `header`. Default `nil`.
        """
        return pulumi.get(self, "hash_fallback_header")

    @hash_fallback_header.setter
    def hash_fallback_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_fallback_header", value)

    @property
    @pulumi.getter(name="hashOn")
    def hash_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a hashing input type: `none `(resulting in a weighted*round*robin scheme with no hashing), `consumer`, `ip`, `header`, or `cookie`. Defaults to `none`.
        """
        return pulumi.get(self, "hash_on")

    @hash_on.setter
    def hash_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_on", value)

    @property
    @pulumi.getter(name="hashOnCookie")
    def hash_on_cookie(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a cookie name to take the value from as hash input. Only required when `hash_on` or `hash_fallback` is set to `cookie`. If the specified cookie is not in the request, Kong will generate a value and set the cookie in the response. Default `nil`.
        """
        return pulumi.get(self, "hash_on_cookie")

    @hash_on_cookie.setter
    def hash_on_cookie(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_on_cookie", value)

    @property
    @pulumi.getter(name="hashOnCookiePath")
    def hash_on_cookie_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a cookie path to set in the response headers. Only required when `hash_on` or `hash_fallback` is set to `cookie`. Defaults to `/`.
        * `healthchecks.active.type` - (Optional) is a active health check type. HTTP or HTTPS, or just attempt a TCP connection. Possible values are `tcp`, `http` or `https`. Defaults to `http`.
        * `healthchecks.active.timeout` - (Optional) is a socket timeout for active health checks (in seconds). Defaults to `1`.
        * `healthchecks.active.concurrency` - (Optional) is a number of targets to check concurrently in active health checks. Defaults to `10`.
        * `healthchecks.active.http_path` - (Optional) is a path to use in GET HTTP request to run as a probe on active health checks. Defaults to `/`.
        * `healthchecks.active.https_verify_certificate` - (Optional) check the validity of the SSL certificate of the remote host when performing active health checks using HTTPS. Defaults to `true`.
        * `healthchecks.active.https_sni` - (Optional) is the hostname to use as an SNI (Server Name Identification) when performing active health checks using HTTPS. This is particularly useful when Targets are configured using IPs, so that the target host’s certificate can be verified with the proper SNI. Default `nil`.
        * `healthchecks.active.healthy.interval` - (Optional) is an interval between active health checks for healthy targets (in seconds). A value of zero indicates that active probes for healthy targets should not be performed. Defaults to `0`.
        * `healthchecks.active.healthy.successes` - (Optional) is a number of successes in active probes (as defined by `healthchecks.active.healthy.http_statuses`) to consider a target healthy. Defaults to `0`.
        * `healthchecks.active.healthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a success, indicating healthiness, when returned by a probe in active health checks. Defaults to `[200, 302]`.
        * `healthchecks.active.unhealthy.interval` - (Optional) is an interval between active health checks for unhealthy targets (in seconds). A value of zero indicates that active probes for unhealthy targets should not be performed. Defaults to `0`.
        * `healthchecks.active.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in active probes to consider a target unhealthy. Defaults to `0`.
        * `healthchecks.active.unhealthy.http_failures` - (Optional) is a number of HTTP failures in active probes (as defined by `healthchecks.active.unhealthy.http_statuses`) to consider a target unhealthy. Defaults to `0`.
        * `healthchecks.active.unhealthy.timeouts` - (Optional) is a number of timeouts in active probes to consider a target unhealthy. Defaults to `0`.
        * `healthchecks.active.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a failure, indicating unhealthiness, when returned by a probe in active health checks. Defaults to `[429, 404, 500, 501, 502, 503, 504, 505]`.
        * `healthchecks.passive.type` - (Optional) is a passive health check type. Interpreting HTTP/HTTPS statuses, or just check for TCP connection success. Possible values are `tcp`, `http` or `https` (in passive checks, `http` and `https` options are equivalent.). Defaults to `http`.
        * `healthchecks.passive.healthy.successes` - (Optional) is a Number of successes in proxied traffic (as defined by `healthchecks.passive.healthy.http_statuses`) to consider a target healthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.healthy.http_statuses` - (Optional) is an array of HTTP statuses which represent healthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[200, 201, 202, 203, 204, 205, 206, 207, 208, 226, 300, 301, 302, 303, 304, 305, 306, 307, 308]`.
        * `healthchecks.passive.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.unhealthy.http_failures` - (Optional) is a number of HTTP failures in proxied traffic (as defined by `healthchecks.passive.unhealthy.http_statuses`) to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.unhealthy.timeouts` - (Optional) is a number of timeouts in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses which represent unhealthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[429, 500, 503]`.
        """
        return pulumi.get(self, "hash_on_cookie_path")

    @hash_on_cookie_path.setter
    def hash_on_cookie_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_on_cookie_path", value)

    @property
    @pulumi.getter(name="hashOnHeader")
    def hash_on_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a header name to take the value from as hash input. Only required when `hash_on` is set to `header`. Default `nil`.
        """
        return pulumi.get(self, "hash_on_header")

    @hash_on_header.setter
    def hash_on_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_on_header", value)

    @property
    @pulumi.getter
    def healthchecks(self) -> Optional[pulumi.Input['UpstreamHealthchecksArgs']]:
        return pulumi.get(self, "healthchecks")

    @healthchecks.setter
    def healthchecks(self, value: Optional[pulumi.Input['UpstreamHealthchecksArgs']]):
        pulumi.set(self, "healthchecks", value)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname to be used as Host header when proxying requests through Kong.
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        is a hostname, which must be equal to the host of a Service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def slots(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        is the number of slots in the load balancer algorithm (10*65536, defaults to 10000).
        """
        return pulumi.get(self, "slots")

    @slots.setter
    def slots(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "slots", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of strings associated with the Upstream for grouping and filtering.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("kong:index/upstream:Upstream")
class Upstream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 hash_fallback: Optional[pulumi.Input[builtins.str]] = None,
                 hash_fallback_header: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_cookie: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_cookie_path: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_header: Optional[pulumi.Input[builtins.str]] = None,
                 healthchecks: Optional[pulumi.Input[Union['UpstreamHealthchecksArgs', 'UpstreamHealthchecksArgsDict']]] = None,
                 host_header: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slots: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        certificate = kong.Certificate("certificate",
            certificate=\"\"\"    -----BEGIN CERTIFICATE-----
            ......
            -----END CERTIFICATE-----
        \"\"\",
            private_key=\"\"\"    -----BEGIN PRIVATE KEY-----
            .....
            -----END PRIVATE KEY-----
        \"\"\",
            snis=["foo.com"])
        upstream = kong.Upstream("upstream",
            name="sample_upstream",
            slots=10,
            hash_on="header",
            hash_fallback="cookie",
            hash_on_header="HeaderName",
            hash_fallback_header="FallbackHeaderName",
            hash_on_cookie="CookieName",
            hash_on_cookie_path="/path",
            host_header="x-host",
            tags=[
                "a",
                "b",
            ],
            client_certificate_id=certificate.id,
            healthchecks={
                "active": {
                    "type": "https",
                    "http_path": "/status",
                    "timeout": 10,
                    "concurrency": 20,
                    "https_verify_certificate": False,
                    "https_sni": "some.domain.com",
                    "healthy": {
                        "successes": 1,
                        "interval": 5,
                        "http_statuses": [
                            200,
                            201,
                        ],
                    },
                    "unhealthy": {
                        "timeouts": 7,
                        "interval": 3,
                        "tcp_failures": 1,
                        "http_failures": 2,
                        "http_statuses": [
                            500,
                            501,
                        ],
                    },
                },
                "passive": {
                    "type": "https",
                    "healthy": {
                        "successes": 1,
                        "http_statuses": [
                            200,
                            201,
                            202,
                        ],
                    },
                    "unhealthy": {
                        "timeouts": 3,
                        "tcp_failures": 5,
                        "http_failures": 6,
                        "http_statuses": [
                            500,
                            501,
                            502,
                        ],
                    },
                },
            })
        ```

        ## Import

        To import an upstream:

        ```sh
        $ pulumi import kong:index/upstream:Upstream <upstream_identifier> <upstream_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_certificate_id: The ID of the client certificate to use (from certificate resource) while TLS handshaking to the upstream server.
        :param pulumi.Input[builtins.str] hash_fallback: is a hashing input type if the primary `hash_on` does not return a hash (eg. header is missing, or no consumer identified). One of: `none`, `consumer`, `ip`, `header`, or `cookie`. Not available if `hash_on` is set to `cookie`. Defaults to `none`.
        :param pulumi.Input[builtins.str] hash_fallback_header: is a header name to take the value from as hash input. Only required when `hash_fallback` is set to `header`. Default `nil`.
        :param pulumi.Input[builtins.str] hash_on: is a hashing input type: `none `(resulting in a weighted*round*robin scheme with no hashing), `consumer`, `ip`, `header`, or `cookie`. Defaults to `none`.
        :param pulumi.Input[builtins.str] hash_on_cookie: is a cookie name to take the value from as hash input. Only required when `hash_on` or `hash_fallback` is set to `cookie`. If the specified cookie is not in the request, Kong will generate a value and set the cookie in the response. Default `nil`.
        :param pulumi.Input[builtins.str] hash_on_cookie_path: is a cookie path to set in the response headers. Only required when `hash_on` or `hash_fallback` is set to `cookie`. Defaults to `/`.
               * `healthchecks.active.type` - (Optional) is a active health check type. HTTP or HTTPS, or just attempt a TCP connection. Possible values are `tcp`, `http` or `https`. Defaults to `http`.
               * `healthchecks.active.timeout` - (Optional) is a socket timeout for active health checks (in seconds). Defaults to `1`.
               * `healthchecks.active.concurrency` - (Optional) is a number of targets to check concurrently in active health checks. Defaults to `10`.
               * `healthchecks.active.http_path` - (Optional) is a path to use in GET HTTP request to run as a probe on active health checks. Defaults to `/`.
               * `healthchecks.active.https_verify_certificate` - (Optional) check the validity of the SSL certificate of the remote host when performing active health checks using HTTPS. Defaults to `true`.
               * `healthchecks.active.https_sni` - (Optional) is the hostname to use as an SNI (Server Name Identification) when performing active health checks using HTTPS. This is particularly useful when Targets are configured using IPs, so that the target host’s certificate can be verified with the proper SNI. Default `nil`.
               * `healthchecks.active.healthy.interval` - (Optional) is an interval between active health checks for healthy targets (in seconds). A value of zero indicates that active probes for healthy targets should not be performed. Defaults to `0`.
               * `healthchecks.active.healthy.successes` - (Optional) is a number of successes in active probes (as defined by `healthchecks.active.healthy.http_statuses`) to consider a target healthy. Defaults to `0`.
               * `healthchecks.active.healthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a success, indicating healthiness, when returned by a probe in active health checks. Defaults to `[200, 302]`.
               * `healthchecks.active.unhealthy.interval` - (Optional) is an interval between active health checks for unhealthy targets (in seconds). A value of zero indicates that active probes for unhealthy targets should not be performed. Defaults to `0`.
               * `healthchecks.active.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in active probes to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.http_failures` - (Optional) is a number of HTTP failures in active probes (as defined by `healthchecks.active.unhealthy.http_statuses`) to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.timeouts` - (Optional) is a number of timeouts in active probes to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a failure, indicating unhealthiness, when returned by a probe in active health checks. Defaults to `[429, 404, 500, 501, 502, 503, 504, 505]`.
               * `healthchecks.passive.type` - (Optional) is a passive health check type. Interpreting HTTP/HTTPS statuses, or just check for TCP connection success. Possible values are `tcp`, `http` or `https` (in passive checks, `http` and `https` options are equivalent.). Defaults to `http`.
               * `healthchecks.passive.healthy.successes` - (Optional) is a Number of successes in proxied traffic (as defined by `healthchecks.passive.healthy.http_statuses`) to consider a target healthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.healthy.http_statuses` - (Optional) is an array of HTTP statuses which represent healthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[200, 201, 202, 203, 204, 205, 206, 207, 208, 226, 300, 301, 302, 303, 304, 305, 306, 307, 308]`.
               * `healthchecks.passive.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.http_failures` - (Optional) is a number of HTTP failures in proxied traffic (as defined by `healthchecks.passive.unhealthy.http_statuses`) to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.timeouts` - (Optional) is a number of timeouts in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses which represent unhealthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[429, 500, 503]`.
        :param pulumi.Input[builtins.str] hash_on_header: is a header name to take the value from as hash input. Only required when `hash_on` is set to `header`. Default `nil`.
        :param pulumi.Input[builtins.str] host_header: The hostname to be used as Host header when proxying requests through Kong.
        :param pulumi.Input[builtins.str] name: is a hostname, which must be equal to the host of a Service.
        :param pulumi.Input[builtins.int] slots: is the number of slots in the load balancer algorithm (10*65536, defaults to 10000).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Upstream for grouping and filtering.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[UpstreamArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        certificate = kong.Certificate("certificate",
            certificate=\"\"\"    -----BEGIN CERTIFICATE-----
            ......
            -----END CERTIFICATE-----
        \"\"\",
            private_key=\"\"\"    -----BEGIN PRIVATE KEY-----
            .....
            -----END PRIVATE KEY-----
        \"\"\",
            snis=["foo.com"])
        upstream = kong.Upstream("upstream",
            name="sample_upstream",
            slots=10,
            hash_on="header",
            hash_fallback="cookie",
            hash_on_header="HeaderName",
            hash_fallback_header="FallbackHeaderName",
            hash_on_cookie="CookieName",
            hash_on_cookie_path="/path",
            host_header="x-host",
            tags=[
                "a",
                "b",
            ],
            client_certificate_id=certificate.id,
            healthchecks={
                "active": {
                    "type": "https",
                    "http_path": "/status",
                    "timeout": 10,
                    "concurrency": 20,
                    "https_verify_certificate": False,
                    "https_sni": "some.domain.com",
                    "healthy": {
                        "successes": 1,
                        "interval": 5,
                        "http_statuses": [
                            200,
                            201,
                        ],
                    },
                    "unhealthy": {
                        "timeouts": 7,
                        "interval": 3,
                        "tcp_failures": 1,
                        "http_failures": 2,
                        "http_statuses": [
                            500,
                            501,
                        ],
                    },
                },
                "passive": {
                    "type": "https",
                    "healthy": {
                        "successes": 1,
                        "http_statuses": [
                            200,
                            201,
                            202,
                        ],
                    },
                    "unhealthy": {
                        "timeouts": 3,
                        "tcp_failures": 5,
                        "http_failures": 6,
                        "http_statuses": [
                            500,
                            501,
                            502,
                        ],
                    },
                },
            })
        ```

        ## Import

        To import an upstream:

        ```sh
        $ pulumi import kong:index/upstream:Upstream <upstream_identifier> <upstream_id>
        ```

        :param str resource_name: The name of the resource.
        :param UpstreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UpstreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 hash_fallback: Optional[pulumi.Input[builtins.str]] = None,
                 hash_fallback_header: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_cookie: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_cookie_path: Optional[pulumi.Input[builtins.str]] = None,
                 hash_on_header: Optional[pulumi.Input[builtins.str]] = None,
                 healthchecks: Optional[pulumi.Input[Union['UpstreamHealthchecksArgs', 'UpstreamHealthchecksArgsDict']]] = None,
                 host_header: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slots: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UpstreamArgs.__new__(UpstreamArgs)

            __props__.__dict__["client_certificate_id"] = client_certificate_id
            __props__.__dict__["hash_fallback"] = hash_fallback
            __props__.__dict__["hash_fallback_header"] = hash_fallback_header
            __props__.__dict__["hash_on"] = hash_on
            __props__.__dict__["hash_on_cookie"] = hash_on_cookie
            __props__.__dict__["hash_on_cookie_path"] = hash_on_cookie_path
            __props__.__dict__["hash_on_header"] = hash_on_header
            __props__.__dict__["healthchecks"] = healthchecks
            __props__.__dict__["host_header"] = host_header
            __props__.__dict__["name"] = name
            __props__.__dict__["slots"] = slots
            __props__.__dict__["tags"] = tags
        super(Upstream, __self__).__init__(
            'kong:index/upstream:Upstream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
            hash_fallback: Optional[pulumi.Input[builtins.str]] = None,
            hash_fallback_header: Optional[pulumi.Input[builtins.str]] = None,
            hash_on: Optional[pulumi.Input[builtins.str]] = None,
            hash_on_cookie: Optional[pulumi.Input[builtins.str]] = None,
            hash_on_cookie_path: Optional[pulumi.Input[builtins.str]] = None,
            hash_on_header: Optional[pulumi.Input[builtins.str]] = None,
            healthchecks: Optional[pulumi.Input[Union['UpstreamHealthchecksArgs', 'UpstreamHealthchecksArgsDict']]] = None,
            host_header: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            slots: Optional[pulumi.Input[builtins.int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Upstream':
        """
        Get an existing Upstream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_certificate_id: The ID of the client certificate to use (from certificate resource) while TLS handshaking to the upstream server.
        :param pulumi.Input[builtins.str] hash_fallback: is a hashing input type if the primary `hash_on` does not return a hash (eg. header is missing, or no consumer identified). One of: `none`, `consumer`, `ip`, `header`, or `cookie`. Not available if `hash_on` is set to `cookie`. Defaults to `none`.
        :param pulumi.Input[builtins.str] hash_fallback_header: is a header name to take the value from as hash input. Only required when `hash_fallback` is set to `header`. Default `nil`.
        :param pulumi.Input[builtins.str] hash_on: is a hashing input type: `none `(resulting in a weighted*round*robin scheme with no hashing), `consumer`, `ip`, `header`, or `cookie`. Defaults to `none`.
        :param pulumi.Input[builtins.str] hash_on_cookie: is a cookie name to take the value from as hash input. Only required when `hash_on` or `hash_fallback` is set to `cookie`. If the specified cookie is not in the request, Kong will generate a value and set the cookie in the response. Default `nil`.
        :param pulumi.Input[builtins.str] hash_on_cookie_path: is a cookie path to set in the response headers. Only required when `hash_on` or `hash_fallback` is set to `cookie`. Defaults to `/`.
               * `healthchecks.active.type` - (Optional) is a active health check type. HTTP or HTTPS, or just attempt a TCP connection. Possible values are `tcp`, `http` or `https`. Defaults to `http`.
               * `healthchecks.active.timeout` - (Optional) is a socket timeout for active health checks (in seconds). Defaults to `1`.
               * `healthchecks.active.concurrency` - (Optional) is a number of targets to check concurrently in active health checks. Defaults to `10`.
               * `healthchecks.active.http_path` - (Optional) is a path to use in GET HTTP request to run as a probe on active health checks. Defaults to `/`.
               * `healthchecks.active.https_verify_certificate` - (Optional) check the validity of the SSL certificate of the remote host when performing active health checks using HTTPS. Defaults to `true`.
               * `healthchecks.active.https_sni` - (Optional) is the hostname to use as an SNI (Server Name Identification) when performing active health checks using HTTPS. This is particularly useful when Targets are configured using IPs, so that the target host’s certificate can be verified with the proper SNI. Default `nil`.
               * `healthchecks.active.healthy.interval` - (Optional) is an interval between active health checks for healthy targets (in seconds). A value of zero indicates that active probes for healthy targets should not be performed. Defaults to `0`.
               * `healthchecks.active.healthy.successes` - (Optional) is a number of successes in active probes (as defined by `healthchecks.active.healthy.http_statuses`) to consider a target healthy. Defaults to `0`.
               * `healthchecks.active.healthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a success, indicating healthiness, when returned by a probe in active health checks. Defaults to `[200, 302]`.
               * `healthchecks.active.unhealthy.interval` - (Optional) is an interval between active health checks for unhealthy targets (in seconds). A value of zero indicates that active probes for unhealthy targets should not be performed. Defaults to `0`.
               * `healthchecks.active.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in active probes to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.http_failures` - (Optional) is a number of HTTP failures in active probes (as defined by `healthchecks.active.unhealthy.http_statuses`) to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.timeouts` - (Optional) is a number of timeouts in active probes to consider a target unhealthy. Defaults to `0`.
               * `healthchecks.active.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a failure, indicating unhealthiness, when returned by a probe in active health checks. Defaults to `[429, 404, 500, 501, 502, 503, 504, 505]`.
               * `healthchecks.passive.type` - (Optional) is a passive health check type. Interpreting HTTP/HTTPS statuses, or just check for TCP connection success. Possible values are `tcp`, `http` or `https` (in passive checks, `http` and `https` options are equivalent.). Defaults to `http`.
               * `healthchecks.passive.healthy.successes` - (Optional) is a Number of successes in proxied traffic (as defined by `healthchecks.passive.healthy.http_statuses`) to consider a target healthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.healthy.http_statuses` - (Optional) is an array of HTTP statuses which represent healthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[200, 201, 202, 203, 204, 205, 206, 207, 208, 226, 300, 301, 302, 303, 304, 305, 306, 307, 308]`.
               * `healthchecks.passive.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.http_failures` - (Optional) is a number of HTTP failures in proxied traffic (as defined by `healthchecks.passive.unhealthy.http_statuses`) to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.timeouts` - (Optional) is a number of timeouts in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
               * `healthchecks.passive.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses which represent unhealthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[429, 500, 503]`.
        :param pulumi.Input[builtins.str] hash_on_header: is a header name to take the value from as hash input. Only required when `hash_on` is set to `header`. Default `nil`.
        :param pulumi.Input[builtins.str] host_header: The hostname to be used as Host header when proxying requests through Kong.
        :param pulumi.Input[builtins.str] name: is a hostname, which must be equal to the host of a Service.
        :param pulumi.Input[builtins.int] slots: is the number of slots in the load balancer algorithm (10*65536, defaults to 10000).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of strings associated with the Upstream for grouping and filtering.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UpstreamState.__new__(_UpstreamState)

        __props__.__dict__["client_certificate_id"] = client_certificate_id
        __props__.__dict__["hash_fallback"] = hash_fallback
        __props__.__dict__["hash_fallback_header"] = hash_fallback_header
        __props__.__dict__["hash_on"] = hash_on
        __props__.__dict__["hash_on_cookie"] = hash_on_cookie
        __props__.__dict__["hash_on_cookie_path"] = hash_on_cookie_path
        __props__.__dict__["hash_on_header"] = hash_on_header
        __props__.__dict__["healthchecks"] = healthchecks
        __props__.__dict__["host_header"] = host_header
        __props__.__dict__["name"] = name
        __props__.__dict__["slots"] = slots
        __props__.__dict__["tags"] = tags
        return Upstream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the client certificate to use (from certificate resource) while TLS handshaking to the upstream server.
        """
        return pulumi.get(self, "client_certificate_id")

    @property
    @pulumi.getter(name="hashFallback")
    def hash_fallback(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        is a hashing input type if the primary `hash_on` does not return a hash (eg. header is missing, or no consumer identified). One of: `none`, `consumer`, `ip`, `header`, or `cookie`. Not available if `hash_on` is set to `cookie`. Defaults to `none`.
        """
        return pulumi.get(self, "hash_fallback")

    @property
    @pulumi.getter(name="hashFallbackHeader")
    def hash_fallback_header(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        is a header name to take the value from as hash input. Only required when `hash_fallback` is set to `header`. Default `nil`.
        """
        return pulumi.get(self, "hash_fallback_header")

    @property
    @pulumi.getter(name="hashOn")
    def hash_on(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        is a hashing input type: `none `(resulting in a weighted*round*robin scheme with no hashing), `consumer`, `ip`, `header`, or `cookie`. Defaults to `none`.
        """
        return pulumi.get(self, "hash_on")

    @property
    @pulumi.getter(name="hashOnCookie")
    def hash_on_cookie(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        is a cookie name to take the value from as hash input. Only required when `hash_on` or `hash_fallback` is set to `cookie`. If the specified cookie is not in the request, Kong will generate a value and set the cookie in the response. Default `nil`.
        """
        return pulumi.get(self, "hash_on_cookie")

    @property
    @pulumi.getter(name="hashOnCookiePath")
    def hash_on_cookie_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        is a cookie path to set in the response headers. Only required when `hash_on` or `hash_fallback` is set to `cookie`. Defaults to `/`.
        * `healthchecks.active.type` - (Optional) is a active health check type. HTTP or HTTPS, or just attempt a TCP connection. Possible values are `tcp`, `http` or `https`. Defaults to `http`.
        * `healthchecks.active.timeout` - (Optional) is a socket timeout for active health checks (in seconds). Defaults to `1`.
        * `healthchecks.active.concurrency` - (Optional) is a number of targets to check concurrently in active health checks. Defaults to `10`.
        * `healthchecks.active.http_path` - (Optional) is a path to use in GET HTTP request to run as a probe on active health checks. Defaults to `/`.
        * `healthchecks.active.https_verify_certificate` - (Optional) check the validity of the SSL certificate of the remote host when performing active health checks using HTTPS. Defaults to `true`.
        * `healthchecks.active.https_sni` - (Optional) is the hostname to use as an SNI (Server Name Identification) when performing active health checks using HTTPS. This is particularly useful when Targets are configured using IPs, so that the target host’s certificate can be verified with the proper SNI. Default `nil`.
        * `healthchecks.active.healthy.interval` - (Optional) is an interval between active health checks for healthy targets (in seconds). A value of zero indicates that active probes for healthy targets should not be performed. Defaults to `0`.
        * `healthchecks.active.healthy.successes` - (Optional) is a number of successes in active probes (as defined by `healthchecks.active.healthy.http_statuses`) to consider a target healthy. Defaults to `0`.
        * `healthchecks.active.healthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a success, indicating healthiness, when returned by a probe in active health checks. Defaults to `[200, 302]`.
        * `healthchecks.active.unhealthy.interval` - (Optional) is an interval between active health checks for unhealthy targets (in seconds). A value of zero indicates that active probes for unhealthy targets should not be performed. Defaults to `0`.
        * `healthchecks.active.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in active probes to consider a target unhealthy. Defaults to `0`.
        * `healthchecks.active.unhealthy.http_failures` - (Optional) is a number of HTTP failures in active probes (as defined by `healthchecks.active.unhealthy.http_statuses`) to consider a target unhealthy. Defaults to `0`.
        * `healthchecks.active.unhealthy.timeouts` - (Optional) is a number of timeouts in active probes to consider a target unhealthy. Defaults to `0`.
        * `healthchecks.active.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses to consider a failure, indicating unhealthiness, when returned by a probe in active health checks. Defaults to `[429, 404, 500, 501, 502, 503, 504, 505]`.
        * `healthchecks.passive.type` - (Optional) is a passive health check type. Interpreting HTTP/HTTPS statuses, or just check for TCP connection success. Possible values are `tcp`, `http` or `https` (in passive checks, `http` and `https` options are equivalent.). Defaults to `http`.
        * `healthchecks.passive.healthy.successes` - (Optional) is a Number of successes in proxied traffic (as defined by `healthchecks.passive.healthy.http_statuses`) to consider a target healthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.healthy.http_statuses` - (Optional) is an array of HTTP statuses which represent healthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[200, 201, 202, 203, 204, 205, 206, 207, 208, 226, 300, 301, 302, 303, 304, 305, 306, 307, 308]`.
        * `healthchecks.passive.unhealthy.tcp_failures` - (Optional) is a number of TCP failures in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.unhealthy.http_failures` - (Optional) is a number of HTTP failures in proxied traffic (as defined by `healthchecks.passive.unhealthy.http_statuses`) to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.unhealthy.timeouts` - (Optional) is a number of timeouts in proxied traffic to consider a target unhealthy, as observed by passive health checks. Defaults to `0`.
        * `healthchecks.passive.unhealthy.http_statuses` - (Optional) is an array of HTTP statuses which represent unhealthiness when produced by proxied traffic, as observed by passive health checks. Defaults to `[429, 500, 503]`.
        """
        return pulumi.get(self, "hash_on_cookie_path")

    @property
    @pulumi.getter(name="hashOnHeader")
    def hash_on_header(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        is a header name to take the value from as hash input. Only required when `hash_on` is set to `header`. Default `nil`.
        """
        return pulumi.get(self, "hash_on_header")

    @property
    @pulumi.getter
    def healthchecks(self) -> pulumi.Output['outputs.UpstreamHealthchecks']:
        return pulumi.get(self, "healthchecks")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The hostname to be used as Host header when proxying requests through Kong.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        is a hostname, which must be equal to the host of a Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def slots(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        is the number of slots in the load balancer algorithm (10*65536, defaults to 10000).
        """
        return pulumi.get(self, "slots")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of strings associated with the Upstream for grouping and filtering.
        """
        return pulumi.get(self, "tags")

