# Contributing to Alyios Windows Functions

Thank you for your interest in contributing! This document provides guidelines for contributing to the project.

## Project Structure

```
AlyiosWindowsFunctions/
├── src/
│   └── alyios_windows/          # Main Python package
│       ├── __init__.py           # Package initialization
│       ├── *.py                  # Python modules
│       └── helpers/              # C# helper executables
│           ├── DialogHelper.exe  # File/folder dialogs
│           └── WindowsHelper.exe # Windows API operations
├── tests/                        # Test scripts
│   ├── test_*.py                 # Test files
│   └── README.md
├── examples/                     # Example scripts
│   ├── example_*.py              # Usage examples
│   └── README.md
├── scripts/
│   └── build/                    # Build scripts
│       ├── csharp/               # C# source code
│       ├── *.ps1                 # PowerShell build scripts
│       └── README.md
├── docs/                         # Documentation (future)
├── .gitignore
├── README.md
├── LICENSE
├── setup.py
└── MANIFEST.in
```

## Development Setup

### 1. Clone the Repository

```bash
git clone https://github.com/Alyios/alyios-windows.git
cd alyios-windows
```

### 2. Install in Development Mode

```bash
pip install -e .
```

This creates a symlink to your development directory, so changes are immediately reflected.

### 3. Run Examples

```bash
python examples/example.py
python examples/example_pixel_detection.py
```

## Making Changes

### Python Code

The main Python package is in `src/alyios_windows/`:

- `__init__.py` - Package exports and version
- `console.py` - Interactive console UI
- `inputs.py` - Mouse/keyboard capture and simulation
- `dialogs.py` - File/folder dialogs
- `clipboard.py` - Clipboard operations
- `screen.py` - Screenshots and pixel detection
- `notifications.py` - Windows notifications
- `audio.py` - Audio control
- `automation.py` - Automation system

### C# Helper Code

C# source files are in `scripts/build/csharp/`:

- `DialogHelper.cs` - Native Windows dialogs
- `WindowsHelper.cs` - Clipboard, screen, notifications, audio, pixel detection
- `Automation_*.cs` - Automation system components

After modifying C# code, rebuild the executables:

```powershell
cd scripts/build
powershell -ExecutionPolicy Bypass -File build_helper.ps1
powershell -ExecutionPolicy Bypass -File build_windows_helper.ps1
```

## Testing

Run test scripts from the `tests/` directory:

```bash
python tests/test_pixel_detection.py
python tests/test_input_simulation.py
```

## Code Style

- Follow PEP 8 for Python code
- Use type hints where appropriate
- Add docstrings to all public functions
- Keep functions focused and single-purpose

## Adding New Features

1. **Add Python API** in the appropriate module (`screen.py`, `clipboard.py`, etc.)
2. **Add C# backend** if needed in `WindowsHelper.cs` or `DialogHelper.cs`
3. **Rebuild executables** if C# was modified
4. **Add examples** in `examples/` directory
5. **Add tests** in `tests/` directory
6. **Update README.md** with new feature documentation

## Submitting Changes

1. Fork the repository
2. Create a feature branch (`git checkout -b feature/amazing-feature`)
3. Make your changes
4. Test your changes
5. Commit your changes (`git commit -m 'Add amazing feature'`)
6. Push to the branch (`git push origin feature/amazing-feature`)
7. Open a Pull Request

## Version Numbers

This project follows [Semantic Versioning](https://semver.org/):

- MAJOR version for incompatible API changes
- MINOR version for backwards-compatible functionality additions
- PATCH version for backwards-compatible bug fixes

Update version in:
- `setup.py`
- `src/alyios_windows/__init__.py`

## Questions?

Feel free to open an issue for:
- Bug reports
- Feature requests
- Questions about the code
- Documentation improvements

## License

By contributing, you agree that your contributions will be licensed under the MIT License.
