"""
Example: Capturing Mixed Input (Mouse or Keyboard)

This demonstrates the new get_input() function that can capture
either mouse clicks OR keyboard presses, whichever comes first.
"""

from alyios_windows import get_input

print("=" * 60)
print("Mixed Input Capture Example")
print("=" * 60)
print()

# Example 1: Single input capture
print("Example 1: Capture any input (click or key press)")
print("-" * 60)
result = get_input()

if result[0] == 'mouse':
    _, x, y, button = result
    print(f"✓ Mouse clicked at ({x}, {y}) with {button} button")
else:
    _, key = result
    print(f"✓ Key pressed: {key}")

print()

# Example 2: Multiple inputs in a loop
print("Example 2: Capture 3 inputs (any combination of clicks and keys)")
print("-" * 60)

for i in range(3):
    print(f"\nWaiting for input {i+1}/3...")
    result = get_input(verbose=False)

    if result[0] == 'mouse':
        _, x, y, button = result
        print(f"  → Mouse: ({x}, {y}) {button} button")
    else:
        _, key = result
        print(f"  → Keyboard: {key}")

print()
print("=" * 60)
print("All done!")
print("=" * 60)
print()

# Example 3: Using timeout
print("Example 3: Wait for input with 5-second timeout")
print("-" * 60)

try:
    result = get_input(timeout=5.0)

    if result[0] == 'mouse':
        _, x, y, button = result
        print(f"✓ Got mouse input: ({x}, {y}) {button}")
    else:
        _, key = result
        print(f"✓ Got keyboard input: {key}")

except TimeoutError:
    print("✗ No input received within 5 seconds!")

print()
print("=" * 60)
print()
print("Comparison with old approach:")
print()
print("OLD (Sequential):")
print("  x, y, button = get_click()  # Must click first")
print("  key = get_key()             # Then must press key")
print()
print("NEW (Either/or):")
print("  result = get_input()        # Click OR press key!")
print("=" * 60)
