"""
Example usage of Alyios Windows Functions - Automation Tools
"""

from alyios_windows import (
    # Input capture
    get_click, get_key, get_mouse_position,
    # Input simulation
    click, move_mouse, type_text, send_keys,
    # Dialogs
    select_file, select_folder,
    # Modules
    clipboard, screen, automation
)

# Example 1: Get current mouse position
print("Example 1: Get mouse position")
x, y = get_mouse_position()
print(f"Current mouse position: ({x}, {y})")

# Example 2: Capture a click
print("\nExample 2: Click anywhere to capture position...")
click_x, click_y, button = get_click()
print(f"You clicked at ({click_x}, {click_y}) with {button} button")

# Example 3: Simulate mouse actions
print("\nExample 3: Simulating mouse movement and click")
move_mouse(500, 500)
click(500, 500)

# Example 4: Type text
print("\nExample 4: Typing text")
type_text("Hello from Python!")

# Example 5: Send key combinations
print("\nExample 5: Sending Ctrl+A")
send_keys("ctrl+a")

# Example 6: Clipboard operations
print("\nExample 6: Clipboard")
clipboard.copy("Test text")
text = clipboard.paste()
print(f"Clipboard contains: {text}")

# Example 7: Screen capture
print("\nExample 7: Screen capture")
screen.screenshot("screenshot.png")
print("Screenshot saved!")

# Example 8: Automation - record and playback
print("\nExample 8: Automation available")
print("You can use automation.record() and automation.playback()")

print("\n=== All tools ready to use! ===")
