from setuptools import setup, find_packages
from pathlib import Path

# Read the README file
this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text(encoding='utf-8')

setup(
    name="alyios-windows",
    version="0.7.1",
    description="Windows-specific utilities: console UI, input capture/simulation, file dialogs, clipboard, screen capture, pixel detection, notifications, audio control, and automation",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author="Alyios",
    url="https://github.com/Alyios/alyios-windows",
    project_urls={
        "Bug Tracker": "https://github.com/Alyios/alyios-windows/issues",
        "Source Code": "https://github.com/Alyios/alyios-windows",
    },
    license="MIT",
    package_dir={"": "src"},
    packages=find_packages(where="src"),
    package_data={
        'alyios_windows': [
            'helpers/*.exe',
            'bin/*',
        ],
    },
    include_package_data=True,
    install_requires=[
        "pandas>=2.0.0",
        "openpyxl>=3.0.0",  # For Excel file support
        "chardet>=5.0.0",   # For encoding detection
        "pyperclip>=1.8.0", # For clipboard operations
    ],
    entry_points={
        'console_scripts': [
            'alyios-studio=alyios_windows.studio:main',
        ],
    },
    python_requires=">=3.7",
    keywords=[
        "windows", "console", "input", "dialog", "mouse", "keyboard",
        "automation", "gui", "ctypes", "windows-api", "file-dialog",
        "interactive", "terminal", "cli", "clipboard", "screenshot",
        "screen-capture", "notifications", "toast", "audio", "volume",
        "pixel-detection", "color-detection", "screen-monitoring"
    ],
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: Microsoft :: Windows",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Software Development :: User Interfaces",
        "Topic :: System :: Systems Administration",
    ],
)
