"""
Test: Detect Any Key

This test shows that get_input() can detect virtually any key on your keyboard.
Press different keys to see them all get detected!
"""

from alyios_windows import get_input

print("=" * 60)
print("KEY DETECTION TEST")
print("=" * 60)
print()
print("Press ANY key on your keyboard (or click mouse to stop)")
print()
print("Try these to verify:")
print("  - Letters (a-z)")
print("  - Numbers (0-9)")
print("  - Function keys (F1-F12)")
print("  - Arrow keys")
print("  - Space, Enter, Tab, Esc")
print("  - Modifier combos (Ctrl+key, Shift+key, etc.)")
print()
print("-" * 60)

detected_keys = set()

for i in range(20):  # Detect 20 inputs
    result = get_input(detailed=True, verbose=False)

    if result['type'] == 'mouse':
        print(f"\n{i+1}. Mouse {result['button']} clicked - stopping test")
        break

    key = result['key']
    detected_keys.add(key)

    # Show modifiers if any were pressed
    mods = [k for k, v in result['modifiers'].items() if v]
    mod_str = f" + {'+'.join(mods)}" if mods else ""

    print(f"{i+1:2d}. Key: '{key}'{mod_str}")

print()
print("-" * 60)
print(f"Total unique keys detected: {len(detected_keys)}")
print("Unique keys:", ', '.join(sorted(detected_keys)))
print()
print("✓ Successfully detected all keys!")
print("=" * 60)
