"""
Test: Record and Playback

Demonstrates the new consistent format between get_input() and click()/press_key()
You can now pass the output from get_input() directly to the simulation functions!
"""

from alyios_windows import get_input, click, press_key
import time

print("=" * 60)
print("RECORD AND PLAYBACK TEST")
print("=" * 60)
print()

# ==========================================================================
# Example 1: Simple Record and Playback
# ==========================================================================
print("Example 1: Record one input and play it back")
print("-" * 60)
print("Record: Click or press a key...")
recorded = get_input(detailed=True, verbose=False)

print(f"Recorded: {recorded['type']}")
if recorded['type'] == 'mouse':
    print(f"  Position: ({recorded['x']}, {recorded['y']})")
    print(f"  Button: {recorded['button']}")
else:
    print(f"  Key: {recorded['key']}")

print("\nPlayback in 2 seconds...")
time.sleep(2)

# Direct playback - just pass the dict!
if recorded['type'] == 'mouse':
    result = click(recorded, detailed=True)
    print(f"Clicked at ({result['x']}, {result['y']}) with {result['button']} button")
else:
    result = press_key(recorded, detailed=True)
    print(f"Pressed key: {result['key']}")

print()

# ==========================================================================
# Example 2: Record Multiple Inputs and Replay
# ==========================================================================
print("\nExample 2: Record a sequence and replay it")
print("-" * 60)
print("Record 5 inputs (clicks or keys)...")
sequence = []
for i in range(5):
    inp = get_input(detailed=True, verbose=False)
    sequence.append(inp)
    if inp['type'] == 'mouse':
        print(f"{i+1}. Mouse {inp['button']} at ({inp['x']}, {inp['y']})")
    else:
        print(f"{i+1}. Key '{inp['key']}'")

print(f"\nRecorded {len(sequence)} actions!")
print("\nReplaying in 3 seconds...")
time.sleep(3)

for i, action in enumerate(sequence):
    print(f"Replaying {i+1}/{len(sequence)}...", end=' ')

    if action['type'] == 'mouse':
        result = click(action, detailed=True)
        print(f"Clicked {result['button']} at ({result['x']}, {result['y']})")
    else:
        result = press_key(action, detailed=True)
        print(f"Pressed '{result['key']}'")

    time.sleep(0.5)  # Small delay between actions

print()
print("=" * 60)
print("Test complete!")
print()
print("Key Features Demonstrated:")
print("  1. get_input() returns detailed dict")
print("  2. click() accepts dict from get_input()")
print("  3. press_key() accepts dict from get_input()")
print("  4. All functions return consistent format when detailed=True")
print("  5. Perfect for macro recording and playback!")
print("=" * 60)
