"""
Simple example: Record input and play it back
"""

from alyios_windows import get_input, click, press_key
import time

print("Click or press any key...")
result = get_input(detailed=True)

print(f"\nYou entered: {result['type']}")
print("\nPlaying back in 2 seconds...")
time.sleep(2)

# Direct playback - works for both mouse and keyboard!
if result['type'] == 'mouse':
    click(result, detailed=True)
    print("Clicked!")
else:
    press_key(result, detailed=True)
    print("Key pressed!")
