"""
Test: Spinner during long clicks/presses

This test demonstrates the new spinner feature that appears when holding
a button or key for longer than 0.5 seconds.
"""

from alyios_windows import get_input

print("=" * 60)
print("SPINNER TEST")
print("=" * 60)
print()
print("Instructions:")
print("  1. Click and hold for more than 0.5 seconds to see the spinner")
print("  2. Try holding a key for more than 0.5 seconds")
print("  3. Try quick clicks/presses (< 0.5s) - no spinner should appear")
print()
print("-" * 60)

# Test 1: Long click with spinner
print("\nTest 1: Click and hold for more than 0.5 seconds...")
result = get_input(track_duration=True, detailed=True, show_spinner=True)
print(f"Result: {result['type']} - Duration: {result['duration']:.3f}s")

# Test 2: Quick click (should not show spinner)
print("\nTest 2: Quick click (less than 0.5s)...")
result = get_input(track_duration=True, detailed=True, show_spinner=True)
print(f"Result: {result['type']} - Duration: {result['duration']:.3f}s")

# Test 3: Long hold without spinner
print("\nTest 3: Long hold WITHOUT spinner (spinner disabled)...")
result = get_input(track_duration=True, detailed=True, show_spinner=False)
print(f"Result: {result['type']} - Duration: {result['duration']:.3f}s")

print()
print("-" * 60)
print("Test completed!")
print("=" * 60)
