"""
Test: Universal Input Format

Demonstrates that get_input() ALWAYS returns the same structure
regardless of whether it's mouse or keyboard input.
"""

from alyios_windows import get_input, replay_input
import time

print("=" * 60)
print("UNIVERSAL FORMAT TEST")
print("=" * 60)
print()

# ==========================================================================
# Example 1: Universal Format - Same Fields Always
# ==========================================================================
print("Example 1: Get input (click or key) - same format always!")
print("-" * 60)
result = get_input(detailed=True)

print("\nResult structure (ALWAYS the same):")
print(f"  type: {result['type']}")
print(f"  x: {result['x']}")
print(f"  y: {result['y']}")
print(f"  button: {result['button']}")
print(f"  key: {result['key']}")
print(f"  timestamp: {result['timestamp']}")
print(f"  modifiers: {result['modifiers']}")
print(f"  duration: {result['duration']}")

print("\nNotice: All fields are present regardless of input type!")
print()

# ==========================================================================
# Example 2: Universal Replay - No Type Checking Needed!
# ==========================================================================
print("\nExample 2: Universal replay (no type checking!)")
print("-" * 60)
print("Record 3 inputs (any mix of clicks and keys)...")

actions = []
for i in range(3):
    inp = get_input(detailed=True, verbose=False)
    actions.append(inp)
    print(f"{i+1}. Recorded {inp['type']}: ", end='')
    if inp['type'] == 'mouse':
        print(f"button={inp['button']} at ({inp['x']}, {inp['y']})")
    else:
        print(f"key={inp['key']} (mouse was at {inp['x']}, {inp['y']})")

print("\nReplaying in 2 seconds...")
time.sleep(2)

# Universal replay - no type checking needed!
for i, action in enumerate(actions):
    print(f"Replaying {i+1}/{len(actions)}...")
    replay_input(action)  # Works for BOTH mouse and keyboard!
    time.sleep(0.3)

print()
print("=" * 60)
print("Key Benefits:")
print("  1. get_input() ALWAYS returns the same dict structure")
print("  2. No need to check 'type' - all fields always present")
print("  3. replay_input() works universally")
print("  4. Can pass result directly to click() or press_key() too")
print("  5. Perfect for macro recording - consistent format!")
print("=" * 60)
