"""
Test input simulation functions - mouse clicks and keyboard input
"""

from alyios_windows import click, move_mouse, press_key, type_text, send_keys
import time

print("=" * 70)
print("INPUT SIMULATION TESTS")
print("=" * 70)
print()

print("1. Testing mouse movement...")
print("   Moving mouse to center of screen...")
move_mouse(960, 540)
time.sleep(1)
print("   ✓ Mouse moved!")

print("\n2. Testing mouse click...")
print("   You have 3 seconds to position a window where the click will occur...")
time.sleep(3)
print("   Clicking at (500, 300)...")
click(500, 300)
print("   ✓ Click simulated!")

print("\n3. Testing keyboard - press Enter...")
time.sleep(1)
press_key('enter')
print("   ✓ Enter key pressed!")

print("\n4. Testing text typing...")
print("   This will type 'Hello, World!' - make sure a text field is focused!")
time.sleep(2)
type_text("Hello, World!")
print("   ✓ Text typed!")

print("\n5. Testing key combination (Ctrl+A to select all)...")
time.sleep(1)
send_keys('ctrl+a')
print("   ✓ Ctrl+A sent!")

print("\n6. Example: Right-click at specific position...")
time.sleep(1)
click(600, 400, button='right')
print("   ✓ Right-click simulated!")

print("\n" + "=" * 70)
print("All tests complete!")
print("\nAvailable functions:")
print("  - click(x, y, button='left', clicks=1)")
print("  - move_mouse(x, y)")
print("  - press_key(key)")
print("  - hold_key(key) / release_key(key)")
print("  - type_text(text)")
print("  - send_keys('ctrl+c')  # Key combinations")
print("=" * 70)
