"""
Test modern IFileDialog-based file dialogs
High-resolution Windows 10/11 style with proper DPI scaling
"""


from alyios_windows import select_file, select_folder, save_file_dialog

print("=" * 70)
print("MODERN IFILEDIALOG TESTS (High-Resolution, DPI-Aware)")
print("=" * 70)
print("\nThese dialogs use the modern IFileDialog COM interface")
print("with proper DPI scaling for crisp, clear display on all monitors")
print()

print("\n1. Testing modern file selection dialog...")
print("   A crisp, modern Windows 10/11 file picker should appear.")
input("Press Enter to open...")

filepath = select_file(
    title="Select a File - Modern IFileDialog",
    filetypes=[
        ("Text files", "*.txt"),
        ("Python files", "*.py"),
        ("All files", "*.*")
    ]
)

if filepath:
    print(f"✓ Success: {filepath}")
else:
    print("✗ Cancelled")

print("\n" + "=" * 70)
print("\n2. Testing modern folder selection...")
input("Press Enter to open...")

folder = select_folder(title="Select a Folder - Modern IFileDialog")

if folder:
    print(f"✓ Success: {folder}")
else:
    print("✗ Cancelled")

print("\n" + "=" * 70)
print("\n3. Testing modern save dialog...")
input("Press Enter to open...")

save_path = save_file_dialog(
    title="Save File - Modern IFileDialog",
    initialfile="my_file.txt",
    defaultextension=".txt",
    filetypes=[
        ("Text files", "*.txt"),
        ("All files", "*.*")
    ]
)

if save_path:
    print(f"✓ Success: {save_path}")
else:
    print("✗ Cancelled")

print("\n" + "=" * 70)
print("\nAll tests complete!")
print("The modern IFileDialog provides crisp, DPI-aware dialogs.")
print("=" * 70)
