"""
Test pixel color detection functionality
"""

from alyios_windows import screen, get_mouse_position

print("=== Testing Pixel Color Detection ===\n")

# Test 1: Get current mouse position and detect color there
print("Test 1: Get color at current mouse position")
x, y = get_mouse_position()
print(f"Mouse position: ({x}, {y})")

color = screen.get_pixel_color(x, y)
if color:
    r, g, b = color
    print(f"Color at ({x}, {y}): RGB({r}, {g}, {b})")
    print(f"Hex: #{r:02x}{g:02x}{b:02x}")
else:
    print("Failed to get pixel color")

print("\n" + "="*50)
print("Test 2: Move your mouse to a different colored area...")
print("Getting color in 3 seconds...")

import time
time.sleep(3)

x2, y2 = get_mouse_position()
color2 = screen.get_pixel_color(x2, y2)
if color2:
    r2, g2, b2 = color2
    print(f"Color at ({x2}, {y2}): RGB({r2}, {g2}, {b2})")
    print(f"Hex: #{r2:02x}{g2:02x}{b2:02x}")

    if color and color2:
        if color != color2:
            print("\n[OK] Colors are different! Detection working correctly.")
        else:
            print("\n[OK] Same color detected (both positions have same color)")

print("\n" + "="*50)
print("[SUCCESS] Pixel color detection is working!")
print("\nAvailable functions:")
print("  - screen.get_pixel_color(x, y)")
print("  - screen.wait_for_color_change(x, y, timeout=30)")
print("  - screen.wait_for_color(x, y, target_color, tolerance=0)")
print("  - screen.find_color_on_screen(target_color, region=None)")
