"""
Simple test script to verify basic functionality
"""

print("Testing console menu...")
from alyios_windows import select_option

colors = ["Red", "Green", "Blue"]
choice = select_option("Select a color:", colors)
print(f"You chose: {choice}")

print("\n" + "="*50)
print("Testing mouse position...")
from alyios_windows import get_mouse_position

x, y = get_mouse_position()
print(f"Current mouse position: ({x}, {y})")

print("\n" + "="*50)
print("Testing mouse click...")
print("This will wait for you to click anywhere...")
print("If it hangs, press Ctrl+C to exit")

try:
    from alyios_windows import get_click
    x, y, button = get_click(timeout=5.0)  # 5 second timeout
    print(f"Clicked at ({x}, {y}) with {button} button")
except TimeoutError:
    print("No click detected in 5 seconds")
except Exception as e:
    print(f"Error: {e}")
    import traceback
    traceback.print_exc()

print("\nDone!")
