import logging
import sys


logger = logging.getLogger('pukpuk')
formatter = {
    logging.DEBUG: logging.Formatter('%(name)s %(levelname)s [%(asctime)s] %(message)s'),
    logging.INFO: logging.Formatter('%(message)s')
}
handler = logging.StreamHandler(sys.stdout)
logger.addHandler(handler)


def init(loglevel):
    handler.setLevel(loglevel)
    logger.setLevel(loglevel)
    handler.setFormatter(formatter[loglevel])
