---
id: plugins
title: 플러그인 시스템
sidebar_position: 1
---

# 플러그인 시스템

Synapse SDK는 다양한 카테고리와 실행 방법에 걸쳐 ML 플러그인을 구축하고 관리하기 위한 포괄적인 플러그인 시스템을 제공합니다. 플러그인 시스템은 다양한 환경에서 배포되고 실행될 수 있는 모듈식, 재사용 가능한 컴포넌트를 가능하게 합니다.

## 개요

플러그인 시스템은 **액션** 개념을 중심으로 구축됩니다 - 패키징, 배포 및 다양한 컨텍스트에서 실행될 수 있는 개별 작업들입니다. 각 플러그인은 특정 카테고리에 속하며 여러 액션을 지원할 수 있습니다.

### 주요 기능

- **🔌 모듈식 아키텍처**: 플러그인은 자체 종속성과 구성을 가진 자체 포함형입니다
- **⚡ 다중 실행 방법**: Job, Task 및 REST API 엔드포인트 지원
- **📦 분산 실행**: 확장 가능한 분산 컴퓨팅을 위해 구축됨
- **🛠️ 템플릿 시스템**: 신속한 플러그인 개발을 위한 Cookiecutter 기반 스캐폴딩
- **📊 진행률 추적**: 내장된 로깅, 메트릭 및 진행률 모니터링
- **🔄 동적 로딩**: 런타임 플러그인 발견 및 등록

## 플러그인 카테고리

SDK는 플러그인을 특정 카테고리로 구성하며, 각각은 ML 워크플로우의 다양한 측면을 위해 설계되었습니다:

### 1. 신경망 (`neural_net`)

ML 모델 훈련, 추론 및 배포 작업들.

**사용 가능한 액션:**

- `deployment` - 모델을 프로덕션 환경에 배포
- `gradio` - 모델용 대화형 웹 인터페이스 생성
- `inference` - 데이터에 대한 모델 예측 실행
- `test` - 모델 성능과 정확도 검증
- `train` - 사용자 정의 데이터셋으로 ML 모델 훈련
- `tune` - 하이퍼파라미터 최적화 및 모델 튜닝

**사용 사례:**

- 컴퓨터 비전 모델 훈련
- 모델을 웹 서비스로 배포
- 데이터셋에 대한 배치 추론 실행
- 대화형 모델 데모 생성

### 2. Export (`export`)

Synapse 플랫폼에서 주석이 달린 데이터, 그라운드 트루스 데이터셋, 할당 및 작업을 내보내기 위한 데이터 내보내기 및 변환 작업.

**사용 가능한 액션:**

- `export` - 다양한 소스(할당, 그라운드 트루스, 작업)에서 사용자 정의 처리와 함께 데이터 내보내기

**사용 사례:**

- 훈련용 주석 데이터셋 내보내기
- 그라운드 트루스 데이터를 사용자 정의 형식으로 변환
- 배포용 데이터 패키지 생성
- 할당 결과의 배치 처리
- 외부 도구용 주석 데이터 변환

**지원되는 내보내기 대상:**

- `assignment` - 주석이 있는 할당 데이터 내보내기
- `ground_truth` - 그라운드 트루스 데이터셋 버전 내보내기
- `task` - 관련 주석이 있는 작업 데이터 내보내기

Export 플러그인에 대한 자세한 정보, BaseExporter 클래스 구조, 구현 예시 및 모범 사례는 [Export 플러그인](../export-plugins) 문서를 참조하세요.

