# github flow
このリポジトリは [github flow](https://gist.github.com/Gab-km/3705015) に基づいて管理されています。github flow におけるプルリクエストのブランチの命名規則を以下に示します。

機能種別/派生元リビジョン/機能名

例えば、 Feature/2.2.12-3-g371b837/support-bonding-NIC のようなブランチ名を使用します。

## 機能種別
機能種別には以下のいずれかを指定します。

### Feature
新機能を実装する場合には機能種別に "Feature" を指定します。

### Support
OS、ミドルウェア、ライブラリ、フレームワークなどの新しいバージョンをサポートする場合には機能種別に "Support" を指定します。

### Fix
バグ修正を行う場合には機能種別に "Fix" を指定します。

### Docs
ドキュメント、サンプルを修正する場合には機能種別に "Docs" を指定します。

### Dev
hive-builder 自身の開発にのみ影響する修正を行う場合には機能種別に "Dev" を指定します。

## 機能名
機能名は短い英文です。空白の代わりにハイフン(-)を使用します。

# 手順
以下に修正を master ブランチにマージする手順を示します。

## 1. ブランチの作成
修正を開始する場合、最初にローカルリポジトリで以下のコマンドを実行してブランチを作成してください。

```shell
git checkout -b ブランチ名
```
例えば、 bonding された NIC に対応する機能を追加する場合は、以下のようなコマンドになります。
```shell
git checkout -b Feature/$(git describe --tags)/support-bonding-NIC
```

#### 補足
> master ブランチで修正を始めてしまっていても add や commit を行っていなければブランチを作成することができます。
> その場合でも上記コマンドで修正内容は失われることはありません。他の目的の修正と混じってしまった場合には、後述の commit の手順でプルリクエストに含めるファイルを選択することができます。ファイル内で混じってしまった場合には、 git stash などを使ってファイル内を切り分ける必要があるでしょう。

## 2. 修正&テスト
ローカルリポジトリで修正とテストを繰り返してください。

## 3. ステージング
修正したファイルおよび追加するファイルをステージングに移してください。

#### 補足
> 追加ファイルがなく、修正したファイルをすべて commit する場合、次の commit のコマンドに -a オプションを追加することでこの手順をスキップできます。

### 3-A. ファイル名を指定する場合
以下のコマンドでファイルを指定してステージングに移してください。
```shell
git add ファイル名1 ファイル名2
```
例えば、GITHUB-FLOW-ja.mdとexamples/pdns/inventory/hive.yml をステージングに移す場合は、以下のコマンドを実行します。
```shell
git add GITHUB-FLOW-ja.md examples/pdns/inventory/hive.yml
```

### 3-B. すべてのファイルをステージングに移す場合
以下のコマンドで追加したファイルと修正したファイルをすべてステージングに移してください。
```shell
git add -A
```

## 4. commit
以下のコマンドでステージングされたファイルを commit してください。
```shell
git commit -m 'コミット内容の記述'
```
コミット内容の記述は短い文章でコミットの内容を記述してください。例えば、bonding された NIC に対応する機能を commit する場合は、以下のようなコマンドになります。
```shell
git commit -m 'support bonding NIC'
```

## 5. push
以下のコマンドでステージングされたファイルを push してください。
```shell
git push origin ブランチ名
```
例えば、 bonding された NIC に対応する機能を 2.2.12 に追加した場合は、以下のようなコマンドになります。
```
git push origin Feature/2.2.12/support-bonding-NIC
```

## 6. プルリクエストの作成
手順5. を実行後、Web で [リポジトリ](https://github.com/procube-open/hive-builder)を参照すると、"Your recent pushed branch" としてブランチが表示されているので、「Compare & pull request」ボタンをクリックしてください。
これにより、プルリクエストが作成されます。

プリリクエストの名前は自動的にブランチ名から作成されますが、先頭に[]で囲んで機能種別を追加してください。例えば、「Feature/2.2.12/support-bonding-NIC」というブランチに対するプルリクエストは「support bonding NIC」という名前が自動的に設定されますが、これを「[Feature] support bonding NIC」に修正してください。

その後、Create pull request をクリックしてください。

## 7. レビューと修正
レビューによりプルリクエストを修正する必要が生じた場合は、ローカルリポジトリを修正してpushしてください。すなわち、手順 2. から 5. を繰り返し実施してください。push すると自動的に pull request に組み込まれるので、 Web 上の[Pull requests](https://github.com/procube-open/hive-builder/pulls)から自分のプルリクエストを開き、コメントを入力することで議論を続行してください。

#### 補足
> 修正を複数人で行う場合はブランチをそれぞれのローカルリポジトリに pull するして修正してください。

## 8. マージ
レビューが終わったプルリクエストは「Squash and merge」をクリックしてマージしてください。
#### 補足
> マージするとプリリクエストは完了となり、クローズ状態になります。新たに修正が必要になった場合は、たとえ過去のプルリクエストに関連する場合でも、この手順の最初からやり直して新しいプルリクエストとしてください。

## 9. ブランチの削除
マージが完了したブランチは削除してください。

## 9-1. ローカルリポジトリのブランチの削除
以下のコマンドでローカルリポジトリのブランチを削除してください。
```shell
git branch -D ブランチ名
```
例えば、 bonding された NIC に対応する機能を 2.2.12 に追加するプリリクエストのマージを終えた場合、以下のようなコマンドになります。
```shell
git branch -D Feature/2.2.12/support-bonding-NIC
```

## 9-2. リポジトリのブランチの削除
マージが終わったプルリクエストを Web で開き、「Delete branch」をクリックしてブランチを削除してください。
#### 補足
> マージが完了したプルリクエストはデフォルトでは[Pull requests](https://github.com/procube-open/hive-builder/pulls)に表示されません。「Filters」にデフォルトで指定されている「is:open」を削除して再検索して対象のプルリクエストを探して開いてください。
