# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountTokenArgs', 'AccountToken']

@pulumi.input_type
class AccountTokenArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 policies: pulumi.Input[Sequence[pulumi.Input['AccountTokenPolicyArgs']]],
                 condition: Optional[pulumi.Input['AccountTokenConditionArgs']] = None,
                 expires_on: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccountToken resource.
        :param pulumi.Input[_builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[_builtins.str] name: Token name.
        :param pulumi.Input[Sequence[pulumi.Input['AccountTokenPolicyArgs']]] policies: List of access policies assigned to the token.
        :param pulumi.Input[_builtins.str] expires_on: The expiration time on or after which the JWT MUST NOT be accepted for processing.
        :param pulumi.Input[_builtins.str] not_before: The time before which the token MUST NOT be accepted for processing.
        :param pulumi.Input[_builtins.str] status: Status of the token.
               Available values: "active", "disabled", "expired".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policies", policies)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if expires_on is not None:
            pulumi.set(__self__, "expires_on", expires_on)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Token name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> pulumi.Input[Sequence[pulumi.Input['AccountTokenPolicyArgs']]]:
        """
        List of access policies assigned to the token.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: pulumi.Input[Sequence[pulumi.Input['AccountTokenPolicyArgs']]]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['AccountTokenConditionArgs']]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['AccountTokenConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time on or after which the JWT MUST NOT be accepted for processing.
        """
        return pulumi.get(self, "expires_on")

    @expires_on.setter
    def expires_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_on", value)

    @_builtins.property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time before which the token MUST NOT be accepted for processing.
        """
        return pulumi.get(self, "not_before")

    @not_before.setter
    def not_before(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_before", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the token.
        Available values: "active", "disabled", "expired".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _AccountTokenState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input['AccountTokenConditionArgs']] = None,
                 expires_on: Optional[pulumi.Input[_builtins.str]] = None,
                 issued_on: Optional[pulumi.Input[_builtins.str]] = None,
                 last_used_on: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['AccountTokenPolicyArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountToken resources.
        :param pulumi.Input[_builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[_builtins.str] expires_on: The expiration time on or after which the JWT MUST NOT be accepted for processing.
        :param pulumi.Input[_builtins.str] issued_on: The time on which the token was created.
        :param pulumi.Input[_builtins.str] last_used_on: Last time the token was used.
        :param pulumi.Input[_builtins.str] modified_on: Last time the token was modified.
        :param pulumi.Input[_builtins.str] name: Token name.
        :param pulumi.Input[_builtins.str] not_before: The time before which the token MUST NOT be accepted for processing.
        :param pulumi.Input[Sequence[pulumi.Input['AccountTokenPolicyArgs']]] policies: List of access policies assigned to the token.
        :param pulumi.Input[_builtins.str] status: Status of the token.
               Available values: "active", "disabled", "expired".
        :param pulumi.Input[_builtins.str] value: The token value.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if expires_on is not None:
            pulumi.set(__self__, "expires_on", expires_on)
        if issued_on is not None:
            pulumi.set(__self__, "issued_on", issued_on)
        if last_used_on is not None:
            pulumi.set(__self__, "last_used_on", last_used_on)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['AccountTokenConditionArgs']]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['AccountTokenConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time on or after which the JWT MUST NOT be accepted for processing.
        """
        return pulumi.get(self, "expires_on")

    @expires_on.setter
    def expires_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_on", value)

    @_builtins.property
    @pulumi.getter(name="issuedOn")
    def issued_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time on which the token was created.
        """
        return pulumi.get(self, "issued_on")

    @issued_on.setter
    def issued_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issued_on", value)

    @_builtins.property
    @pulumi.getter(name="lastUsedOn")
    def last_used_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last time the token was used.
        """
        return pulumi.get(self, "last_used_on")

    @last_used_on.setter
    def last_used_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_used_on", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last time the token was modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time before which the token MUST NOT be accepted for processing.
        """
        return pulumi.get(self, "not_before")

    @not_before.setter
    def not_before(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_before", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountTokenPolicyArgs']]]]:
        """
        List of access policies assigned to the token.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountTokenPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the token.
        Available values: "active", "disabled", "expired".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("cloudflare:index/accountToken:AccountToken")
class AccountToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input[Union['AccountTokenConditionArgs', 'AccountTokenConditionArgsDict']]] = None,
                 expires_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountTokenPolicyArgs', 'AccountTokenPolicyArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accountToken:AccountToken example '<account_id>/<token_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[_builtins.str] expires_on: The expiration time on or after which the JWT MUST NOT be accepted for processing.
        :param pulumi.Input[_builtins.str] name: Token name.
        :param pulumi.Input[_builtins.str] not_before: The time before which the token MUST NOT be accepted for processing.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountTokenPolicyArgs', 'AccountTokenPolicyArgsDict']]]] policies: List of access policies assigned to the token.
        :param pulumi.Input[_builtins.str] status: Status of the token.
               Available values: "active", "disabled", "expired".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accountToken:AccountToken example '<account_id>/<token_id>'
        ```

        :param str resource_name: The name of the resource.
        :param AccountTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input[Union['AccountTokenConditionArgs', 'AccountTokenConditionArgsDict']]] = None,
                 expires_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountTokenPolicyArgs', 'AccountTokenPolicyArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountTokenArgs.__new__(AccountTokenArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["condition"] = condition
            __props__.__dict__["expires_on"] = expires_on
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["not_before"] = not_before
            if policies is None and not opts.urn:
                raise TypeError("Missing required property 'policies'")
            __props__.__dict__["policies"] = policies
            __props__.__dict__["status"] = status
            __props__.__dict__["issued_on"] = None
            __props__.__dict__["last_used_on"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["value"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["value"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AccountToken, __self__).__init__(
            'cloudflare:index/accountToken:AccountToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            condition: Optional[pulumi.Input[Union['AccountTokenConditionArgs', 'AccountTokenConditionArgsDict']]] = None,
            expires_on: Optional[pulumi.Input[_builtins.str]] = None,
            issued_on: Optional[pulumi.Input[_builtins.str]] = None,
            last_used_on: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            not_before: Optional[pulumi.Input[_builtins.str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountTokenPolicyArgs', 'AccountTokenPolicyArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccountToken':
        """
        Get an existing AccountToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[_builtins.str] expires_on: The expiration time on or after which the JWT MUST NOT be accepted for processing.
        :param pulumi.Input[_builtins.str] issued_on: The time on which the token was created.
        :param pulumi.Input[_builtins.str] last_used_on: Last time the token was used.
        :param pulumi.Input[_builtins.str] modified_on: Last time the token was modified.
        :param pulumi.Input[_builtins.str] name: Token name.
        :param pulumi.Input[_builtins.str] not_before: The time before which the token MUST NOT be accepted for processing.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountTokenPolicyArgs', 'AccountTokenPolicyArgsDict']]]] policies: List of access policies assigned to the token.
        :param pulumi.Input[_builtins.str] status: Status of the token.
               Available values: "active", "disabled", "expired".
        :param pulumi.Input[_builtins.str] value: The token value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountTokenState.__new__(_AccountTokenState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["condition"] = condition
        __props__.__dict__["expires_on"] = expires_on
        __props__.__dict__["issued_on"] = issued_on
        __props__.__dict__["last_used_on"] = last_used_on
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["not_before"] = not_before
        __props__.__dict__["policies"] = policies
        __props__.__dict__["status"] = status
        __props__.__dict__["value"] = value
        return AccountToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional['outputs.AccountTokenCondition']]:
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The expiration time on or after which the JWT MUST NOT be accepted for processing.
        """
        return pulumi.get(self, "expires_on")

    @_builtins.property
    @pulumi.getter(name="issuedOn")
    def issued_on(self) -> pulumi.Output[_builtins.str]:
        """
        The time on which the token was created.
        """
        return pulumi.get(self, "issued_on")

    @_builtins.property
    @pulumi.getter(name="lastUsedOn")
    def last_used_on(self) -> pulumi.Output[_builtins.str]:
        """
        Last time the token was used.
        """
        return pulumi.get(self, "last_used_on")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        Last time the token was modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Token name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time before which the token MUST NOT be accepted for processing.
        """
        return pulumi.get(self, "not_before")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence['outputs.AccountTokenPolicy']]:
        """
        List of access policies assigned to the token.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the token.
        Available values: "active", "disabled", "expired".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        The token value.
        """
        return pulumi.get(self, "value")

