# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ArgoSmartRoutingArgs', 'ArgoSmartRouting']

@pulumi.input_type
class ArgoSmartRoutingArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ArgoSmartRouting resource.
        :param pulumi.Input[_builtins.str] value: Specifies the enablement value of Argo Smart Routing.
               Available values: "on", "off".
        :param pulumi.Input[_builtins.str] zone_id: Specifies the zone associated with the API call.
        """
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the enablement value of Argo Smart Routing.
        Available values: "on", "off".
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the zone associated with the API call.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ArgoSmartRoutingState:
    def __init__(__self__, *,
                 editable: Optional[pulumi.Input[_builtins.bool]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ArgoSmartRouting resources.
        :param pulumi.Input[_builtins.bool] editable: Specifies if the setting is editable.
        :param pulumi.Input[_builtins.str] modified_on: Specifies the time when the setting was last modified.
        :param pulumi.Input[_builtins.str] value: Specifies the enablement value of Argo Smart Routing.
               Available values: "on", "off".
        :param pulumi.Input[_builtins.str] zone_id: Specifies the zone associated with the API call.
        """
        if editable is not None:
            pulumi.set(__self__, "editable", editable)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def editable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the setting is editable.
        """
        return pulumi.get(self, "editable")

    @editable.setter
    def editable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "editable", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time when the setting was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enablement value of Argo Smart Routing.
        Available values: "on", "off".
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the zone associated with the API call.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/argoSmartRouting:ArgoSmartRouting")
class ArgoSmartRouting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_argo_smart_routing = cloudflare.ArgoSmartRouting("example_argo_smart_routing",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            value="on")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/argoSmartRouting:ArgoSmartRouting example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] value: Specifies the enablement value of Argo Smart Routing.
               Available values: "on", "off".
        :param pulumi.Input[_builtins.str] zone_id: Specifies the zone associated with the API call.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ArgoSmartRoutingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_argo_smart_routing = cloudflare.ArgoSmartRouting("example_argo_smart_routing",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            value="on")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/argoSmartRouting:ArgoSmartRouting example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ArgoSmartRoutingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ArgoSmartRoutingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ArgoSmartRoutingArgs.__new__(ArgoSmartRoutingArgs)

            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["editable"] = None
            __props__.__dict__["modified_on"] = None
        super(ArgoSmartRouting, __self__).__init__(
            'cloudflare:index/argoSmartRouting:ArgoSmartRouting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            editable: Optional[pulumi.Input[_builtins.bool]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ArgoSmartRouting':
        """
        Get an existing ArgoSmartRouting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] editable: Specifies if the setting is editable.
        :param pulumi.Input[_builtins.str] modified_on: Specifies the time when the setting was last modified.
        :param pulumi.Input[_builtins.str] value: Specifies the enablement value of Argo Smart Routing.
               Available values: "on", "off".
        :param pulumi.Input[_builtins.str] zone_id: Specifies the zone associated with the API call.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ArgoSmartRoutingState.__new__(_ArgoSmartRoutingState)

        __props__.__dict__["editable"] = editable
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["value"] = value
        __props__.__dict__["zone_id"] = zone_id
        return ArgoSmartRouting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def editable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if the setting is editable.
        """
        return pulumi.get(self, "editable")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the time when the setting was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enablement value of Argo Smart Routing.
        Available values: "on", "off".
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the zone associated with the API call.
        """
        return pulumi.get(self, "zone_id")

