# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ByoIpPrefixArgs', 'ByoIpPrefix']

@pulumi.input_type
class ByoIpPrefixArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 asn: pulumi.Input[_builtins.int],
                 cidr: pulumi.Input[_builtins.str],
                 loa_document_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ByoIpPrefix resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier of a Cloudflare account.
        :param pulumi.Input[_builtins.int] asn: Autonomous System Number (ASN) the prefix will be advertised under.
        :param pulumi.Input[_builtins.str] cidr: IP Prefix in Classless Inter-Domain Routing format.
        :param pulumi.Input[_builtins.str] loa_document_id: Identifier for the uploaded LOA document.
        :param pulumi.Input[_builtins.str] description: Description of the prefix.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "loa_document_id", loa_document_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of a Cloudflare account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> pulumi.Input[_builtins.int]:
        """
        Autonomous System Number (ASN) the prefix will be advertised under.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "asn", value)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[_builtins.str]:
        """
        IP Prefix in Classless Inter-Domain Routing format.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="loaDocumentId")
    def loa_document_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier for the uploaded LOA document.
        """
        return pulumi.get(self, "loa_document_id")

    @loa_document_id.setter
    def loa_document_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "loa_document_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the prefix.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _ByoIpPrefixState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 advertised: Optional[pulumi.Input[_builtins.bool]] = None,
                 advertised_modified_at: Optional[pulumi.Input[_builtins.str]] = None,
                 approved: Optional[pulumi.Input[_builtins.str]] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 loa_document_id: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_at: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_demand_locked: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ByoIpPrefix resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier of a Cloudflare account.
        :param pulumi.Input[_builtins.bool] advertised: Prefix advertisement status to the Internet. This field is only not 'null' if on demand is enabled.
        :param pulumi.Input[_builtins.str] advertised_modified_at: Last time the advertisement status was changed. This field is only not 'null' if on demand is enabled.
        :param pulumi.Input[_builtins.str] approved: Approval state of the prefix (P = pending, V = active).
        :param pulumi.Input[_builtins.int] asn: Autonomous System Number (ASN) the prefix will be advertised under.
        :param pulumi.Input[_builtins.str] cidr: IP Prefix in Classless Inter-Domain Routing format.
        :param pulumi.Input[_builtins.str] description: Description of the prefix.
        :param pulumi.Input[_builtins.str] loa_document_id: Identifier for the uploaded LOA document.
        :param pulumi.Input[_builtins.bool] on_demand_enabled: Whether advertisement of the prefix to the Internet may be dynamically enabled or disabled.
        :param pulumi.Input[_builtins.bool] on_demand_locked: Whether advertisement status of the prefix is locked, meaning it cannot be changed.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if advertised is not None:
            pulumi.set(__self__, "advertised", advertised)
        if advertised_modified_at is not None:
            pulumi.set(__self__, "advertised_modified_at", advertised_modified_at)
        if approved is not None:
            pulumi.set(__self__, "approved", approved)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if loa_document_id is not None:
            pulumi.set(__self__, "loa_document_id", loa_document_id)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)
        if on_demand_enabled is not None:
            pulumi.set(__self__, "on_demand_enabled", on_demand_enabled)
        if on_demand_locked is not None:
            pulumi.set(__self__, "on_demand_locked", on_demand_locked)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of a Cloudflare account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def advertised(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prefix advertisement status to the Internet. This field is only not 'null' if on demand is enabled.
        """
        return pulumi.get(self, "advertised")

    @advertised.setter
    def advertised(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advertised", value)

    @_builtins.property
    @pulumi.getter(name="advertisedModifiedAt")
    def advertised_modified_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last time the advertisement status was changed. This field is only not 'null' if on demand is enabled.
        """
        return pulumi.get(self, "advertised_modified_at")

    @advertised_modified_at.setter
    def advertised_modified_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "advertised_modified_at", value)

    @_builtins.property
    @pulumi.getter
    def approved(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Approval state of the prefix (P = pending, V = active).
        """
        return pulumi.get(self, "approved")

    @approved.setter
    def approved(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "approved", value)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Autonomous System Number (ASN) the prefix will be advertised under.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "asn", value)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP Prefix in Classless Inter-Domain Routing format.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the prefix.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="loaDocumentId")
    def loa_document_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the uploaded LOA document.
        """
        return pulumi.get(self, "loa_document_id")

    @loa_document_id.setter
    def loa_document_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loa_document_id", value)

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_at", value)

    @_builtins.property
    @pulumi.getter(name="onDemandEnabled")
    def on_demand_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether advertisement of the prefix to the Internet may be dynamically enabled or disabled.
        """
        return pulumi.get(self, "on_demand_enabled")

    @on_demand_enabled.setter
    def on_demand_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_demand_enabled", value)

    @_builtins.property
    @pulumi.getter(name="onDemandLocked")
    def on_demand_locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether advertisement status of the prefix is locked, meaning it cannot be changed.
        """
        return pulumi.get(self, "on_demand_locked")

    @on_demand_locked.setter
    def on_demand_locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_demand_locked", value)


@pulumi.type_token("cloudflare:index/byoIpPrefix:ByoIpPrefix")
class ByoIpPrefix(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 loa_document_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_byo_ip_prefix = cloudflare.ByoIpPrefix("example_byo_ip_prefix",
            account_id="258def64c72dae45f3e4c8516e2111f2",
            asn=209242,
            cidr="192.0.2.0/24",
            loa_document_id="d933b1530bc56c9953cf8ce166da8004")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/byoIpPrefix:ByoIpPrefix example '<account_id>/<prefix_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier of a Cloudflare account.
        :param pulumi.Input[_builtins.int] asn: Autonomous System Number (ASN) the prefix will be advertised under.
        :param pulumi.Input[_builtins.str] cidr: IP Prefix in Classless Inter-Domain Routing format.
        :param pulumi.Input[_builtins.str] description: Description of the prefix.
        :param pulumi.Input[_builtins.str] loa_document_id: Identifier for the uploaded LOA document.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ByoIpPrefixArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_byo_ip_prefix = cloudflare.ByoIpPrefix("example_byo_ip_prefix",
            account_id="258def64c72dae45f3e4c8516e2111f2",
            asn=209242,
            cidr="192.0.2.0/24",
            loa_document_id="d933b1530bc56c9953cf8ce166da8004")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/byoIpPrefix:ByoIpPrefix example '<account_id>/<prefix_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ByoIpPrefixArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ByoIpPrefixArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 loa_document_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ByoIpPrefixArgs.__new__(ByoIpPrefixArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if asn is None and not opts.urn:
                raise TypeError("Missing required property 'asn'")
            __props__.__dict__["asn"] = asn
            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["description"] = description
            if loa_document_id is None and not opts.urn:
                raise TypeError("Missing required property 'loa_document_id'")
            __props__.__dict__["loa_document_id"] = loa_document_id
            __props__.__dict__["advertised"] = None
            __props__.__dict__["advertised_modified_at"] = None
            __props__.__dict__["approved"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["modified_at"] = None
            __props__.__dict__["on_demand_enabled"] = None
            __props__.__dict__["on_demand_locked"] = None
        super(ByoIpPrefix, __self__).__init__(
            'cloudflare:index/byoIpPrefix:ByoIpPrefix',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            advertised: Optional[pulumi.Input[_builtins.bool]] = None,
            advertised_modified_at: Optional[pulumi.Input[_builtins.str]] = None,
            approved: Optional[pulumi.Input[_builtins.str]] = None,
            asn: Optional[pulumi.Input[_builtins.int]] = None,
            cidr: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            loa_document_id: Optional[pulumi.Input[_builtins.str]] = None,
            modified_at: Optional[pulumi.Input[_builtins.str]] = None,
            on_demand_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            on_demand_locked: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ByoIpPrefix':
        """
        Get an existing ByoIpPrefix resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier of a Cloudflare account.
        :param pulumi.Input[_builtins.bool] advertised: Prefix advertisement status to the Internet. This field is only not 'null' if on demand is enabled.
        :param pulumi.Input[_builtins.str] advertised_modified_at: Last time the advertisement status was changed. This field is only not 'null' if on demand is enabled.
        :param pulumi.Input[_builtins.str] approved: Approval state of the prefix (P = pending, V = active).
        :param pulumi.Input[_builtins.int] asn: Autonomous System Number (ASN) the prefix will be advertised under.
        :param pulumi.Input[_builtins.str] cidr: IP Prefix in Classless Inter-Domain Routing format.
        :param pulumi.Input[_builtins.str] description: Description of the prefix.
        :param pulumi.Input[_builtins.str] loa_document_id: Identifier for the uploaded LOA document.
        :param pulumi.Input[_builtins.bool] on_demand_enabled: Whether advertisement of the prefix to the Internet may be dynamically enabled or disabled.
        :param pulumi.Input[_builtins.bool] on_demand_locked: Whether advertisement status of the prefix is locked, meaning it cannot be changed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ByoIpPrefixState.__new__(_ByoIpPrefixState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["advertised"] = advertised
        __props__.__dict__["advertised_modified_at"] = advertised_modified_at
        __props__.__dict__["approved"] = approved
        __props__.__dict__["asn"] = asn
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["loa_document_id"] = loa_document_id
        __props__.__dict__["modified_at"] = modified_at
        __props__.__dict__["on_demand_enabled"] = on_demand_enabled
        __props__.__dict__["on_demand_locked"] = on_demand_locked
        return ByoIpPrefix(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of a Cloudflare account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def advertised(self) -> pulumi.Output[_builtins.bool]:
        """
        Prefix advertisement status to the Internet. This field is only not 'null' if on demand is enabled.
        """
        return pulumi.get(self, "advertised")

    @_builtins.property
    @pulumi.getter(name="advertisedModifiedAt")
    def advertised_modified_at(self) -> pulumi.Output[_builtins.str]:
        """
        Last time the advertisement status was changed. This field is only not 'null' if on demand is enabled.
        """
        return pulumi.get(self, "advertised_modified_at")

    @_builtins.property
    @pulumi.getter
    def approved(self) -> pulumi.Output[_builtins.str]:
        """
        Approval state of the prefix (P = pending, V = active).
        """
        return pulumi.get(self, "approved")

    @_builtins.property
    @pulumi.getter
    def asn(self) -> pulumi.Output[_builtins.int]:
        """
        Autonomous System Number (ASN) the prefix will be advertised under.
        """
        return pulumi.get(self, "asn")

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[_builtins.str]:
        """
        IP Prefix in Classless Inter-Domain Routing format.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the prefix.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="loaDocumentId")
    def loa_document_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier for the uploaded LOA document.
        """
        return pulumi.get(self, "loa_document_id")

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "modified_at")

    @_builtins.property
    @pulumi.getter(name="onDemandEnabled")
    def on_demand_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether advertisement of the prefix to the Internet may be dynamically enabled or disabled.
        """
        return pulumi.get(self, "on_demand_enabled")

    @_builtins.property
    @pulumi.getter(name="onDemandLocked")
    def on_demand_locked(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether advertisement status of the prefix is locked, meaning it cannot be changed.
        """
        return pulumi.get(self, "on_demand_locked")

