# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificatePackArgs', 'CertificatePack']

@pulumi.input_type
class CertificatePackArgs:
    def __init__(__self__, *,
                 certificate_authority: pulumi.Input[_builtins.str],
                 hosts: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str],
                 validation_method: pulumi.Input[_builtins.str],
                 validity_days: pulumi.Input[_builtins.int],
                 zone_id: pulumi.Input[_builtins.str],
                 cloudflare_branding: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a CertificatePack resource.
        :param pulumi.Input[_builtins.str] certificate_authority: Certificate Authority selected for the order.  For information on any certificate authority specific details or restrictions [see this page for more details.](https://developers.cloudflare.com/ssl/reference/certificate-authorities)
               Available values: "google", "lets*encrypt", "ssl*com".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hosts: Comma separated list of valid host names for the certificate packs. Must contain the zone apex, may not contain more than 50 hosts, and may not be empty.
        :param pulumi.Input[_builtins.str] type: Type of certificate pack.
               Available values: "advanced".
        :param pulumi.Input[_builtins.str] validation_method: Validation Method selected for the order.
               Available values: "txt", "http", "email".
        :param pulumi.Input[_builtins.int] validity_days: Validity Days selected for the order.
               Available values: 14, 30, 90, 365.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        :param pulumi.Input[_builtins.bool] cloudflare_branding: Whether or not to add Cloudflare Branding for the order.  This will add a subdomain of sni.cloudflaressl.com as the Common Name if set to true.
        """
        pulumi.set(__self__, "certificate_authority", certificate_authority)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "validation_method", validation_method)
        pulumi.set(__self__, "validity_days", validity_days)
        pulumi.set(__self__, "zone_id", zone_id)
        if cloudflare_branding is not None:
            pulumi.set(__self__, "cloudflare_branding", cloudflare_branding)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Input[_builtins.str]:
        """
        Certificate Authority selected for the order.  For information on any certificate authority specific details or restrictions [see this page for more details.](https://developers.cloudflare.com/ssl/reference/certificate-authorities)
        Available values: "google", "lets*encrypt", "ssl*com".
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_authority", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Comma separated list of valid host names for the certificate packs. Must contain the zone apex, may not contain more than 50 hosts, and may not be empty.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of certificate pack.
        Available values: "advanced".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="validationMethod")
    def validation_method(self) -> pulumi.Input[_builtins.str]:
        """
        Validation Method selected for the order.
        Available values: "txt", "http", "email".
        """
        return pulumi.get(self, "validation_method")

    @validation_method.setter
    def validation_method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "validation_method", value)

    @_builtins.property
    @pulumi.getter(name="validityDays")
    def validity_days(self) -> pulumi.Input[_builtins.int]:
        """
        Validity Days selected for the order.
        Available values: 14, 30, 90, 365.
        """
        return pulumi.get(self, "validity_days")

    @validity_days.setter
    def validity_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "validity_days", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudflareBranding")
    def cloudflare_branding(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to add Cloudflare Branding for the order.  This will add a subdomain of sni.cloudflaressl.com as the Common Name if set to true.
        """
        return pulumi.get(self, "cloudflare_branding")

    @cloudflare_branding.setter
    def cloudflare_branding(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cloudflare_branding", value)


@pulumi.input_type
class _CertificatePackState:
    def __init__(__self__, *,
                 certificate_authority: Optional[pulumi.Input[_builtins.str]] = None,
                 cloudflare_branding: Optional[pulumi.Input[_builtins.bool]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_errors: Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePackValidationErrorArgs']]]] = None,
                 validation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_records: Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePackValidationRecordArgs']]]] = None,
                 validity_days: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CertificatePack resources.
        :param pulumi.Input[_builtins.str] certificate_authority: Certificate Authority selected for the order.  For information on any certificate authority specific details or restrictions [see this page for more details.](https://developers.cloudflare.com/ssl/reference/certificate-authorities)
               Available values: "google", "lets*encrypt", "ssl*com".
        :param pulumi.Input[_builtins.bool] cloudflare_branding: Whether or not to add Cloudflare Branding for the order.  This will add a subdomain of sni.cloudflaressl.com as the Common Name if set to true.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hosts: Comma separated list of valid host names for the certificate packs. Must contain the zone apex, may not contain more than 50 hosts, and may not be empty.
        :param pulumi.Input[_builtins.str] status: Status of certificate pack.
               Available values: "initializing", "pending*validation", "deleted", "pending*issuance", "pending*deployment", "pending*deletion", "pending*expiration", "expired", "active", "initializing*timed*out", "validation*timed*out", "issuance*timed*out", "deployment*timed*out", "deletion*timed*out", "pending*cleanup", "staging*deployment", "staging*active", "deactivating", "inactive", "backup*issued", "holding*deployment".
        :param pulumi.Input[_builtins.str] type: Type of certificate pack.
               Available values: "advanced".
        :param pulumi.Input[Sequence[pulumi.Input['CertificatePackValidationErrorArgs']]] validation_errors: Domain validation errors that have been received by the certificate authority (CA).
        :param pulumi.Input[_builtins.str] validation_method: Validation Method selected for the order.
               Available values: "txt", "http", "email".
        :param pulumi.Input[Sequence[pulumi.Input['CertificatePackValidationRecordArgs']]] validation_records: Certificates' validation records. Only present when certificate pack is in "pending*validation" status
        :param pulumi.Input[_builtins.int] validity_days: Validity Days selected for the order.
               Available values: 14, 30, 90, 365.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if cloudflare_branding is not None:
            pulumi.set(__self__, "cloudflare_branding", cloudflare_branding)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validation_errors is not None:
            pulumi.set(__self__, "validation_errors", validation_errors)
        if validation_method is not None:
            pulumi.set(__self__, "validation_method", validation_method)
        if validation_records is not None:
            pulumi.set(__self__, "validation_records", validation_records)
        if validity_days is not None:
            pulumi.set(__self__, "validity_days", validity_days)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate Authority selected for the order.  For information on any certificate authority specific details or restrictions [see this page for more details.](https://developers.cloudflare.com/ssl/reference/certificate-authorities)
        Available values: "google", "lets*encrypt", "ssl*com".
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="cloudflareBranding")
    def cloudflare_branding(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to add Cloudflare Branding for the order.  This will add a subdomain of sni.cloudflaressl.com as the Common Name if set to true.
        """
        return pulumi.get(self, "cloudflare_branding")

    @cloudflare_branding.setter
    def cloudflare_branding(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cloudflare_branding", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Comma separated list of valid host names for the certificate packs. Must contain the zone apex, may not contain more than 50 hosts, and may not be empty.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of certificate pack.
        Available values: "initializing", "pending*validation", "deleted", "pending*issuance", "pending*deployment", "pending*deletion", "pending*expiration", "expired", "active", "initializing*timed*out", "validation*timed*out", "issuance*timed*out", "deployment*timed*out", "deletion*timed*out", "pending*cleanup", "staging*deployment", "staging*active", "deactivating", "inactive", "backup*issued", "holding*deployment".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of certificate pack.
        Available values: "advanced".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePackValidationErrorArgs']]]]:
        """
        Domain validation errors that have been received by the certificate authority (CA).
        """
        return pulumi.get(self, "validation_errors")

    @validation_errors.setter
    def validation_errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePackValidationErrorArgs']]]]):
        pulumi.set(self, "validation_errors", value)

    @_builtins.property
    @pulumi.getter(name="validationMethod")
    def validation_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Validation Method selected for the order.
        Available values: "txt", "http", "email".
        """
        return pulumi.get(self, "validation_method")

    @validation_method.setter
    def validation_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_method", value)

    @_builtins.property
    @pulumi.getter(name="validationRecords")
    def validation_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePackValidationRecordArgs']]]]:
        """
        Certificates' validation records. Only present when certificate pack is in "pending*validation" status
        """
        return pulumi.get(self, "validation_records")

    @validation_records.setter
    def validation_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificatePackValidationRecordArgs']]]]):
        pulumi.set(self, "validation_records", value)

    @_builtins.property
    @pulumi.getter(name="validityDays")
    def validity_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Validity Days selected for the order.
        Available values: 14, 30, 90, 365.
        """
        return pulumi.get(self, "validity_days")

    @validity_days.setter
    def validity_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "validity_days", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/certificatePack:CertificatePack")
class CertificatePack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[_builtins.str]] = None,
                 cloudflare_branding: Optional[pulumi.Input[_builtins.bool]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 validity_days: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_certificate_pack = cloudflare.CertificatePack("example_certificate_pack",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            certificate_authority="lets_encrypt",
            hosts=[
                "example.com",
                "*.example.com",
                "www.example.com",
            ],
            type="advanced",
            validation_method="txt",
            validity_days=14,
            cloudflare_branding=False)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/certificatePack:CertificatePack example '<zone_id>/<certificate_pack_id>'
        ```

        While supported, importing isn't recommended and it is advised to replace the

        certificate entirely instead.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_authority: Certificate Authority selected for the order.  For information on any certificate authority specific details or restrictions [see this page for more details.](https://developers.cloudflare.com/ssl/reference/certificate-authorities)
               Available values: "google", "lets*encrypt", "ssl*com".
        :param pulumi.Input[_builtins.bool] cloudflare_branding: Whether or not to add Cloudflare Branding for the order.  This will add a subdomain of sni.cloudflaressl.com as the Common Name if set to true.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hosts: Comma separated list of valid host names for the certificate packs. Must contain the zone apex, may not contain more than 50 hosts, and may not be empty.
        :param pulumi.Input[_builtins.str] type: Type of certificate pack.
               Available values: "advanced".
        :param pulumi.Input[_builtins.str] validation_method: Validation Method selected for the order.
               Available values: "txt", "http", "email".
        :param pulumi.Input[_builtins.int] validity_days: Validity Days selected for the order.
               Available values: 14, 30, 90, 365.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificatePackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_certificate_pack = cloudflare.CertificatePack("example_certificate_pack",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            certificate_authority="lets_encrypt",
            hosts=[
                "example.com",
                "*.example.com",
                "www.example.com",
            ],
            type="advanced",
            validation_method="txt",
            validity_days=14,
            cloudflare_branding=False)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/certificatePack:CertificatePack example '<zone_id>/<certificate_pack_id>'
        ```

        While supported, importing isn't recommended and it is advised to replace the

        certificate entirely instead.

        :param str resource_name: The name of the resource.
        :param CertificatePackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificatePackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[_builtins.str]] = None,
                 cloudflare_branding: Optional[pulumi.Input[_builtins.bool]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 validity_days: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificatePackArgs.__new__(CertificatePackArgs)

            if certificate_authority is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority'")
            __props__.__dict__["certificate_authority"] = certificate_authority
            __props__.__dict__["cloudflare_branding"] = cloudflare_branding
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if validation_method is None and not opts.urn:
                raise TypeError("Missing required property 'validation_method'")
            __props__.__dict__["validation_method"] = validation_method
            if validity_days is None and not opts.urn:
                raise TypeError("Missing required property 'validity_days'")
            __props__.__dict__["validity_days"] = validity_days
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["status"] = None
            __props__.__dict__["validation_errors"] = None
            __props__.__dict__["validation_records"] = None
        super(CertificatePack, __self__).__init__(
            'cloudflare:index/certificatePack:CertificatePack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_authority: Optional[pulumi.Input[_builtins.str]] = None,
            cloudflare_branding: Optional[pulumi.Input[_builtins.bool]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            validation_errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificatePackValidationErrorArgs', 'CertificatePackValidationErrorArgsDict']]]]] = None,
            validation_method: Optional[pulumi.Input[_builtins.str]] = None,
            validation_records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificatePackValidationRecordArgs', 'CertificatePackValidationRecordArgsDict']]]]] = None,
            validity_days: Optional[pulumi.Input[_builtins.int]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CertificatePack':
        """
        Get an existing CertificatePack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_authority: Certificate Authority selected for the order.  For information on any certificate authority specific details or restrictions [see this page for more details.](https://developers.cloudflare.com/ssl/reference/certificate-authorities)
               Available values: "google", "lets*encrypt", "ssl*com".
        :param pulumi.Input[_builtins.bool] cloudflare_branding: Whether or not to add Cloudflare Branding for the order.  This will add a subdomain of sni.cloudflaressl.com as the Common Name if set to true.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hosts: Comma separated list of valid host names for the certificate packs. Must contain the zone apex, may not contain more than 50 hosts, and may not be empty.
        :param pulumi.Input[_builtins.str] status: Status of certificate pack.
               Available values: "initializing", "pending*validation", "deleted", "pending*issuance", "pending*deployment", "pending*deletion", "pending*expiration", "expired", "active", "initializing*timed*out", "validation*timed*out", "issuance*timed*out", "deployment*timed*out", "deletion*timed*out", "pending*cleanup", "staging*deployment", "staging*active", "deactivating", "inactive", "backup*issued", "holding*deployment".
        :param pulumi.Input[_builtins.str] type: Type of certificate pack.
               Available values: "advanced".
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificatePackValidationErrorArgs', 'CertificatePackValidationErrorArgsDict']]]] validation_errors: Domain validation errors that have been received by the certificate authority (CA).
        :param pulumi.Input[_builtins.str] validation_method: Validation Method selected for the order.
               Available values: "txt", "http", "email".
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificatePackValidationRecordArgs', 'CertificatePackValidationRecordArgsDict']]]] validation_records: Certificates' validation records. Only present when certificate pack is in "pending*validation" status
        :param pulumi.Input[_builtins.int] validity_days: Validity Days selected for the order.
               Available values: 14, 30, 90, 365.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificatePackState.__new__(_CertificatePackState)

        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["cloudflare_branding"] = cloudflare_branding
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["validation_errors"] = validation_errors
        __props__.__dict__["validation_method"] = validation_method
        __props__.__dict__["validation_records"] = validation_records
        __props__.__dict__["validity_days"] = validity_days
        __props__.__dict__["zone_id"] = zone_id
        return CertificatePack(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate Authority selected for the order.  For information on any certificate authority specific details or restrictions [see this page for more details.](https://developers.cloudflare.com/ssl/reference/certificate-authorities)
        Available values: "google", "lets*encrypt", "ssl*com".
        """
        return pulumi.get(self, "certificate_authority")

    @_builtins.property
    @pulumi.getter(name="cloudflareBranding")
    def cloudflare_branding(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to add Cloudflare Branding for the order.  This will add a subdomain of sni.cloudflaressl.com as the Common Name if set to true.
        """
        return pulumi.get(self, "cloudflare_branding")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Comma separated list of valid host names for the certificate packs. Must contain the zone apex, may not contain more than 50 hosts, and may not be empty.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of certificate pack.
        Available values: "initializing", "pending*validation", "deleted", "pending*issuance", "pending*deployment", "pending*deletion", "pending*expiration", "expired", "active", "initializing*timed*out", "validation*timed*out", "issuance*timed*out", "deployment*timed*out", "deletion*timed*out", "pending*cleanup", "staging*deployment", "staging*active", "deactivating", "inactive", "backup*issued", "holding*deployment".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of certificate pack.
        Available values: "advanced".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="validationErrors")
    def validation_errors(self) -> pulumi.Output[Sequence['outputs.CertificatePackValidationError']]:
        """
        Domain validation errors that have been received by the certificate authority (CA).
        """
        return pulumi.get(self, "validation_errors")

    @_builtins.property
    @pulumi.getter(name="validationMethod")
    def validation_method(self) -> pulumi.Output[_builtins.str]:
        """
        Validation Method selected for the order.
        Available values: "txt", "http", "email".
        """
        return pulumi.get(self, "validation_method")

    @_builtins.property
    @pulumi.getter(name="validationRecords")
    def validation_records(self) -> pulumi.Output[Sequence['outputs.CertificatePackValidationRecord']]:
        """
        Certificates' validation records. Only present when certificate pack is in "pending*validation" status
        """
        return pulumi.get(self, "validation_records")

    @_builtins.property
    @pulumi.getter(name="validityDays")
    def validity_days(self) -> pulumi.Output[_builtins.int]:
        """
        Validity Days selected for the order.
        Available values: 14, 30, 90, 365.
        """
        return pulumi.get(self, "validity_days")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

