# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudforceOneRequestPriorityArgs', 'CloudforceOneRequestPriority']

@pulumi.input_type
class CloudforceOneRequestPriorityArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 labels: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 priority: pulumi.Input[_builtins.int],
                 requirement: pulumi.Input[_builtins.str],
                 tlp: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a CloudforceOneRequestPriority resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: List of labels.
        :param pulumi.Input[_builtins.int] priority: Priority.
        :param pulumi.Input[_builtins.str] requirement: Requirement.
        :param pulumi.Input[_builtins.str] tlp: The CISA defined Traffic Light Protocol (TLP).
               Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "requirement", requirement)
        pulumi.set(__self__, "tlp", tlp)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def requirement(self) -> pulumi.Input[_builtins.str]:
        """
        Requirement.
        """
        return pulumi.get(self, "requirement")

    @requirement.setter
    def requirement(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "requirement", value)

    @_builtins.property
    @pulumi.getter
    def tlp(self) -> pulumi.Input[_builtins.str]:
        """
        The CISA defined Traffic Light Protocol (TLP).
        Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        return pulumi.get(self, "tlp")

    @tlp.setter
    def tlp(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tlp", value)


@pulumi.input_type
class _CloudforceOneRequestPriorityState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 completed: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 message_tokens: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 readable_id: Optional[pulumi.Input[_builtins.str]] = None,
                 request: Optional[pulumi.Input[_builtins.str]] = None,
                 requirement: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 summary: Optional[pulumi.Input[_builtins.str]] = None,
                 tlp: Optional[pulumi.Input[_builtins.str]] = None,
                 tokens: Optional[pulumi.Input[_builtins.int]] = None,
                 updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudforceOneRequestPriority resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] content: Request content.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: List of labels.
        :param pulumi.Input[_builtins.int] message_tokens: Tokens for the request messages.
        :param pulumi.Input[_builtins.int] priority: Priority.
        :param pulumi.Input[_builtins.str] readable_id: Readable Request ID.
        :param pulumi.Input[_builtins.str] request: Requested information from request.
        :param pulumi.Input[_builtins.str] requirement: Requirement.
        :param pulumi.Input[_builtins.str] status: Request Status.
               Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        :param pulumi.Input[_builtins.str] summary: Brief description of the request.
        :param pulumi.Input[_builtins.str] tlp: The CISA defined Traffic Light Protocol (TLP).
               Available values: "clear", "amber", "amber-strict", "green", "red".
        :param pulumi.Input[_builtins.int] tokens: Tokens for the request.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if completed is not None:
            pulumi.set(__self__, "completed", completed)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if message_tokens is not None:
            pulumi.set(__self__, "message_tokens", message_tokens)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if readable_id is not None:
            pulumi.set(__self__, "readable_id", readable_id)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if requirement is not None:
            pulumi.set(__self__, "requirement", requirement)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if tlp is not None:
            pulumi.set(__self__, "tlp", tlp)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def completed(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "completed")

    @completed.setter
    def completed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "completed", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Request content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="messageTokens")
    def message_tokens(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Tokens for the request messages.
        """
        return pulumi.get(self, "message_tokens")

    @message_tokens.setter
    def message_tokens(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "message_tokens", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="readableId")
    def readable_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Readable Request ID.
        """
        return pulumi.get(self, "readable_id")

    @readable_id.setter
    def readable_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "readable_id", value)

    @_builtins.property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Requested information from request.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request", value)

    @_builtins.property
    @pulumi.getter
    def requirement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Requirement.
        """
        return pulumi.get(self, "requirement")

    @requirement.setter
    def requirement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requirement", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Request Status.
        Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Brief description of the request.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "summary", value)

    @_builtins.property
    @pulumi.getter
    def tlp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CISA defined Traffic Light Protocol (TLP).
        Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        return pulumi.get(self, "tlp")

    @tlp.setter
    def tlp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tlp", value)

    @_builtins.property
    @pulumi.getter
    def tokens(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Tokens for the request.
        """
        return pulumi.get(self, "tokens")

    @tokens.setter
    def tokens(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tokens", value)

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated", value)


@pulumi.type_token("cloudflare:index/cloudforceOneRequestPriority:CloudforceOneRequestPriority")
class CloudforceOneRequestPriority(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 requirement: Optional[pulumi.Input[_builtins.str]] = None,
                 tlp: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_cloudforce_one_request_priority = cloudflare.CloudforceOneRequestPriority("example_cloudforce_one_request_priority",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            labels=[
                "DoS",
                "CVE",
            ],
            priority=1,
            requirement="DoS attacks carried out by CVEs",
            tlp="clear")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/cloudforceOneRequestPriority:CloudforceOneRequestPriority example '<account_id>/<priority_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: List of labels.
        :param pulumi.Input[_builtins.int] priority: Priority.
        :param pulumi.Input[_builtins.str] requirement: Requirement.
        :param pulumi.Input[_builtins.str] tlp: The CISA defined Traffic Light Protocol (TLP).
               Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudforceOneRequestPriorityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_cloudforce_one_request_priority = cloudflare.CloudforceOneRequestPriority("example_cloudforce_one_request_priority",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            labels=[
                "DoS",
                "CVE",
            ],
            priority=1,
            requirement="DoS attacks carried out by CVEs",
            tlp="clear")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/cloudforceOneRequestPriority:CloudforceOneRequestPriority example '<account_id>/<priority_id>'
        ```

        :param str resource_name: The name of the resource.
        :param CloudforceOneRequestPriorityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudforceOneRequestPriorityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 requirement: Optional[pulumi.Input[_builtins.str]] = None,
                 tlp: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudforceOneRequestPriorityArgs.__new__(CloudforceOneRequestPriorityArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if labels is None and not opts.urn:
                raise TypeError("Missing required property 'labels'")
            __props__.__dict__["labels"] = labels
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            if requirement is None and not opts.urn:
                raise TypeError("Missing required property 'requirement'")
            __props__.__dict__["requirement"] = requirement
            if tlp is None and not opts.urn:
                raise TypeError("Missing required property 'tlp'")
            __props__.__dict__["tlp"] = tlp
            __props__.__dict__["completed"] = None
            __props__.__dict__["content"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["message_tokens"] = None
            __props__.__dict__["readable_id"] = None
            __props__.__dict__["request"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["summary"] = None
            __props__.__dict__["tokens"] = None
            __props__.__dict__["updated"] = None
        super(CloudforceOneRequestPriority, __self__).__init__(
            'cloudflare:index/cloudforceOneRequestPriority:CloudforceOneRequestPriority',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            completed: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            message_tokens: Optional[pulumi.Input[_builtins.int]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            readable_id: Optional[pulumi.Input[_builtins.str]] = None,
            request: Optional[pulumi.Input[_builtins.str]] = None,
            requirement: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            summary: Optional[pulumi.Input[_builtins.str]] = None,
            tlp: Optional[pulumi.Input[_builtins.str]] = None,
            tokens: Optional[pulumi.Input[_builtins.int]] = None,
            updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudforceOneRequestPriority':
        """
        Get an existing CloudforceOneRequestPriority resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] content: Request content.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: List of labels.
        :param pulumi.Input[_builtins.int] message_tokens: Tokens for the request messages.
        :param pulumi.Input[_builtins.int] priority: Priority.
        :param pulumi.Input[_builtins.str] readable_id: Readable Request ID.
        :param pulumi.Input[_builtins.str] request: Requested information from request.
        :param pulumi.Input[_builtins.str] requirement: Requirement.
        :param pulumi.Input[_builtins.str] status: Request Status.
               Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        :param pulumi.Input[_builtins.str] summary: Brief description of the request.
        :param pulumi.Input[_builtins.str] tlp: The CISA defined Traffic Light Protocol (TLP).
               Available values: "clear", "amber", "amber-strict", "green", "red".
        :param pulumi.Input[_builtins.int] tokens: Tokens for the request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudforceOneRequestPriorityState.__new__(_CloudforceOneRequestPriorityState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["completed"] = completed
        __props__.__dict__["content"] = content
        __props__.__dict__["created"] = created
        __props__.__dict__["labels"] = labels
        __props__.__dict__["message_tokens"] = message_tokens
        __props__.__dict__["priority"] = priority
        __props__.__dict__["readable_id"] = readable_id
        __props__.__dict__["request"] = request
        __props__.__dict__["requirement"] = requirement
        __props__.__dict__["status"] = status
        __props__.__dict__["summary"] = summary
        __props__.__dict__["tlp"] = tlp
        __props__.__dict__["tokens"] = tokens
        __props__.__dict__["updated"] = updated
        return CloudforceOneRequestPriority(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def completed(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "completed")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        Request content.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of labels.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="messageTokens")
    def message_tokens(self) -> pulumi.Output[_builtins.int]:
        """
        Tokens for the request messages.
        """
        return pulumi.get(self, "message_tokens")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="readableId")
    def readable_id(self) -> pulumi.Output[_builtins.str]:
        """
        Readable Request ID.
        """
        return pulumi.get(self, "readable_id")

    @_builtins.property
    @pulumi.getter
    def request(self) -> pulumi.Output[_builtins.str]:
        """
        Requested information from request.
        """
        return pulumi.get(self, "request")

    @_builtins.property
    @pulumi.getter
    def requirement(self) -> pulumi.Output[_builtins.str]:
        """
        Requirement.
        """
        return pulumi.get(self, "requirement")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Request Status.
        Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> pulumi.Output[_builtins.str]:
        """
        Brief description of the request.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter
    def tlp(self) -> pulumi.Output[_builtins.str]:
        """
        The CISA defined Traffic Light Protocol (TLP).
        Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        return pulumi.get(self, "tlp")

    @_builtins.property
    @pulumi.getter
    def tokens(self) -> pulumi.Output[_builtins.int]:
        """
        Tokens for the request.
        """
        return pulumi.get(self, "tokens")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated")

