# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomHostnameArgs', 'CustomHostname']

@pulumi.input_type
class CustomHostnameArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[_builtins.str],
                 ssl: pulumi.Input['CustomHostnameSslArgs'],
                 zone_id: pulumi.Input[_builtins.str],
                 custom_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 custom_origin_server: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_origin_sni: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomHostname resource.
        :param pulumi.Input[_builtins.str] hostname: The custom hostname that will point to your hostname via CNAME.
        :param pulumi.Input['CustomHostnameSslArgs'] ssl: SSL properties used when creating the custom hostname.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_metadata: Unique key/value metadata for this hostname. These are per-hostname (customer) settings.
        :param pulumi.Input[_builtins.str] custom_origin_server: a valid hostname that’s been added to your DNS zone as an A, AAAA, or CNAME record.
        :param pulumi.Input[_builtins.str] custom_origin_sni: A hostname that will be sent to your custom origin server as SNI for TLS handshake. This can be a valid subdomain of the zone or custom origin server name or the string ':request*host*header:' which will cause the host header in the request to be used as SNI. Not configurable with default/fallback origin server.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ssl", ssl)
        pulumi.set(__self__, "zone_id", zone_id)
        if custom_metadata is not None:
            pulumi.set(__self__, "custom_metadata", custom_metadata)
        if custom_origin_server is not None:
            pulumi.set(__self__, "custom_origin_server", custom_origin_server)
        if custom_origin_sni is not None:
            pulumi.set(__self__, "custom_origin_sni", custom_origin_sni)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[_builtins.str]:
        """
        The custom hostname that will point to your hostname via CNAME.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> pulumi.Input['CustomHostnameSslArgs']:
        """
        SSL properties used when creating the custom hostname.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: pulumi.Input['CustomHostnameSslArgs']):
        pulumi.set(self, "ssl", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="customMetadata")
    def custom_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unique key/value metadata for this hostname. These are per-hostname (customer) settings.
        """
        return pulumi.get(self, "custom_metadata")

    @custom_metadata.setter
    def custom_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_metadata", value)

    @_builtins.property
    @pulumi.getter(name="customOriginServer")
    def custom_origin_server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        a valid hostname that’s been added to your DNS zone as an A, AAAA, or CNAME record.
        """
        return pulumi.get(self, "custom_origin_server")

    @custom_origin_server.setter
    def custom_origin_server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_origin_server", value)

    @_builtins.property
    @pulumi.getter(name="customOriginSni")
    def custom_origin_sni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A hostname that will be sent to your custom origin server as SNI for TLS handshake. This can be a valid subdomain of the zone or custom origin server name or the string ':request*host*header:' which will cause the host header in the request to be used as SNI. Not configurable with default/fallback origin server.
        """
        return pulumi.get(self, "custom_origin_sni")

    @custom_origin_sni.setter
    def custom_origin_sni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_origin_sni", value)


@pulumi.input_type
class _CustomHostnameState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 custom_origin_server: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_origin_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_verification: Optional[pulumi.Input['CustomHostnameOwnershipVerificationArgs']] = None,
                 ownership_verification_http: Optional[pulumi.Input['CustomHostnameOwnershipVerificationHttpArgs']] = None,
                 ssl: Optional[pulumi.Input['CustomHostnameSslArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_errors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomHostname resources.
        :param pulumi.Input[_builtins.str] created_at: This is the time the hostname was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_metadata: Unique key/value metadata for this hostname. These are per-hostname (customer) settings.
        :param pulumi.Input[_builtins.str] custom_origin_server: a valid hostname that’s been added to your DNS zone as an A, AAAA, or CNAME record.
        :param pulumi.Input[_builtins.str] custom_origin_sni: A hostname that will be sent to your custom origin server as SNI for TLS handshake. This can be a valid subdomain of the zone or custom origin server name or the string ':request*host*header:' which will cause the host header in the request to be used as SNI. Not configurable with default/fallback origin server.
        :param pulumi.Input[_builtins.str] hostname: The custom hostname that will point to your hostname via CNAME.
        :param pulumi.Input['CustomHostnameOwnershipVerificationArgs'] ownership_verification: This is a record which can be placed to activate a hostname.
        :param pulumi.Input['CustomHostnameOwnershipVerificationHttpArgs'] ownership_verification_http: This presents the token to be served by the given http url to activate a hostname.
        :param pulumi.Input['CustomHostnameSslArgs'] ssl: SSL properties used when creating the custom hostname.
        :param pulumi.Input[_builtins.str] status: Status of the hostname's activation.
               Available values: "active", "pending", "active*redeploying", "moved", "pending*deletion", "deleted", "pending*blocked", "pending*migration", "pending*provisioned", "test*pending", "test*active", "test*active*apex", "test*blocked", "test_failed", "provisioned", "blocked".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] verification_errors: These are errors that were encountered while trying to activate a hostname.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom_metadata is not None:
            pulumi.set(__self__, "custom_metadata", custom_metadata)
        if custom_origin_server is not None:
            pulumi.set(__self__, "custom_origin_server", custom_origin_server)
        if custom_origin_sni is not None:
            pulumi.set(__self__, "custom_origin_sni", custom_origin_sni)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ownership_verification is not None:
            pulumi.set(__self__, "ownership_verification", ownership_verification)
        if ownership_verification_http is not None:
            pulumi.set(__self__, "ownership_verification_http", ownership_verification_http)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if verification_errors is not None:
            pulumi.set(__self__, "verification_errors", verification_errors)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the time the hostname was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="customMetadata")
    def custom_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unique key/value metadata for this hostname. These are per-hostname (customer) settings.
        """
        return pulumi.get(self, "custom_metadata")

    @custom_metadata.setter
    def custom_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_metadata", value)

    @_builtins.property
    @pulumi.getter(name="customOriginServer")
    def custom_origin_server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        a valid hostname that’s been added to your DNS zone as an A, AAAA, or CNAME record.
        """
        return pulumi.get(self, "custom_origin_server")

    @custom_origin_server.setter
    def custom_origin_server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_origin_server", value)

    @_builtins.property
    @pulumi.getter(name="customOriginSni")
    def custom_origin_sni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A hostname that will be sent to your custom origin server as SNI for TLS handshake. This can be a valid subdomain of the zone or custom origin server name or the string ':request*host*header:' which will cause the host header in the request to be used as SNI. Not configurable with default/fallback origin server.
        """
        return pulumi.get(self, "custom_origin_sni")

    @custom_origin_sni.setter
    def custom_origin_sni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_origin_sni", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom hostname that will point to your hostname via CNAME.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="ownershipVerification")
    def ownership_verification(self) -> Optional[pulumi.Input['CustomHostnameOwnershipVerificationArgs']]:
        """
        This is a record which can be placed to activate a hostname.
        """
        return pulumi.get(self, "ownership_verification")

    @ownership_verification.setter
    def ownership_verification(self, value: Optional[pulumi.Input['CustomHostnameOwnershipVerificationArgs']]):
        pulumi.set(self, "ownership_verification", value)

    @_builtins.property
    @pulumi.getter(name="ownershipVerificationHttp")
    def ownership_verification_http(self) -> Optional[pulumi.Input['CustomHostnameOwnershipVerificationHttpArgs']]:
        """
        This presents the token to be served by the given http url to activate a hostname.
        """
        return pulumi.get(self, "ownership_verification_http")

    @ownership_verification_http.setter
    def ownership_verification_http(self, value: Optional[pulumi.Input['CustomHostnameOwnershipVerificationHttpArgs']]):
        pulumi.set(self, "ownership_verification_http", value)

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['CustomHostnameSslArgs']]:
        """
        SSL properties used when creating the custom hostname.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['CustomHostnameSslArgs']]):
        pulumi.set(self, "ssl", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the hostname's activation.
        Available values: "active", "pending", "active*redeploying", "moved", "pending*deletion", "deleted", "pending*blocked", "pending*migration", "pending*provisioned", "test*pending", "test*active", "test*active*apex", "test*blocked", "test_failed", "provisioned", "blocked".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="verificationErrors")
    def verification_errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        These are errors that were encountered while trying to activate a hostname.
        """
        return pulumi.get(self, "verification_errors")

    @verification_errors.setter
    def verification_errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "verification_errors", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/customHostname:CustomHostname")
class CustomHostname(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 custom_origin_server: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_origin_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl: Optional[pulumi.Input[Union['CustomHostnameSslArgs', 'CustomHostnameSslArgsDict']]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/customHostname:CustomHostname example '<zone_id>/<custom_hostname_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_metadata: Unique key/value metadata for this hostname. These are per-hostname (customer) settings.
        :param pulumi.Input[_builtins.str] custom_origin_server: a valid hostname that’s been added to your DNS zone as an A, AAAA, or CNAME record.
        :param pulumi.Input[_builtins.str] custom_origin_sni: A hostname that will be sent to your custom origin server as SNI for TLS handshake. This can be a valid subdomain of the zone or custom origin server name or the string ':request*host*header:' which will cause the host header in the request to be used as SNI. Not configurable with default/fallback origin server.
        :param pulumi.Input[_builtins.str] hostname: The custom hostname that will point to your hostname via CNAME.
        :param pulumi.Input[Union['CustomHostnameSslArgs', 'CustomHostnameSslArgsDict']] ssl: SSL properties used when creating the custom hostname.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomHostnameArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/customHostname:CustomHostname example '<zone_id>/<custom_hostname_id>'
        ```

        :param str resource_name: The name of the resource.
        :param CustomHostnameArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomHostnameArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 custom_origin_server: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_origin_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl: Optional[pulumi.Input[Union['CustomHostnameSslArgs', 'CustomHostnameSslArgsDict']]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomHostnameArgs.__new__(CustomHostnameArgs)

            __props__.__dict__["custom_metadata"] = custom_metadata
            __props__.__dict__["custom_origin_server"] = custom_origin_server
            __props__.__dict__["custom_origin_sni"] = custom_origin_sni
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            if ssl is None and not opts.urn:
                raise TypeError("Missing required property 'ssl'")
            __props__.__dict__["ssl"] = ssl
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["ownership_verification"] = None
            __props__.__dict__["ownership_verification_http"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["verification_errors"] = None
        super(CustomHostname, __self__).__init__(
            'cloudflare:index/customHostname:CustomHostname',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            custom_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            custom_origin_server: Optional[pulumi.Input[_builtins.str]] = None,
            custom_origin_sni: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_verification: Optional[pulumi.Input[Union['CustomHostnameOwnershipVerificationArgs', 'CustomHostnameOwnershipVerificationArgsDict']]] = None,
            ownership_verification_http: Optional[pulumi.Input[Union['CustomHostnameOwnershipVerificationHttpArgs', 'CustomHostnameOwnershipVerificationHttpArgsDict']]] = None,
            ssl: Optional[pulumi.Input[Union['CustomHostnameSslArgs', 'CustomHostnameSslArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            verification_errors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomHostname':
        """
        Get an existing CustomHostname resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: This is the time the hostname was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_metadata: Unique key/value metadata for this hostname. These are per-hostname (customer) settings.
        :param pulumi.Input[_builtins.str] custom_origin_server: a valid hostname that’s been added to your DNS zone as an A, AAAA, or CNAME record.
        :param pulumi.Input[_builtins.str] custom_origin_sni: A hostname that will be sent to your custom origin server as SNI for TLS handshake. This can be a valid subdomain of the zone or custom origin server name or the string ':request*host*header:' which will cause the host header in the request to be used as SNI. Not configurable with default/fallback origin server.
        :param pulumi.Input[_builtins.str] hostname: The custom hostname that will point to your hostname via CNAME.
        :param pulumi.Input[Union['CustomHostnameOwnershipVerificationArgs', 'CustomHostnameOwnershipVerificationArgsDict']] ownership_verification: This is a record which can be placed to activate a hostname.
        :param pulumi.Input[Union['CustomHostnameOwnershipVerificationHttpArgs', 'CustomHostnameOwnershipVerificationHttpArgsDict']] ownership_verification_http: This presents the token to be served by the given http url to activate a hostname.
        :param pulumi.Input[Union['CustomHostnameSslArgs', 'CustomHostnameSslArgsDict']] ssl: SSL properties used when creating the custom hostname.
        :param pulumi.Input[_builtins.str] status: Status of the hostname's activation.
               Available values: "active", "pending", "active*redeploying", "moved", "pending*deletion", "deleted", "pending*blocked", "pending*migration", "pending*provisioned", "test*pending", "test*active", "test*active*apex", "test*blocked", "test_failed", "provisioned", "blocked".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] verification_errors: These are errors that were encountered while trying to activate a hostname.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomHostnameState.__new__(_CustomHostnameState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["custom_metadata"] = custom_metadata
        __props__.__dict__["custom_origin_server"] = custom_origin_server
        __props__.__dict__["custom_origin_sni"] = custom_origin_sni
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ownership_verification"] = ownership_verification
        __props__.__dict__["ownership_verification_http"] = ownership_verification_http
        __props__.__dict__["ssl"] = ssl
        __props__.__dict__["status"] = status
        __props__.__dict__["verification_errors"] = verification_errors
        __props__.__dict__["zone_id"] = zone_id
        return CustomHostname(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        This is the time the hostname was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customMetadata")
    def custom_metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Unique key/value metadata for this hostname. These are per-hostname (customer) settings.
        """
        return pulumi.get(self, "custom_metadata")

    @_builtins.property
    @pulumi.getter(name="customOriginServer")
    def custom_origin_server(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        a valid hostname that’s been added to your DNS zone as an A, AAAA, or CNAME record.
        """
        return pulumi.get(self, "custom_origin_server")

    @_builtins.property
    @pulumi.getter(name="customOriginSni")
    def custom_origin_sni(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A hostname that will be sent to your custom origin server as SNI for TLS handshake. This can be a valid subdomain of the zone or custom origin server name or the string ':request*host*header:' which will cause the host header in the request to be used as SNI. Not configurable with default/fallback origin server.
        """
        return pulumi.get(self, "custom_origin_sni")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The custom hostname that will point to your hostname via CNAME.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="ownershipVerification")
    def ownership_verification(self) -> pulumi.Output['outputs.CustomHostnameOwnershipVerification']:
        """
        This is a record which can be placed to activate a hostname.
        """
        return pulumi.get(self, "ownership_verification")

    @_builtins.property
    @pulumi.getter(name="ownershipVerificationHttp")
    def ownership_verification_http(self) -> pulumi.Output['outputs.CustomHostnameOwnershipVerificationHttp']:
        """
        This presents the token to be served by the given http url to activate a hostname.
        """
        return pulumi.get(self, "ownership_verification_http")

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> pulumi.Output['outputs.CustomHostnameSsl']:
        """
        SSL properties used when creating the custom hostname.
        """
        return pulumi.get(self, "ssl")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the hostname's activation.
        Available values: "active", "pending", "active*redeploying", "moved", "pending*deletion", "deleted", "pending*blocked", "pending*migration", "pending*provisioned", "test*pending", "test*active", "test*active*apex", "test*blocked", "test_failed", "provisioned", "blocked".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="verificationErrors")
    def verification_errors(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        These are errors that were encountered while trying to activate a hostname.
        """
        return pulumi.get(self, "verification_errors")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

