# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DnsZoneTransfersIncomingArgs', 'DnsZoneTransfersIncoming']

@pulumi.input_type
class DnsZoneTransfersIncomingArgs:
    def __init__(__self__, *,
                 auto_refresh_seconds: pulumi.Input[_builtins.float],
                 name: pulumi.Input[_builtins.str],
                 peers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 zone_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a DnsZoneTransfersIncoming resource.
        :param pulumi.Input[_builtins.float] auto_refresh_seconds: How often should a secondary zone auto refresh regardless of DNS NOTIFY.
               Not applicable for primary zones.
        :param pulumi.Input[_builtins.str] name: Zone name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peers: A list of peer tags.
        """
        pulumi.set(__self__, "auto_refresh_seconds", auto_refresh_seconds)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "peers", peers)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoRefreshSeconds")
    def auto_refresh_seconds(self) -> pulumi.Input[_builtins.float]:
        """
        How often should a secondary zone auto refresh regardless of DNS NOTIFY.
        Not applicable for primary zones.
        """
        return pulumi.get(self, "auto_refresh_seconds")

    @auto_refresh_seconds.setter
    def auto_refresh_seconds(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "auto_refresh_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Zone name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def peers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of peer tags.
        """
        return pulumi.get(self, "peers")

    @peers.setter
    def peers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "peers", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _DnsZoneTransfersIncomingState:
    def __init__(__self__, *,
                 auto_refresh_seconds: Optional[pulumi.Input[_builtins.float]] = None,
                 checked_time: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 soa_serial: Optional[pulumi.Input[_builtins.float]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DnsZoneTransfersIncoming resources.
        :param pulumi.Input[_builtins.float] auto_refresh_seconds: How often should a secondary zone auto refresh regardless of DNS NOTIFY.
               Not applicable for primary zones.
        :param pulumi.Input[_builtins.str] checked_time: The time for a specific event.
        :param pulumi.Input[_builtins.str] created_time: The time for a specific event.
        :param pulumi.Input[_builtins.str] modified_time: The time for a specific event.
        :param pulumi.Input[_builtins.str] name: Zone name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peers: A list of peer tags.
        :param pulumi.Input[_builtins.float] soa_serial: The serial number of the SOA for the given zone.
        """
        if auto_refresh_seconds is not None:
            pulumi.set(__self__, "auto_refresh_seconds", auto_refresh_seconds)
        if checked_time is not None:
            pulumi.set(__self__, "checked_time", checked_time)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if modified_time is not None:
            pulumi.set(__self__, "modified_time", modified_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peers is not None:
            pulumi.set(__self__, "peers", peers)
        if soa_serial is not None:
            pulumi.set(__self__, "soa_serial", soa_serial)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoRefreshSeconds")
    def auto_refresh_seconds(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        How often should a secondary zone auto refresh regardless of DNS NOTIFY.
        Not applicable for primary zones.
        """
        return pulumi.get(self, "auto_refresh_seconds")

    @auto_refresh_seconds.setter
    def auto_refresh_seconds(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "auto_refresh_seconds", value)

    @_builtins.property
    @pulumi.getter(name="checkedTime")
    def checked_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time for a specific event.
        """
        return pulumi.get(self, "checked_time")

    @checked_time.setter
    def checked_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checked_time", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time for a specific event.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time for a specific event.
        """
        return pulumi.get(self, "modified_time")

    @modified_time.setter
    def modified_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def peers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of peer tags.
        """
        return pulumi.get(self, "peers")

    @peers.setter
    def peers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "peers", value)

    @_builtins.property
    @pulumi.getter(name="soaSerial")
    def soa_serial(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The serial number of the SOA for the given zone.
        """
        return pulumi.get(self, "soa_serial")

    @soa_serial.setter
    def soa_serial(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "soa_serial", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/dnsZoneTransfersIncoming:DnsZoneTransfersIncoming")
class DnsZoneTransfersIncoming(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_refresh_seconds: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_dns_zone_transfers_incoming = cloudflare.DnsZoneTransfersIncoming("example_dns_zone_transfers_incoming",
            zone_id="269d8f4853475ca241c4e730be286b20",
            auto_refresh_seconds=86400,
            name="www.example.com.",
            peers=[
                "23ff594956f20c2a721606e94745a8aa",
                "00920f38ce07c2e2f4df50b1f61d4194",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/dnsZoneTransfersIncoming:DnsZoneTransfersIncoming example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] auto_refresh_seconds: How often should a secondary zone auto refresh regardless of DNS NOTIFY.
               Not applicable for primary zones.
        :param pulumi.Input[_builtins.str] name: Zone name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peers: A list of peer tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsZoneTransfersIncomingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_dns_zone_transfers_incoming = cloudflare.DnsZoneTransfersIncoming("example_dns_zone_transfers_incoming",
            zone_id="269d8f4853475ca241c4e730be286b20",
            auto_refresh_seconds=86400,
            name="www.example.com.",
            peers=[
                "23ff594956f20c2a721606e94745a8aa",
                "00920f38ce07c2e2f4df50b1f61d4194",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/dnsZoneTransfersIncoming:DnsZoneTransfersIncoming example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param DnsZoneTransfersIncomingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsZoneTransfersIncomingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_refresh_seconds: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsZoneTransfersIncomingArgs.__new__(DnsZoneTransfersIncomingArgs)

            if auto_refresh_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'auto_refresh_seconds'")
            __props__.__dict__["auto_refresh_seconds"] = auto_refresh_seconds
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if peers is None and not opts.urn:
                raise TypeError("Missing required property 'peers'")
            __props__.__dict__["peers"] = peers
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["checked_time"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["modified_time"] = None
            __props__.__dict__["soa_serial"] = None
        super(DnsZoneTransfersIncoming, __self__).__init__(
            'cloudflare:index/dnsZoneTransfersIncoming:DnsZoneTransfersIncoming',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_refresh_seconds: Optional[pulumi.Input[_builtins.float]] = None,
            checked_time: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            modified_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            peers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            soa_serial: Optional[pulumi.Input[_builtins.float]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DnsZoneTransfersIncoming':
        """
        Get an existing DnsZoneTransfersIncoming resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] auto_refresh_seconds: How often should a secondary zone auto refresh regardless of DNS NOTIFY.
               Not applicable for primary zones.
        :param pulumi.Input[_builtins.str] checked_time: The time for a specific event.
        :param pulumi.Input[_builtins.str] created_time: The time for a specific event.
        :param pulumi.Input[_builtins.str] modified_time: The time for a specific event.
        :param pulumi.Input[_builtins.str] name: Zone name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peers: A list of peer tags.
        :param pulumi.Input[_builtins.float] soa_serial: The serial number of the SOA for the given zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsZoneTransfersIncomingState.__new__(_DnsZoneTransfersIncomingState)

        __props__.__dict__["auto_refresh_seconds"] = auto_refresh_seconds
        __props__.__dict__["checked_time"] = checked_time
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["modified_time"] = modified_time
        __props__.__dict__["name"] = name
        __props__.__dict__["peers"] = peers
        __props__.__dict__["soa_serial"] = soa_serial
        __props__.__dict__["zone_id"] = zone_id
        return DnsZoneTransfersIncoming(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRefreshSeconds")
    def auto_refresh_seconds(self) -> pulumi.Output[_builtins.float]:
        """
        How often should a secondary zone auto refresh regardless of DNS NOTIFY.
        Not applicable for primary zones.
        """
        return pulumi.get(self, "auto_refresh_seconds")

    @_builtins.property
    @pulumi.getter(name="checkedTime")
    def checked_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time for a specific event.
        """
        return pulumi.get(self, "checked_time")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time for a specific event.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time for a specific event.
        """
        return pulumi.get(self, "modified_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Zone name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def peers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of peer tags.
        """
        return pulumi.get(self, "peers")

    @_builtins.property
    @pulumi.getter(name="soaSerial")
    def soa_serial(self) -> pulumi.Output[_builtins.float]:
        """
        The serial number of the SOA for the given zone.
        """
        return pulumi.get(self, "soa_serial")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "zone_id")

