# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EmailRoutingAddressArgs', 'EmailRoutingAddress']

@pulumi.input_type
class EmailRoutingAddressArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 email: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a EmailRoutingAddress resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] email: The contact email address of the user.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "email", email)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        The contact email address of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)


@pulumi.input_type
class _EmailRoutingAddressState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 modified: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 verified: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EmailRoutingAddress resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] created: The date and time the destination address has been created.
        :param pulumi.Input[_builtins.str] email: The contact email address of the user.
        :param pulumi.Input[_builtins.str] modified: The date and time the destination address was last modified.
        :param pulumi.Input[_builtins.str] tag: Destination address tag. (Deprecated, replaced by destination address identifier)
        :param pulumi.Input[_builtins.str] verified: The date and time the destination address has been verified. Null means not verified yet.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if modified is not None:
            pulumi.set(__self__, "modified", modified)
        if tag is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""tag is deprecated: This attribute is deprecated.""")
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if verified is not None:
            pulumi.set(__self__, "verified", verified)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the destination address has been created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The contact email address of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the destination address was last modified.
        """
        return pulumi.get(self, "modified")

    @modified.setter
    def modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination address tag. (Deprecated, replaced by destination address identifier)
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter
    def verified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the destination address has been verified. Null means not verified yet.
        """
        return pulumi.get(self, "verified")

    @verified.setter
    def verified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verified", value)


@pulumi.type_token("cloudflare:index/emailRoutingAddress:EmailRoutingAddress")
class EmailRoutingAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_email_routing_address = cloudflare.EmailRoutingAddress("example_email_routing_address",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            email="user@example.com")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/emailRoutingAddress:EmailRoutingAddress example '<account_id>/<destination_address_identifier>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] email: The contact email address of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmailRoutingAddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_email_routing_address = cloudflare.EmailRoutingAddress("example_email_routing_address",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            email="user@example.com")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/emailRoutingAddress:EmailRoutingAddress example '<account_id>/<destination_address_identifier>'
        ```

        :param str resource_name: The name of the resource.
        :param EmailRoutingAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmailRoutingAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmailRoutingAddressArgs.__new__(EmailRoutingAddressArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["created"] = None
            __props__.__dict__["modified"] = None
            __props__.__dict__["tag"] = None
            __props__.__dict__["verified"] = None
        super(EmailRoutingAddress, __self__).__init__(
            'cloudflare:index/emailRoutingAddress:EmailRoutingAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            modified: Optional[pulumi.Input[_builtins.str]] = None,
            tag: Optional[pulumi.Input[_builtins.str]] = None,
            verified: Optional[pulumi.Input[_builtins.str]] = None) -> 'EmailRoutingAddress':
        """
        Get an existing EmailRoutingAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] created: The date and time the destination address has been created.
        :param pulumi.Input[_builtins.str] email: The contact email address of the user.
        :param pulumi.Input[_builtins.str] modified: The date and time the destination address was last modified.
        :param pulumi.Input[_builtins.str] tag: Destination address tag. (Deprecated, replaced by destination address identifier)
        :param pulumi.Input[_builtins.str] verified: The date and time the destination address has been verified. Null means not verified yet.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EmailRoutingAddressState.__new__(_EmailRoutingAddressState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created"] = created
        __props__.__dict__["email"] = email
        __props__.__dict__["modified"] = modified
        __props__.__dict__["tag"] = tag
        __props__.__dict__["verified"] = verified
        return EmailRoutingAddress(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the destination address has been created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        The contact email address of the user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def modified(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the destination address was last modified.
        """
        return pulumi.get(self, "modified")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def tag(self) -> pulumi.Output[_builtins.str]:
        """
        Destination address tag. (Deprecated, replaced by destination address identifier)
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def verified(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the destination address has been verified. Null means not verified yet.
        """
        return pulumi.get(self, "verified")

