# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetArgoSmartRoutingResult',
    'AwaitableGetArgoSmartRoutingResult',
    'get_argo_smart_routing',
    'get_argo_smart_routing_output',
]

@pulumi.output_type
class GetArgoSmartRoutingResult:
    """
    A collection of values returned by getArgoSmartRouting.
    """
    def __init__(__self__, editable=None, id=None, modified_on=None, value=None, zone_id=None):
        if editable and not isinstance(editable, bool):
            raise TypeError("Expected argument 'editable' to be a bool")
        pulumi.set(__self__, "editable", editable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def editable(self) -> _builtins.bool:
        """
        Specifies if the setting is editable.
        """
        return pulumi.get(self, "editable")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Specifies the identifier of the Argo Smart Routing setting.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> _builtins.str:
        """
        Specifies the time when the setting was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Specifies the enablement value of Argo Smart Routing.
        Available values: "on", "off".
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Specifies the zone associated with the API call.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetArgoSmartRoutingResult(GetArgoSmartRoutingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetArgoSmartRoutingResult(
            editable=self.editable,
            id=self.id,
            modified_on=self.modified_on,
            value=self.value,
            zone_id=self.zone_id)


def get_argo_smart_routing(zone_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetArgoSmartRoutingResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_argo_smart_routing = cloudflare.get_argo_smart_routing(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Specifies the zone associated with the API call.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getArgoSmartRouting:getArgoSmartRouting', __args__, opts=opts, typ=GetArgoSmartRoutingResult).value

    return AwaitableGetArgoSmartRoutingResult(
        editable=pulumi.get(__ret__, 'editable'),
        id=pulumi.get(__ret__, 'id'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        value=pulumi.get(__ret__, 'value'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_argo_smart_routing_output(zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetArgoSmartRoutingResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_argo_smart_routing = cloudflare.get_argo_smart_routing(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Specifies the zone associated with the API call.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getArgoSmartRouting:getArgoSmartRouting', __args__, opts=opts, typ=GetArgoSmartRoutingResult)
    return __ret__.apply(lambda __response__: GetArgoSmartRoutingResult(
        editable=pulumi.get(__response__, 'editable'),
        id=pulumi.get(__response__, 'id'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        value=pulumi.get(__response__, 'value'),
        zone_id=pulumi.get(__response__, 'zone_id')))
