# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCloudforceOneRequestAssetResult',
    'AwaitableGetCloudforceOneRequestAssetResult',
    'get_cloudforce_one_request_asset',
    'get_cloudforce_one_request_asset_output',
]

@pulumi.output_type
class GetCloudforceOneRequestAssetResult:
    """
    A collection of values returned by getCloudforceOneRequestAsset.
    """
    def __init__(__self__, account_id=None, asset_id=None, created=None, description=None, file_type=None, id=None, name=None, request_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if asset_id and not isinstance(asset_id, str):
            raise TypeError("Expected argument 'asset_id' to be a str")
        pulumi.set(__self__, "asset_id", asset_id)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if file_type and not isinstance(file_type, str):
            raise TypeError("Expected argument 'file_type' to be a str")
        pulumi.set(__self__, "file_type", file_type)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if request_id and not isinstance(request_id, str):
            raise TypeError("Expected argument 'request_id' to be a str")
        pulumi.set(__self__, "request_id", request_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> _builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "asset_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        Defines the asset creation time.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Asset description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileType")
    def file_type(self) -> _builtins.str:
        """
        Asset file type.
        """
        return pulumi.get(self, "file_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        Asset ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Asset name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="requestId")
    def request_id(self) -> _builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "request_id")


class AwaitableGetCloudforceOneRequestAssetResult(GetCloudforceOneRequestAssetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudforceOneRequestAssetResult(
            account_id=self.account_id,
            asset_id=self.asset_id,
            created=self.created,
            description=self.description,
            file_type=self.file_type,
            id=self.id,
            name=self.name,
            request_id=self.request_id)


def get_cloudforce_one_request_asset(account_id: Optional[_builtins.str] = None,
                                     asset_id: Optional[_builtins.str] = None,
                                     request_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudforceOneRequestAssetResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_cloudforce_one_request_asset = cloudflare.get_cloudforce_one_request_asset(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        request_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
        asset_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str asset_id: UUID.
    :param _builtins.str request_id: UUID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['assetId'] = asset_id
    __args__['requestId'] = request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCloudforceOneRequestAsset:getCloudforceOneRequestAsset', __args__, opts=opts, typ=GetCloudforceOneRequestAssetResult).value

    return AwaitableGetCloudforceOneRequestAssetResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        asset_id=pulumi.get(__ret__, 'asset_id'),
        created=pulumi.get(__ret__, 'created'),
        description=pulumi.get(__ret__, 'description'),
        file_type=pulumi.get(__ret__, 'file_type'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        request_id=pulumi.get(__ret__, 'request_id'))
def get_cloudforce_one_request_asset_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            asset_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            request_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudforceOneRequestAssetResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_cloudforce_one_request_asset = cloudflare.get_cloudforce_one_request_asset(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        request_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
        asset_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str asset_id: UUID.
    :param _builtins.str request_id: UUID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['assetId'] = asset_id
    __args__['requestId'] = request_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCloudforceOneRequestAsset:getCloudforceOneRequestAsset', __args__, opts=opts, typ=GetCloudforceOneRequestAssetResult)
    return __ret__.apply(lambda __response__: GetCloudforceOneRequestAssetResult(
        account_id=pulumi.get(__response__, 'account_id'),
        asset_id=pulumi.get(__response__, 'asset_id'),
        created=pulumi.get(__response__, 'created'),
        description=pulumi.get(__response__, 'description'),
        file_type=pulumi.get(__response__, 'file_type'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        request_id=pulumi.get(__response__, 'request_id')))
