# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCustomHostnameFallbackOriginResult',
    'AwaitableGetCustomHostnameFallbackOriginResult',
    'get_custom_hostname_fallback_origin',
    'get_custom_hostname_fallback_origin_output',
]

@pulumi.output_type
class GetCustomHostnameFallbackOriginResult:
    """
    A collection of values returned by getCustomHostnameFallbackOrigin.
    """
    def __init__(__self__, created_at=None, errors=None, id=None, origin=None, status=None, updated_at=None, zone_id=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if errors and not isinstance(errors, list):
            raise TypeError("Expected argument 'errors' to be a list")
        pulumi.set(__self__, "errors", errors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if origin and not isinstance(origin, str):
            raise TypeError("Expected argument 'origin' to be a str")
        pulumi.set(__self__, "origin", origin)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        This is the time the fallback origin was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Sequence[_builtins.str]:
        """
        These are errors that were encountered while trying to activate a fallback origin.
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> _builtins.str:
        """
        Your origin hostname that requests to your custom hostnames will be sent to.
        """
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the fallback origin's activation.
        Available values: "initializing", "pending*deployment", "pending*deletion", "active", "deployment*timed*out", "deletion*timed*out".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        This is the time the fallback origin was updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetCustomHostnameFallbackOriginResult(GetCustomHostnameFallbackOriginResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomHostnameFallbackOriginResult(
            created_at=self.created_at,
            errors=self.errors,
            id=self.id,
            origin=self.origin,
            status=self.status,
            updated_at=self.updated_at,
            zone_id=self.zone_id)


def get_custom_hostname_fallback_origin(zone_id: Optional[_builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomHostnameFallbackOriginResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_custom_hostname_fallback_origin = cloudflare.get_custom_hostname_fallback_origin(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCustomHostnameFallbackOrigin:getCustomHostnameFallbackOrigin', __args__, opts=opts, typ=GetCustomHostnameFallbackOriginResult).value

    return AwaitableGetCustomHostnameFallbackOriginResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        errors=pulumi.get(__ret__, 'errors'),
        id=pulumi.get(__ret__, 'id'),
        origin=pulumi.get(__ret__, 'origin'),
        status=pulumi.get(__ret__, 'status'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_custom_hostname_fallback_origin_output(zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomHostnameFallbackOriginResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_custom_hostname_fallback_origin = cloudflare.get_custom_hostname_fallback_origin(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCustomHostnameFallbackOrigin:getCustomHostnameFallbackOrigin', __args__, opts=opts, typ=GetCustomHostnameFallbackOriginResult)
    return __ret__.apply(lambda __response__: GetCustomHostnameFallbackOriginResult(
        created_at=pulumi.get(__response__, 'created_at'),
        errors=pulumi.get(__response__, 'errors'),
        id=pulumi.get(__response__, 'id'),
        origin=pulumi.get(__response__, 'origin'),
        status=pulumi.get(__response__, 'status'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        zone_id=pulumi.get(__response__, 'zone_id')))
