# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDnsRecordResult',
    'AwaitableGetDnsRecordResult',
    'get_dns_record',
    'get_dns_record_output',
]

@pulumi.output_type
class GetDnsRecordResult:
    """
    A collection of values returned by getDnsRecord.
    """
    def __init__(__self__, comment=None, comment_modified_on=None, content=None, created_on=None, data=None, dns_record_id=None, filter=None, id=None, meta=None, modified_on=None, name=None, priority=None, proxiable=None, proxied=None, settings=None, tags=None, tags_modified_on=None, ttl=None, type=None, zone_id=None):
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if comment_modified_on and not isinstance(comment_modified_on, str):
            raise TypeError("Expected argument 'comment_modified_on' to be a str")
        pulumi.set(__self__, "comment_modified_on", comment_modified_on)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if data and not isinstance(data, dict):
            raise TypeError("Expected argument 'data' to be a dict")
        pulumi.set(__self__, "data", data)
        if dns_record_id and not isinstance(dns_record_id, str):
            raise TypeError("Expected argument 'dns_record_id' to be a str")
        pulumi.set(__self__, "dns_record_id", dns_record_id)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if meta and not isinstance(meta, str):
            raise TypeError("Expected argument 'meta' to be a str")
        pulumi.set(__self__, "meta", meta)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if priority and not isinstance(priority, float):
            raise TypeError("Expected argument 'priority' to be a float")
        pulumi.set(__self__, "priority", priority)
        if proxiable and not isinstance(proxiable, bool):
            raise TypeError("Expected argument 'proxiable' to be a bool")
        pulumi.set(__self__, "proxiable", proxiable)
        if proxied and not isinstance(proxied, bool):
            raise TypeError("Expected argument 'proxied' to be a bool")
        pulumi.set(__self__, "proxied", proxied)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tags_modified_on and not isinstance(tags_modified_on, str):
            raise TypeError("Expected argument 'tags_modified_on' to be a str")
        pulumi.set(__self__, "tags_modified_on", tags_modified_on)
        if ttl and not isinstance(ttl, float):
            raise TypeError("Expected argument 'ttl' to be a float")
        pulumi.set(__self__, "ttl", ttl)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Comments or notes about the DNS record. This field has no effect on DNS responses.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="commentModifiedOn")
    def comment_modified_on(self) -> _builtins.str:
        """
        When the record comment was last modified. Omitted if there is no comment.
        """
        return pulumi.get(self, "comment_modified_on")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        A valid IPv4 address.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        """
        When the record was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def data(self) -> 'outputs.GetDnsRecordDataResult':
        """
        Components of a CAA record.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="dnsRecordId")
    def dns_record_id(self) -> Optional[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "dns_record_id")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetDnsRecordFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> _builtins.str:
        """
        Extra Cloudflare-specific information about the record.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> _builtins.str:
        """
        When the record was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Complete DNS record name, including the zone name, in Punycode.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.float:
        """
        Required for MX, SRV and URI records; unused by other record types. Records with lower priorities are preferred.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def proxiable(self) -> _builtins.bool:
        """
        Whether the record can be proxied by Cloudflare or not.
        """
        return pulumi.get(self, "proxiable")

    @_builtins.property
    @pulumi.getter
    def proxied(self) -> _builtins.bool:
        """
        Whether the record is receiving the performance and security benefits of Cloudflare.
        """
        return pulumi.get(self, "proxied")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> 'outputs.GetDnsRecordSettingsResult':
        """
        Settings for the DNS record.
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Custom tags for the DNS record. This field has no effect on DNS responses.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsModifiedOn")
    def tags_modified_on(self) -> _builtins.str:
        """
        When the record tags were last modified. Omitted if there are no tags.
        """
        return pulumi.get(self, "tags_modified_on")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.float:
        """
        Time To Live (TTL) of the DNS record in seconds. Setting to 1 means 'automatic'. Value must be between 60 and 86400, with the minimum reduced to 30 for Enterprise zones.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Record type.
        Available values: "A", "AAAA", "CNAME", "MX", "NS", "OPENPGPKEY", "PTR", "TXT", "CAA", "CERT", "DNSKEY", "DS", "HTTPS", "LOC", "NAPTR", "SMIMEA", "SRV", "SSHFP", "SVCB", "TLSA", "URI".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetDnsRecordResult(GetDnsRecordResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsRecordResult(
            comment=self.comment,
            comment_modified_on=self.comment_modified_on,
            content=self.content,
            created_on=self.created_on,
            data=self.data,
            dns_record_id=self.dns_record_id,
            filter=self.filter,
            id=self.id,
            meta=self.meta,
            modified_on=self.modified_on,
            name=self.name,
            priority=self.priority,
            proxiable=self.proxiable,
            proxied=self.proxied,
            settings=self.settings,
            tags=self.tags,
            tags_modified_on=self.tags_modified_on,
            ttl=self.ttl,
            type=self.type,
            zone_id=self.zone_id)


def get_dns_record(dns_record_id: Optional[_builtins.str] = None,
                   filter: Optional[Union['GetDnsRecordFilterArgs', 'GetDnsRecordFilterArgsDict']] = None,
                   zone_id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsRecordResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_dns_record = cloudflare.get_dns_record(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        dns_record_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str dns_record_id: Identifier.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['dnsRecordId'] = dns_record_id
    __args__['filter'] = filter
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getDnsRecord:getDnsRecord', __args__, opts=opts, typ=GetDnsRecordResult).value

    return AwaitableGetDnsRecordResult(
        comment=pulumi.get(__ret__, 'comment'),
        comment_modified_on=pulumi.get(__ret__, 'comment_modified_on'),
        content=pulumi.get(__ret__, 'content'),
        created_on=pulumi.get(__ret__, 'created_on'),
        data=pulumi.get(__ret__, 'data'),
        dns_record_id=pulumi.get(__ret__, 'dns_record_id'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        meta=pulumi.get(__ret__, 'meta'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        name=pulumi.get(__ret__, 'name'),
        priority=pulumi.get(__ret__, 'priority'),
        proxiable=pulumi.get(__ret__, 'proxiable'),
        proxied=pulumi.get(__ret__, 'proxied'),
        settings=pulumi.get(__ret__, 'settings'),
        tags=pulumi.get(__ret__, 'tags'),
        tags_modified_on=pulumi.get(__ret__, 'tags_modified_on'),
        ttl=pulumi.get(__ret__, 'ttl'),
        type=pulumi.get(__ret__, 'type'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_dns_record_output(dns_record_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          filter: Optional[pulumi.Input[Optional[Union['GetDnsRecordFilterArgs', 'GetDnsRecordFilterArgsDict']]]] = None,
                          zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsRecordResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_dns_record = cloudflare.get_dns_record(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        dns_record_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str dns_record_id: Identifier.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['dnsRecordId'] = dns_record_id
    __args__['filter'] = filter
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getDnsRecord:getDnsRecord', __args__, opts=opts, typ=GetDnsRecordResult)
    return __ret__.apply(lambda __response__: GetDnsRecordResult(
        comment=pulumi.get(__response__, 'comment'),
        comment_modified_on=pulumi.get(__response__, 'comment_modified_on'),
        content=pulumi.get(__response__, 'content'),
        created_on=pulumi.get(__response__, 'created_on'),
        data=pulumi.get(__response__, 'data'),
        dns_record_id=pulumi.get(__response__, 'dns_record_id'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        meta=pulumi.get(__response__, 'meta'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        name=pulumi.get(__response__, 'name'),
        priority=pulumi.get(__response__, 'priority'),
        proxiable=pulumi.get(__response__, 'proxiable'),
        proxied=pulumi.get(__response__, 'proxied'),
        settings=pulumi.get(__response__, 'settings'),
        tags=pulumi.get(__response__, 'tags'),
        tags_modified_on=pulumi.get(__response__, 'tags_modified_on'),
        ttl=pulumi.get(__response__, 'ttl'),
        type=pulumi.get(__response__, 'type'),
        zone_id=pulumi.get(__response__, 'zone_id')))
