# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEmailRoutingAddressResult',
    'AwaitableGetEmailRoutingAddressResult',
    'get_email_routing_address',
    'get_email_routing_address_output',
]

@pulumi.output_type
class GetEmailRoutingAddressResult:
    """
    A collection of values returned by getEmailRoutingAddress.
    """
    def __init__(__self__, account_id=None, created=None, destination_address_identifier=None, email=None, filter=None, id=None, modified=None, tag=None, verified=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if destination_address_identifier and not isinstance(destination_address_identifier, str):
            raise TypeError("Expected argument 'destination_address_identifier' to be a str")
        pulumi.set(__self__, "destination_address_identifier", destination_address_identifier)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified and not isinstance(modified, str):
            raise TypeError("Expected argument 'modified' to be a str")
        pulumi.set(__self__, "modified", modified)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if verified and not isinstance(verified, str):
            raise TypeError("Expected argument 'verified' to be a str")
        pulumi.set(__self__, "verified", verified)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The date and time the destination address has been created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="destinationAddressIdentifier")
    def destination_address_identifier(self) -> Optional[_builtins.str]:
        """
        Destination address identifier.
        """
        return pulumi.get(self, "destination_address_identifier")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The contact email address of the user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetEmailRoutingAddressFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Destination address identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def modified(self) -> _builtins.str:
        """
        The date and time the destination address was last modified.
        """
        return pulumi.get(self, "modified")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def tag(self) -> _builtins.str:
        """
        Destination address tag. (Deprecated, replaced by destination address identifier)
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def verified(self) -> _builtins.str:
        """
        The date and time the destination address has been verified. Null means not verified yet.
        """
        return pulumi.get(self, "verified")


class AwaitableGetEmailRoutingAddressResult(GetEmailRoutingAddressResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailRoutingAddressResult(
            account_id=self.account_id,
            created=self.created,
            destination_address_identifier=self.destination_address_identifier,
            email=self.email,
            filter=self.filter,
            id=self.id,
            modified=self.modified,
            tag=self.tag,
            verified=self.verified)


def get_email_routing_address(account_id: Optional[_builtins.str] = None,
                              destination_address_identifier: Optional[_builtins.str] = None,
                              filter: Optional[Union['GetEmailRoutingAddressFilterArgs', 'GetEmailRoutingAddressFilterArgsDict']] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailRoutingAddressResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_email_routing_address = cloudflare.get_email_routing_address(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        destination_address_identifier="ea95132c15732412d22c1476fa83f27a")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str destination_address_identifier: Destination address identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['destinationAddressIdentifier'] = destination_address_identifier
    __args__['filter'] = filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getEmailRoutingAddress:getEmailRoutingAddress', __args__, opts=opts, typ=GetEmailRoutingAddressResult).value

    return AwaitableGetEmailRoutingAddressResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created=pulumi.get(__ret__, 'created'),
        destination_address_identifier=pulumi.get(__ret__, 'destination_address_identifier'),
        email=pulumi.get(__ret__, 'email'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        modified=pulumi.get(__ret__, 'modified'),
        tag=pulumi.get(__ret__, 'tag'),
        verified=pulumi.get(__ret__, 'verified'))
def get_email_routing_address_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     destination_address_identifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filter: Optional[pulumi.Input[Optional[Union['GetEmailRoutingAddressFilterArgs', 'GetEmailRoutingAddressFilterArgsDict']]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEmailRoutingAddressResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_email_routing_address = cloudflare.get_email_routing_address(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        destination_address_identifier="ea95132c15732412d22c1476fa83f27a")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str destination_address_identifier: Destination address identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['destinationAddressIdentifier'] = destination_address_identifier
    __args__['filter'] = filter
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getEmailRoutingAddress:getEmailRoutingAddress', __args__, opts=opts, typ=GetEmailRoutingAddressResult)
    return __ret__.apply(lambda __response__: GetEmailRoutingAddressResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created=pulumi.get(__response__, 'created'),
        destination_address_identifier=pulumi.get(__response__, 'destination_address_identifier'),
        email=pulumi.get(__response__, 'email'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        modified=pulumi.get(__response__, 'modified'),
        tag=pulumi.get(__response__, 'tag'),
        verified=pulumi.get(__response__, 'verified')))
