# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFiltersResult',
    'AwaitableGetFiltersResult',
    'get_filters',
    'get_filters_output',
]

@pulumi.output_type
class GetFiltersResult:
    """
    A collection of values returned by getFilters.
    """
    def __init__(__self__, description=None, expression=None, id=None, max_items=None, paused=None, ref=None, results=None, zone_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expression and not isinstance(expression, str):
            raise TypeError("Expected argument 'expression' to be a str")
        pulumi.set(__self__, "expression", expression)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if paused and not isinstance(paused, bool):
            raise TypeError("Expected argument 'paused' to be a bool")
        pulumi.set(__self__, "paused", paused)
        if ref and not isinstance(ref, str):
            raise TypeError("Expected argument 'ref' to be a str")
        pulumi.set(__self__, "ref", ref)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A case-insensitive string to find in the description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        A case-insensitive string to find in the expression.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The unique identifier of the filter.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[_builtins.bool]:
        """
        When true, indicates that the filter is currently paused.
        """
        return pulumi.get(self, "paused")

    @_builtins.property
    @pulumi.getter
    def ref(self) -> Optional[_builtins.str]:
        """
        The filter ref (a short reference tag) to search for. Must be an exact match.
        """
        return pulumi.get(self, "ref")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetFiltersResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetFiltersResult(GetFiltersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFiltersResult(
            description=self.description,
            expression=self.expression,
            id=self.id,
            max_items=self.max_items,
            paused=self.paused,
            ref=self.ref,
            results=self.results,
            zone_id=self.zone_id)


def get_filters(description: Optional[_builtins.str] = None,
                expression: Optional[_builtins.str] = None,
                id: Optional[_builtins.str] = None,
                max_items: Optional[_builtins.int] = None,
                paused: Optional[_builtins.bool] = None,
                ref: Optional[_builtins.str] = None,
                zone_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFiltersResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_filters = cloudflare.get_filters(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        id="372e67954025e0ba6aaa6d586b9e0b61",
        description="browsers",
        expression="php",
        paused=False,
        ref="FIL-100")
    ```


    :param _builtins.str description: A case-insensitive string to find in the description.
    :param _builtins.str expression: A case-insensitive string to find in the expression.
    :param _builtins.str id: The unique identifier of the filter.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.bool paused: When true, indicates that the filter is currently paused.
    :param _builtins.str ref: The filter ref (a short reference tag) to search for. Must be an exact match.
    :param _builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['expression'] = expression
    __args__['id'] = id
    __args__['maxItems'] = max_items
    __args__['paused'] = paused
    __args__['ref'] = ref
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getFilters:getFilters', __args__, opts=opts, typ=GetFiltersResult).value

    return AwaitableGetFiltersResult(
        description=pulumi.get(__ret__, 'description'),
        expression=pulumi.get(__ret__, 'expression'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        paused=pulumi.get(__ret__, 'paused'),
        ref=pulumi.get(__ret__, 'ref'),
        results=pulumi.get(__ret__, 'results'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_filters_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       expression: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       paused: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       ref: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFiltersResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_filters = cloudflare.get_filters(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        id="372e67954025e0ba6aaa6d586b9e0b61",
        description="browsers",
        expression="php",
        paused=False,
        ref="FIL-100")
    ```


    :param _builtins.str description: A case-insensitive string to find in the description.
    :param _builtins.str expression: A case-insensitive string to find in the expression.
    :param _builtins.str id: The unique identifier of the filter.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.bool paused: When true, indicates that the filter is currently paused.
    :param _builtins.str ref: The filter ref (a short reference tag) to search for. Must be an exact match.
    :param _builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['expression'] = expression
    __args__['id'] = id
    __args__['maxItems'] = max_items
    __args__['paused'] = paused
    __args__['ref'] = ref
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getFilters:getFilters', __args__, opts=opts, typ=GetFiltersResult)
    return __ret__.apply(lambda __response__: GetFiltersResult(
        description=pulumi.get(__response__, 'description'),
        expression=pulumi.get(__response__, 'expression'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        paused=pulumi.get(__response__, 'paused'),
        ref=pulumi.get(__response__, 'ref'),
        results=pulumi.get(__response__, 'results'),
        zone_id=pulumi.get(__response__, 'zone_id')))
