# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetLeakedCredentialCheckResult',
    'AwaitableGetLeakedCredentialCheckResult',
    'get_leaked_credential_check',
    'get_leaked_credential_check_output',
]

@pulumi.output_type
class GetLeakedCredentialCheckResult:
    """
    A collection of values returned by getLeakedCredentialCheck.
    """
    def __init__(__self__, enabled=None, id=None, zone_id=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Determines whether or not Leaked Credential Checks are enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetLeakedCredentialCheckResult(GetLeakedCredentialCheckResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLeakedCredentialCheckResult(
            enabled=self.enabled,
            id=self.id,
            zone_id=self.zone_id)


def get_leaked_credential_check(zone_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLeakedCredentialCheckResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_leaked_credential_check = cloudflare.get_leaked_credential_check(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getLeakedCredentialCheck:getLeakedCredentialCheck', __args__, opts=opts, typ=GetLeakedCredentialCheckResult).value

    return AwaitableGetLeakedCredentialCheckResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_leaked_credential_check_output(zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLeakedCredentialCheckResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_leaked_credential_check = cloudflare.get_leaked_credential_check(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getLeakedCredentialCheck:getLeakedCredentialCheck', __args__, opts=opts, typ=GetLeakedCredentialCheckResult)
    return __ret__.apply(lambda __response__: GetLeakedCredentialCheckResult(
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
