# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPageShieldPoliciesResult',
    'AwaitableGetPageShieldPoliciesResult',
    'get_page_shield_policies',
    'get_page_shield_policies_output',
]

@pulumi.output_type
class GetPageShieldPoliciesResult:
    """
    A collection of values returned by getPageShieldPolicies.
    """
    def __init__(__self__, id=None, max_items=None, results=None, zone_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetPageShieldPoliciesResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetPageShieldPoliciesResult(GetPageShieldPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPageShieldPoliciesResult(
            id=self.id,
            max_items=self.max_items,
            results=self.results,
            zone_id=self.zone_id)


def get_page_shield_policies(max_items: Optional[_builtins.int] = None,
                             zone_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPageShieldPoliciesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_page_shield_policies = cloudflare.get_page_shield_policies(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str zone_id: Identifier
    """
    __args__ = dict()
    __args__['maxItems'] = max_items
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getPageShieldPolicies:getPageShieldPolicies', __args__, opts=opts, typ=GetPageShieldPoliciesResult).value

    return AwaitableGetPageShieldPoliciesResult(
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        results=pulumi.get(__ret__, 'results'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_page_shield_policies_output(max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                    zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPageShieldPoliciesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_page_shield_policies = cloudflare.get_page_shield_policies(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str zone_id: Identifier
    """
    __args__ = dict()
    __args__['maxItems'] = max_items
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getPageShieldPolicies:getPageShieldPolicies', __args__, opts=opts, typ=GetPageShieldPoliciesResult)
    return __ret__.apply(lambda __response__: GetPageShieldPoliciesResult(
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        results=pulumi.get(__response__, 'results'),
        zone_id=pulumi.get(__response__, 'zone_id')))
