# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPageShieldPolicyResult',
    'AwaitableGetPageShieldPolicyResult',
    'get_page_shield_policy',
    'get_page_shield_policy_output',
]

@pulumi.output_type
class GetPageShieldPolicyResult:
    """
    A collection of values returned by getPageShieldPolicy.
    """
    def __init__(__self__, action=None, description=None, enabled=None, expression=None, id=None, policy_id=None, value=None, zone_id=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if expression and not isinstance(expression, str):
            raise TypeError("Expected argument 'expression' to be a str")
        pulumi.set(__self__, "expression", expression)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take if the expression matches
        Available values: "allow", "log".
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description for the policy
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the policy is enabled
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        The expression which must match for the policy to be applied, using the Cloudflare Firewall rule expression syntax
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The policy which will be applied
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetPageShieldPolicyResult(GetPageShieldPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPageShieldPolicyResult(
            action=self.action,
            description=self.description,
            enabled=self.enabled,
            expression=self.expression,
            id=self.id,
            policy_id=self.policy_id,
            value=self.value,
            zone_id=self.zone_id)


def get_page_shield_policy(policy_id: Optional[_builtins.str] = None,
                           zone_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPageShieldPolicyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_page_shield_policy = cloudflare.get_page_shield_policy(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        policy_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str policy_id: Identifier
    :param _builtins.str zone_id: Identifier
    """
    __args__ = dict()
    __args__['policyId'] = policy_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getPageShieldPolicy:getPageShieldPolicy', __args__, opts=opts, typ=GetPageShieldPolicyResult).value

    return AwaitableGetPageShieldPolicyResult(
        action=pulumi.get(__ret__, 'action'),
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        expression=pulumi.get(__ret__, 'expression'),
        id=pulumi.get(__ret__, 'id'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        value=pulumi.get(__ret__, 'value'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_page_shield_policy_output(policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPageShieldPolicyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_page_shield_policy = cloudflare.get_page_shield_policy(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        policy_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str policy_id: Identifier
    :param _builtins.str zone_id: Identifier
    """
    __args__ = dict()
    __args__['policyId'] = policy_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getPageShieldPolicy:getPageShieldPolicy', __args__, opts=opts, typ=GetPageShieldPolicyResult)
    return __ret__.apply(lambda __response__: GetPageShieldPolicyResult(
        action=pulumi.get(__response__, 'action'),
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        expression=pulumi.get(__response__, 'expression'),
        id=pulumi.get(__response__, 'id'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        value=pulumi.get(__response__, 'value'),
        zone_id=pulumi.get(__response__, 'zone_id')))
