# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetR2BucketSippyResult',
    'AwaitableGetR2BucketSippyResult',
    'get_r2_bucket_sippy',
    'get_r2_bucket_sippy_output',
]

@pulumi.output_type
class GetR2BucketSippyResult:
    """
    A collection of values returned by getR2BucketSippy.
    """
    def __init__(__self__, account_id=None, bucket_name=None, destination=None, enabled=None, id=None, source=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if bucket_name and not isinstance(bucket_name, str):
            raise TypeError("Expected argument 'bucket_name' to be a str")
        pulumi.set(__self__, "bucket_name", bucket_name)
        if destination and not isinstance(destination, dict):
            raise TypeError("Expected argument 'destination' to be a dict")
        pulumi.set(__self__, "destination", destination)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if source and not isinstance(source, dict):
            raise TypeError("Expected argument 'source' to be a dict")
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> 'outputs.GetR2BucketSippyDestinationResult':
        """
        Details about the configured destination bucket.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        State of Sippy for this bucket.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def source(self) -> 'outputs.GetR2BucketSippySourceResult':
        """
        Details about the configured source bucket.
        """
        return pulumi.get(self, "source")


class AwaitableGetR2BucketSippyResult(GetR2BucketSippyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetR2BucketSippyResult(
            account_id=self.account_id,
            bucket_name=self.bucket_name,
            destination=self.destination,
            enabled=self.enabled,
            id=self.id,
            source=self.source)


def get_r2_bucket_sippy(account_id: Optional[_builtins.str] = None,
                        bucket_name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetR2BucketSippyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_r2_bucket_sippy = cloudflare.get_r2_bucket_sippy(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        bucket_name="example-bucket")
    ```


    :param _builtins.str account_id: Account ID.
    :param _builtins.str bucket_name: Name of the bucket.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['bucketName'] = bucket_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getR2BucketSippy:getR2BucketSippy', __args__, opts=opts, typ=GetR2BucketSippyResult).value

    return AwaitableGetR2BucketSippyResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        bucket_name=pulumi.get(__ret__, 'bucket_name'),
        destination=pulumi.get(__ret__, 'destination'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        source=pulumi.get(__ret__, 'source'))
def get_r2_bucket_sippy_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                               bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetR2BucketSippyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_r2_bucket_sippy = cloudflare.get_r2_bucket_sippy(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        bucket_name="example-bucket")
    ```


    :param _builtins.str account_id: Account ID.
    :param _builtins.str bucket_name: Name of the bucket.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['bucketName'] = bucket_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getR2BucketSippy:getR2BucketSippy', __args__, opts=opts, typ=GetR2BucketSippyResult)
    return __ret__.apply(lambda __response__: GetR2BucketSippyResult(
        account_id=pulumi.get(__response__, 'account_id'),
        bucket_name=pulumi.get(__response__, 'bucket_name'),
        destination=pulumi.get(__response__, 'destination'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        source=pulumi.get(__response__, 'source')))
