# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetR2CustomDomainResult',
    'AwaitableGetR2CustomDomainResult',
    'get_r2_custom_domain',
    'get_r2_custom_domain_output',
]

@pulumi.output_type
class GetR2CustomDomainResult:
    """
    A collection of values returned by getR2CustomDomain.
    """
    def __init__(__self__, account_id=None, bucket_name=None, ciphers=None, domain=None, enabled=None, id=None, min_tls=None, status=None, zone_id=None, zone_name=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if bucket_name and not isinstance(bucket_name, str):
            raise TypeError("Expected argument 'bucket_name' to be a str")
        pulumi.set(__self__, "bucket_name", bucket_name)
        if ciphers and not isinstance(ciphers, list):
            raise TypeError("Expected argument 'ciphers' to be a list")
        pulumi.set(__self__, "ciphers", ciphers)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if min_tls and not isinstance(min_tls, str):
            raise TypeError("Expected argument 'min_tls' to be a str")
        pulumi.set(__self__, "min_tls", min_tls)
        if status and not isinstance(status, dict):
            raise TypeError("Expected argument 'status' to be a dict")
        pulumi.set(__self__, "status", status)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)
        if zone_name and not isinstance(zone_name, str):
            raise TypeError("Expected argument 'zone_name' to be a str")
        pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> Sequence[_builtins.str]:
        """
        An allowlist of ciphers for TLS termination. These ciphers must be in the BoringSSL format.
        """
        return pulumi.get(self, "ciphers")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Name of the custom domain.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether this bucket is publicly accessible at the specified custom domain.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="minTls")
    def min_tls(self) -> _builtins.str:
        """
        Minimum TLS Version the custom domain will accept for incoming connections. If not set, defaults to 1.0.
        Available values: "1.0", "1.1", "1.2", "1.3".
        """
        return pulumi.get(self, "min_tls")

    @_builtins.property
    @pulumi.getter
    def status(self) -> 'outputs.GetR2CustomDomainStatusResult':
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Zone ID of the custom domain resides in.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> _builtins.str:
        """
        Zone that the custom domain resides in.
        """
        return pulumi.get(self, "zone_name")


class AwaitableGetR2CustomDomainResult(GetR2CustomDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetR2CustomDomainResult(
            account_id=self.account_id,
            bucket_name=self.bucket_name,
            ciphers=self.ciphers,
            domain=self.domain,
            enabled=self.enabled,
            id=self.id,
            min_tls=self.min_tls,
            status=self.status,
            zone_id=self.zone_id,
            zone_name=self.zone_name)


def get_r2_custom_domain(account_id: Optional[_builtins.str] = None,
                         bucket_name: Optional[_builtins.str] = None,
                         domain: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetR2CustomDomainResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_r2_custom_domain = cloudflare.get_r2_custom_domain(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        bucket_name="example-bucket",
        domain="example-domain/custom-domain.com")
    ```


    :param _builtins.str account_id: Account ID.
    :param _builtins.str bucket_name: Name of the bucket.
    :param _builtins.str domain: Name of the custom domain.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['bucketName'] = bucket_name
    __args__['domain'] = domain
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getR2CustomDomain:getR2CustomDomain', __args__, opts=opts, typ=GetR2CustomDomainResult).value

    return AwaitableGetR2CustomDomainResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        bucket_name=pulumi.get(__ret__, 'bucket_name'),
        ciphers=pulumi.get(__ret__, 'ciphers'),
        domain=pulumi.get(__ret__, 'domain'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        min_tls=pulumi.get(__ret__, 'min_tls'),
        status=pulumi.get(__ret__, 'status'),
        zone_id=pulumi.get(__ret__, 'zone_id'),
        zone_name=pulumi.get(__ret__, 'zone_name'))
def get_r2_custom_domain_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                                domain: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetR2CustomDomainResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_r2_custom_domain = cloudflare.get_r2_custom_domain(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        bucket_name="example-bucket",
        domain="example-domain/custom-domain.com")
    ```


    :param _builtins.str account_id: Account ID.
    :param _builtins.str bucket_name: Name of the bucket.
    :param _builtins.str domain: Name of the custom domain.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['bucketName'] = bucket_name
    __args__['domain'] = domain
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getR2CustomDomain:getR2CustomDomain', __args__, opts=opts, typ=GetR2CustomDomainResult)
    return __ret__.apply(lambda __response__: GetR2CustomDomainResult(
        account_id=pulumi.get(__response__, 'account_id'),
        bucket_name=pulumi.get(__response__, 'bucket_name'),
        ciphers=pulumi.get(__response__, 'ciphers'),
        domain=pulumi.get(__response__, 'domain'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        min_tls=pulumi.get(__response__, 'min_tls'),
        status=pulumi.get(__response__, 'status'),
        zone_id=pulumi.get(__response__, 'zone_id'),
        zone_name=pulumi.get(__response__, 'zone_name')))
