# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRulesetsResult',
    'AwaitableGetRulesetsResult',
    'get_rulesets',
    'get_rulesets_output',
]

@pulumi.output_type
class GetRulesetsResult:
    """
    A collection of values returned by getRulesets.
    """
    def __init__(__self__, account_id=None, id=None, max_items=None, results=None, rulesets=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if rulesets and not isinstance(rulesets, list):
            raise TypeError("Expected argument 'rulesets' to be a list")
        pulumi.set(__self__, "rulesets", rulesets)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The unique ID of the account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Maximum number of rulesets to fetch (defaults to 1000).
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use rulesets instead. This attribute will be removed in the next major version of the provider.""")
    def results(self) -> Sequence['outputs.GetRulesetsResultResult']:
        """
        A list of rulesets. The returned information will not include the rules in each ruleset.
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter
    def rulesets(self) -> Sequence['outputs.GetRulesetsRulesetResult']:
        """
        A list of rulesets. The returned information will not include the rules in each ruleset.
        """
        return pulumi.get(self, "rulesets")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The unique ID of the zone.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetRulesetsResult(GetRulesetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRulesetsResult(
            account_id=self.account_id,
            id=self.id,
            max_items=self.max_items,
            results=self.results,
            rulesets=self.rulesets,
            zone_id=self.zone_id)


def get_rulesets(account_id: Optional[_builtins.str] = None,
                 max_items: Optional[_builtins.int] = None,
                 zone_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRulesetsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_rulesets = cloudflare.get_rulesets(zone_id="9f1839b6152d298aca64c4e906b6d074")
    ```


    :param _builtins.str account_id: The unique ID of the account.
    :param _builtins.int max_items: Maximum number of rulesets to fetch (defaults to 1000).
    :param _builtins.str zone_id: The unique ID of the zone.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['maxItems'] = max_items
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getRulesets:getRulesets', __args__, opts=opts, typ=GetRulesetsResult).value

    return AwaitableGetRulesetsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        results=pulumi.get(__ret__, 'results'),
        rulesets=pulumi.get(__ret__, 'rulesets'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_rulesets_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRulesetsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_rulesets = cloudflare.get_rulesets(zone_id="9f1839b6152d298aca64c4e906b6d074")
    ```


    :param _builtins.str account_id: The unique ID of the account.
    :param _builtins.int max_items: Maximum number of rulesets to fetch (defaults to 1000).
    :param _builtins.str zone_id: The unique ID of the zone.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['maxItems'] = max_items
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getRulesets:getRulesets', __args__, opts=opts, typ=GetRulesetsResult)
    return __ret__.apply(lambda __response__: GetRulesetsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        results=pulumi.get(__response__, 'results'),
        rulesets=pulumi.get(__response__, 'rulesets'),
        zone_id=pulumi.get(__response__, 'zone_id')))
