# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetWaitingRoomResult',
    'AwaitableGetWaitingRoomResult',
    'get_waiting_room',
    'get_waiting_room_output',
]

@pulumi.output_type
class GetWaitingRoomResult:
    """
    A collection of values returned by getWaitingRoom.
    """
    def __init__(__self__, additional_routes=None, cookie_attributes=None, cookie_suffix=None, created_on=None, custom_page_html=None, default_template_language=None, description=None, disable_session_renewal=None, enabled_origin_commands=None, host=None, id=None, json_response_enabled=None, modified_on=None, name=None, new_users_per_minute=None, next_event_prequeue_start_time=None, next_event_start_time=None, path=None, queue_all=None, queueing_method=None, queueing_status_code=None, session_duration=None, suspended=None, total_active_users=None, turnstile_action=None, turnstile_mode=None, waiting_room_id=None, zone_id=None):
        if additional_routes and not isinstance(additional_routes, list):
            raise TypeError("Expected argument 'additional_routes' to be a list")
        pulumi.set(__self__, "additional_routes", additional_routes)
        if cookie_attributes and not isinstance(cookie_attributes, dict):
            raise TypeError("Expected argument 'cookie_attributes' to be a dict")
        pulumi.set(__self__, "cookie_attributes", cookie_attributes)
        if cookie_suffix and not isinstance(cookie_suffix, str):
            raise TypeError("Expected argument 'cookie_suffix' to be a str")
        pulumi.set(__self__, "cookie_suffix", cookie_suffix)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if custom_page_html and not isinstance(custom_page_html, str):
            raise TypeError("Expected argument 'custom_page_html' to be a str")
        pulumi.set(__self__, "custom_page_html", custom_page_html)
        if default_template_language and not isinstance(default_template_language, str):
            raise TypeError("Expected argument 'default_template_language' to be a str")
        pulumi.set(__self__, "default_template_language", default_template_language)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disable_session_renewal and not isinstance(disable_session_renewal, bool):
            raise TypeError("Expected argument 'disable_session_renewal' to be a bool")
        pulumi.set(__self__, "disable_session_renewal", disable_session_renewal)
        if enabled_origin_commands and not isinstance(enabled_origin_commands, list):
            raise TypeError("Expected argument 'enabled_origin_commands' to be a list")
        pulumi.set(__self__, "enabled_origin_commands", enabled_origin_commands)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if json_response_enabled and not isinstance(json_response_enabled, bool):
            raise TypeError("Expected argument 'json_response_enabled' to be a bool")
        pulumi.set(__self__, "json_response_enabled", json_response_enabled)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if new_users_per_minute and not isinstance(new_users_per_minute, int):
            raise TypeError("Expected argument 'new_users_per_minute' to be a int")
        pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        if next_event_prequeue_start_time and not isinstance(next_event_prequeue_start_time, str):
            raise TypeError("Expected argument 'next_event_prequeue_start_time' to be a str")
        pulumi.set(__self__, "next_event_prequeue_start_time", next_event_prequeue_start_time)
        if next_event_start_time and not isinstance(next_event_start_time, str):
            raise TypeError("Expected argument 'next_event_start_time' to be a str")
        pulumi.set(__self__, "next_event_start_time", next_event_start_time)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if queue_all and not isinstance(queue_all, bool):
            raise TypeError("Expected argument 'queue_all' to be a bool")
        pulumi.set(__self__, "queue_all", queue_all)
        if queueing_method and not isinstance(queueing_method, str):
            raise TypeError("Expected argument 'queueing_method' to be a str")
        pulumi.set(__self__, "queueing_method", queueing_method)
        if queueing_status_code and not isinstance(queueing_status_code, int):
            raise TypeError("Expected argument 'queueing_status_code' to be a int")
        pulumi.set(__self__, "queueing_status_code", queueing_status_code)
        if session_duration and not isinstance(session_duration, int):
            raise TypeError("Expected argument 'session_duration' to be a int")
        pulumi.set(__self__, "session_duration", session_duration)
        if suspended and not isinstance(suspended, bool):
            raise TypeError("Expected argument 'suspended' to be a bool")
        pulumi.set(__self__, "suspended", suspended)
        if total_active_users and not isinstance(total_active_users, int):
            raise TypeError("Expected argument 'total_active_users' to be a int")
        pulumi.set(__self__, "total_active_users", total_active_users)
        if turnstile_action and not isinstance(turnstile_action, str):
            raise TypeError("Expected argument 'turnstile_action' to be a str")
        pulumi.set(__self__, "turnstile_action", turnstile_action)
        if turnstile_mode and not isinstance(turnstile_mode, str):
            raise TypeError("Expected argument 'turnstile_mode' to be a str")
        pulumi.set(__self__, "turnstile_mode", turnstile_mode)
        if waiting_room_id and not isinstance(waiting_room_id, str):
            raise TypeError("Expected argument 'waiting_room_id' to be a str")
        pulumi.set(__self__, "waiting_room_id", waiting_room_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="additionalRoutes")
    def additional_routes(self) -> Sequence['outputs.GetWaitingRoomAdditionalRouteResult']:
        """
        Only available for the Waiting Room Advanced subscription. Additional hostname and path combinations to which this waiting room will be applied. There is an implied wildcard at the end of the path. The hostname and path combination must be unique to this and all other waiting rooms.
        """
        return pulumi.get(self, "additional_routes")

    @_builtins.property
    @pulumi.getter(name="cookieAttributes")
    def cookie_attributes(self) -> 'outputs.GetWaitingRoomCookieAttributesResult':
        """
        Configures cookie attributes for the waiting room cookie. This encrypted cookie stores a user's status in the waiting room, such as queue position.
        """
        return pulumi.get(self, "cookie_attributes")

    @_builtins.property
    @pulumi.getter(name="cookieSuffix")
    def cookie_suffix(self) -> _builtins.str:
        """
        Appends a '_' + a custom suffix to the end of Cloudflare Waiting Room's cookie name(_*cf*waitingroom). If `cookie_suffix` is "abcd", the cookie name will be `__cf_waitingroom_abcd`. This field is required if using `additional_routes`.
        """
        return pulumi.get(self, "cookie_suffix")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> _builtins.str:
        """
        Only available for the Waiting Room Advanced subscription. This is a template html file that will be rendered at the edge. If no custom*page*html is provided, the default waiting room will be used. The template is based on mustache ( https://mustache.github.io/ ). There are several variables that are evaluated by the Cloudflare edge:
        """
        return pulumi.get(self, "custom_page_html")

    @_builtins.property
    @pulumi.getter(name="defaultTemplateLanguage")
    def default_template_language(self) -> _builtins.str:
        return pulumi.get(self, "default_template_language")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> _builtins.bool:
        return pulumi.get(self, "disable_session_renewal")

    @_builtins.property
    @pulumi.getter(name="enabledOriginCommands")
    def enabled_origin_commands(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "enabled_origin_commands")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jsonResponseEnabled")
    def json_response_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "json_response_enabled")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> _builtins.str:
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> _builtins.int:
        return pulumi.get(self, "new_users_per_minute")

    @_builtins.property
    @pulumi.getter(name="nextEventPrequeueStartTime")
    def next_event_prequeue_start_time(self) -> _builtins.str:
        return pulumi.get(self, "next_event_prequeue_start_time")

    @_builtins.property
    @pulumi.getter(name="nextEventStartTime")
    def next_event_start_time(self) -> _builtins.str:
        return pulumi.get(self, "next_event_start_time")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="queueAll")
    def queue_all(self) -> _builtins.bool:
        return pulumi.get(self, "queue_all")

    @_builtins.property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> _builtins.str:
        return pulumi.get(self, "queueing_method")

    @_builtins.property
    @pulumi.getter(name="queueingStatusCode")
    def queueing_status_code(self) -> _builtins.int:
        return pulumi.get(self, "queueing_status_code")

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> _builtins.int:
        return pulumi.get(self, "session_duration")

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> _builtins.bool:
        return pulumi.get(self, "suspended")

    @_builtins.property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> _builtins.int:
        return pulumi.get(self, "total_active_users")

    @_builtins.property
    @pulumi.getter(name="turnstileAction")
    def turnstile_action(self) -> _builtins.str:
        return pulumi.get(self, "turnstile_action")

    @_builtins.property
    @pulumi.getter(name="turnstileMode")
    def turnstile_mode(self) -> _builtins.str:
        return pulumi.get(self, "turnstile_mode")

    @_builtins.property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "waiting_room_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetWaitingRoomResult(GetWaitingRoomResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWaitingRoomResult(
            additional_routes=self.additional_routes,
            cookie_attributes=self.cookie_attributes,
            cookie_suffix=self.cookie_suffix,
            created_on=self.created_on,
            custom_page_html=self.custom_page_html,
            default_template_language=self.default_template_language,
            description=self.description,
            disable_session_renewal=self.disable_session_renewal,
            enabled_origin_commands=self.enabled_origin_commands,
            host=self.host,
            id=self.id,
            json_response_enabled=self.json_response_enabled,
            modified_on=self.modified_on,
            name=self.name,
            new_users_per_minute=self.new_users_per_minute,
            next_event_prequeue_start_time=self.next_event_prequeue_start_time,
            next_event_start_time=self.next_event_start_time,
            path=self.path,
            queue_all=self.queue_all,
            queueing_method=self.queueing_method,
            queueing_status_code=self.queueing_status_code,
            session_duration=self.session_duration,
            suspended=self.suspended,
            total_active_users=self.total_active_users,
            turnstile_action=self.turnstile_action,
            turnstile_mode=self.turnstile_mode,
            waiting_room_id=self.waiting_room_id,
            zone_id=self.zone_id)


def get_waiting_room(waiting_room_id: Optional[_builtins.str] = None,
                     zone_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWaitingRoomResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_waiting_room = cloudflare.get_waiting_room(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        waiting_room_id="699d98642c564d2e855e9661899b7252")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['waitingRoomId'] = waiting_room_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWaitingRoom:getWaitingRoom', __args__, opts=opts, typ=GetWaitingRoomResult).value

    return AwaitableGetWaitingRoomResult(
        additional_routes=pulumi.get(__ret__, 'additional_routes'),
        cookie_attributes=pulumi.get(__ret__, 'cookie_attributes'),
        cookie_suffix=pulumi.get(__ret__, 'cookie_suffix'),
        created_on=pulumi.get(__ret__, 'created_on'),
        custom_page_html=pulumi.get(__ret__, 'custom_page_html'),
        default_template_language=pulumi.get(__ret__, 'default_template_language'),
        description=pulumi.get(__ret__, 'description'),
        disable_session_renewal=pulumi.get(__ret__, 'disable_session_renewal'),
        enabled_origin_commands=pulumi.get(__ret__, 'enabled_origin_commands'),
        host=pulumi.get(__ret__, 'host'),
        id=pulumi.get(__ret__, 'id'),
        json_response_enabled=pulumi.get(__ret__, 'json_response_enabled'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        name=pulumi.get(__ret__, 'name'),
        new_users_per_minute=pulumi.get(__ret__, 'new_users_per_minute'),
        next_event_prequeue_start_time=pulumi.get(__ret__, 'next_event_prequeue_start_time'),
        next_event_start_time=pulumi.get(__ret__, 'next_event_start_time'),
        path=pulumi.get(__ret__, 'path'),
        queue_all=pulumi.get(__ret__, 'queue_all'),
        queueing_method=pulumi.get(__ret__, 'queueing_method'),
        queueing_status_code=pulumi.get(__ret__, 'queueing_status_code'),
        session_duration=pulumi.get(__ret__, 'session_duration'),
        suspended=pulumi.get(__ret__, 'suspended'),
        total_active_users=pulumi.get(__ret__, 'total_active_users'),
        turnstile_action=pulumi.get(__ret__, 'turnstile_action'),
        turnstile_mode=pulumi.get(__ret__, 'turnstile_mode'),
        waiting_room_id=pulumi.get(__ret__, 'waiting_room_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_waiting_room_output(waiting_room_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWaitingRoomResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_waiting_room = cloudflare.get_waiting_room(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        waiting_room_id="699d98642c564d2e855e9661899b7252")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['waitingRoomId'] = waiting_room_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWaitingRoom:getWaitingRoom', __args__, opts=opts, typ=GetWaitingRoomResult)
    return __ret__.apply(lambda __response__: GetWaitingRoomResult(
        additional_routes=pulumi.get(__response__, 'additional_routes'),
        cookie_attributes=pulumi.get(__response__, 'cookie_attributes'),
        cookie_suffix=pulumi.get(__response__, 'cookie_suffix'),
        created_on=pulumi.get(__response__, 'created_on'),
        custom_page_html=pulumi.get(__response__, 'custom_page_html'),
        default_template_language=pulumi.get(__response__, 'default_template_language'),
        description=pulumi.get(__response__, 'description'),
        disable_session_renewal=pulumi.get(__response__, 'disable_session_renewal'),
        enabled_origin_commands=pulumi.get(__response__, 'enabled_origin_commands'),
        host=pulumi.get(__response__, 'host'),
        id=pulumi.get(__response__, 'id'),
        json_response_enabled=pulumi.get(__response__, 'json_response_enabled'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        name=pulumi.get(__response__, 'name'),
        new_users_per_minute=pulumi.get(__response__, 'new_users_per_minute'),
        next_event_prequeue_start_time=pulumi.get(__response__, 'next_event_prequeue_start_time'),
        next_event_start_time=pulumi.get(__response__, 'next_event_start_time'),
        path=pulumi.get(__response__, 'path'),
        queue_all=pulumi.get(__response__, 'queue_all'),
        queueing_method=pulumi.get(__response__, 'queueing_method'),
        queueing_status_code=pulumi.get(__response__, 'queueing_status_code'),
        session_duration=pulumi.get(__response__, 'session_duration'),
        suspended=pulumi.get(__response__, 'suspended'),
        total_active_users=pulumi.get(__response__, 'total_active_users'),
        turnstile_action=pulumi.get(__response__, 'turnstile_action'),
        turnstile_mode=pulumi.get(__response__, 'turnstile_mode'),
        waiting_room_id=pulumi.get(__response__, 'waiting_room_id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
