# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetWaitingRoomRulesResult',
    'AwaitableGetWaitingRoomRulesResult',
    'get_waiting_room_rules',
    'get_waiting_room_rules_output',
]

@pulumi.output_type
class GetWaitingRoomRulesResult:
    """
    A collection of values returned by getWaitingRoomRules.
    """
    def __init__(__self__, action=None, description=None, enabled=None, expression=None, id=None, last_updated=None, version=None, waiting_room_id=None, zone_id=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if expression and not isinstance(expression, str):
            raise TypeError("Expected argument 'expression' to be a str")
        pulumi.set(__self__, "expression", expression)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if waiting_room_id and not isinstance(waiting_room_id, str):
            raise TypeError("Expected argument 'waiting_room_id' to be a str")
        pulumi.set(__self__, "waiting_room_id", waiting_room_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when the expression matches.
        Available values: "bypass*waiting*room".
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        When set to true, the rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Criteria defining when there is a match for the current rule.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the rule.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> _builtins.str:
        return pulumi.get(self, "waiting_room_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetWaitingRoomRulesResult(GetWaitingRoomRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWaitingRoomRulesResult(
            action=self.action,
            description=self.description,
            enabled=self.enabled,
            expression=self.expression,
            id=self.id,
            last_updated=self.last_updated,
            version=self.version,
            waiting_room_id=self.waiting_room_id,
            zone_id=self.zone_id)


def get_waiting_room_rules(waiting_room_id: Optional[_builtins.str] = None,
                           zone_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWaitingRoomRulesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_waiting_room_rules = cloudflare.get_waiting_room_rules(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        waiting_room_id="699d98642c564d2e855e9661899b7252")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['waitingRoomId'] = waiting_room_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWaitingRoomRules:getWaitingRoomRules', __args__, opts=opts, typ=GetWaitingRoomRulesResult).value

    return AwaitableGetWaitingRoomRulesResult(
        action=pulumi.get(__ret__, 'action'),
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        expression=pulumi.get(__ret__, 'expression'),
        id=pulumi.get(__ret__, 'id'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        version=pulumi.get(__ret__, 'version'),
        waiting_room_id=pulumi.get(__ret__, 'waiting_room_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_waiting_room_rules_output(waiting_room_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWaitingRoomRulesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_waiting_room_rules = cloudflare.get_waiting_room_rules(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        waiting_room_id="699d98642c564d2e855e9661899b7252")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['waitingRoomId'] = waiting_room_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWaitingRoomRules:getWaitingRoomRules', __args__, opts=opts, typ=GetWaitingRoomRulesResult)
    return __ret__.apply(lambda __response__: GetWaitingRoomRulesResult(
        action=pulumi.get(__response__, 'action'),
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        expression=pulumi.get(__response__, 'expression'),
        id=pulumi.get(__response__, 'id'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        version=pulumi.get(__response__, 'version'),
        waiting_room_id=pulumi.get(__response__, 'waiting_room_id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
