# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWebAnalyticsSiteResult',
    'AwaitableGetWebAnalyticsSiteResult',
    'get_web_analytics_site',
    'get_web_analytics_site_output',
]

@pulumi.output_type
class GetWebAnalyticsSiteResult:
    """
    A collection of values returned by getWebAnalyticsSite.
    """
    def __init__(__self__, account_id=None, auto_install=None, created=None, filter=None, id=None, rules=None, ruleset=None, site_id=None, site_tag=None, site_token=None, snippet=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if auto_install and not isinstance(auto_install, bool):
            raise TypeError("Expected argument 'auto_install' to be a bool")
        pulumi.set(__self__, "auto_install", auto_install)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if ruleset and not isinstance(ruleset, dict):
            raise TypeError("Expected argument 'ruleset' to be a dict")
        pulumi.set(__self__, "ruleset", ruleset)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)
        if site_tag and not isinstance(site_tag, str):
            raise TypeError("Expected argument 'site_tag' to be a str")
        pulumi.set(__self__, "site_tag", site_tag)
        if site_token and not isinstance(site_token, str):
            raise TypeError("Expected argument 'site_token' to be a str")
        pulumi.set(__self__, "site_token", site_token)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="autoInstall")
    def auto_install(self) -> _builtins.bool:
        """
        If enabled, the JavaScript snippet is automatically injected for orange-clouded sites.
        """
        return pulumi.get(self, "auto_install")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetWebAnalyticsSiteFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetWebAnalyticsSiteRuleResult']:
        """
        A list of rules.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def ruleset(self) -> 'outputs.GetWebAnalyticsSiteRulesetResult':
        return pulumi.get(self, "ruleset")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteTag")
    def site_tag(self) -> _builtins.str:
        """
        The Web Analytics site identifier.
        """
        return pulumi.get(self, "site_tag")

    @_builtins.property
    @pulumi.getter(name="siteToken")
    def site_token(self) -> _builtins.str:
        """
        The Web Analytics site token.
        """
        return pulumi.get(self, "site_token")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        Encoded JavaScript snippet.
        """
        return pulumi.get(self, "snippet")


class AwaitableGetWebAnalyticsSiteResult(GetWebAnalyticsSiteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWebAnalyticsSiteResult(
            account_id=self.account_id,
            auto_install=self.auto_install,
            created=self.created,
            filter=self.filter,
            id=self.id,
            rules=self.rules,
            ruleset=self.ruleset,
            site_id=self.site_id,
            site_tag=self.site_tag,
            site_token=self.site_token,
            snippet=self.snippet)


def get_web_analytics_site(account_id: Optional[_builtins.str] = None,
                           filter: Optional[Union['GetWebAnalyticsSiteFilterArgs', 'GetWebAnalyticsSiteFilterArgsDict']] = None,
                           site_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWebAnalyticsSiteResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_web_analytics_site = cloudflare.get_web_analytics_site(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        site_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str site_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWebAnalyticsSite:getWebAnalyticsSite', __args__, opts=opts, typ=GetWebAnalyticsSiteResult).value

    return AwaitableGetWebAnalyticsSiteResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        auto_install=pulumi.get(__ret__, 'auto_install'),
        created=pulumi.get(__ret__, 'created'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        rules=pulumi.get(__ret__, 'rules'),
        ruleset=pulumi.get(__ret__, 'ruleset'),
        site_id=pulumi.get(__ret__, 'site_id'),
        site_tag=pulumi.get(__ret__, 'site_tag'),
        site_token=pulumi.get(__ret__, 'site_token'),
        snippet=pulumi.get(__ret__, 'snippet'))
def get_web_analytics_site_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  filter: Optional[pulumi.Input[Optional[Union['GetWebAnalyticsSiteFilterArgs', 'GetWebAnalyticsSiteFilterArgsDict']]]] = None,
                                  site_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWebAnalyticsSiteResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_web_analytics_site = cloudflare.get_web_analytics_site(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        site_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str site_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWebAnalyticsSite:getWebAnalyticsSite', __args__, opts=opts, typ=GetWebAnalyticsSiteResult)
    return __ret__.apply(lambda __response__: GetWebAnalyticsSiteResult(
        account_id=pulumi.get(__response__, 'account_id'),
        auto_install=pulumi.get(__response__, 'auto_install'),
        created=pulumi.get(__response__, 'created'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        rules=pulumi.get(__response__, 'rules'),
        ruleset=pulumi.get(__response__, 'ruleset'),
        site_id=pulumi.get(__response__, 'site_id'),
        site_tag=pulumi.get(__response__, 'site_tag'),
        site_token=pulumi.get(__response__, 'site_token'),
        snippet=pulumi.get(__response__, 'snippet')))
