# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetWorkersCustomDomainsResult',
    'AwaitableGetWorkersCustomDomainsResult',
    'get_workers_custom_domains',
    'get_workers_custom_domains_output',
]

@pulumi.output_type
class GetWorkersCustomDomainsResult:
    """
    A collection of values returned by getWorkersCustomDomains.
    """
    def __init__(__self__, account_id=None, environment=None, hostname=None, id=None, max_items=None, results=None, service=None, zone_id=None, zone_name=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if service and not isinstance(service, str):
            raise TypeError("Expected argument 'service' to be a str")
        pulumi.set(__self__, "service", service)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)
        if zone_name and not isinstance(zone_name, str):
            raise TypeError("Expected argument 'zone_name' to be a str")
        pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifer of the account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[_builtins.str]:
        """
        Worker environment associated with the zone and hostname.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the Worker Domain.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetWorkersCustomDomainsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        Worker service associated with the zone and hostname.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        Identifier of the zone.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> Optional[_builtins.str]:
        """
        Name of the zone.
        """
        return pulumi.get(self, "zone_name")


class AwaitableGetWorkersCustomDomainsResult(GetWorkersCustomDomainsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkersCustomDomainsResult(
            account_id=self.account_id,
            environment=self.environment,
            hostname=self.hostname,
            id=self.id,
            max_items=self.max_items,
            results=self.results,
            service=self.service,
            zone_id=self.zone_id,
            zone_name=self.zone_name)


def get_workers_custom_domains(account_id: Optional[_builtins.str] = None,
                               environment: Optional[_builtins.str] = None,
                               hostname: Optional[_builtins.str] = None,
                               max_items: Optional[_builtins.int] = None,
                               service: Optional[_builtins.str] = None,
                               zone_id: Optional[_builtins.str] = None,
                               zone_name: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkersCustomDomainsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_workers_custom_domains = cloudflare.get_workers_custom_domains(account_id="9a7806061c88ada191ed06f989cc3dac",
        environment="production",
        hostname="foo.example.com",
        service="foo",
        zone_id="593c9c94de529bbbfaac7c53ced0447d",
        zone_name="example.com")
    ```


    :param _builtins.str account_id: Identifer of the account.
    :param _builtins.str environment: Worker environment associated with the zone and hostname.
    :param _builtins.str hostname: Hostname of the Worker Domain.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str service: Worker service associated with the zone and hostname.
    :param _builtins.str zone_id: Identifier of the zone.
    :param _builtins.str zone_name: Name of the zone.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['environment'] = environment
    __args__['hostname'] = hostname
    __args__['maxItems'] = max_items
    __args__['service'] = service
    __args__['zoneId'] = zone_id
    __args__['zoneName'] = zone_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWorkersCustomDomains:getWorkersCustomDomains', __args__, opts=opts, typ=GetWorkersCustomDomainsResult).value

    return AwaitableGetWorkersCustomDomainsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        environment=pulumi.get(__ret__, 'environment'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        results=pulumi.get(__ret__, 'results'),
        service=pulumi.get(__ret__, 'service'),
        zone_id=pulumi.get(__ret__, 'zone_id'),
        zone_name=pulumi.get(__ret__, 'zone_name'))
def get_workers_custom_domains_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      environment: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      hostname: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                      service: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      zone_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkersCustomDomainsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_workers_custom_domains = cloudflare.get_workers_custom_domains(account_id="9a7806061c88ada191ed06f989cc3dac",
        environment="production",
        hostname="foo.example.com",
        service="foo",
        zone_id="593c9c94de529bbbfaac7c53ced0447d",
        zone_name="example.com")
    ```


    :param _builtins.str account_id: Identifer of the account.
    :param _builtins.str environment: Worker environment associated with the zone and hostname.
    :param _builtins.str hostname: Hostname of the Worker Domain.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str service: Worker service associated with the zone and hostname.
    :param _builtins.str zone_id: Identifier of the zone.
    :param _builtins.str zone_name: Name of the zone.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['environment'] = environment
    __args__['hostname'] = hostname
    __args__['maxItems'] = max_items
    __args__['service'] = service
    __args__['zoneId'] = zone_id
    __args__['zoneName'] = zone_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWorkersCustomDomains:getWorkersCustomDomains', __args__, opts=opts, typ=GetWorkersCustomDomainsResult)
    return __ret__.apply(lambda __response__: GetWorkersCustomDomainsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        environment=pulumi.get(__response__, 'environment'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        results=pulumi.get(__response__, 'results'),
        service=pulumi.get(__response__, 'service'),
        zone_id=pulumi.get(__response__, 'zone_id'),
        zone_name=pulumi.get(__response__, 'zone_name')))
