# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustTunnelCloudflaredsResult',
    'AwaitableGetZeroTrustTunnelCloudflaredsResult',
    'get_zero_trust_tunnel_cloudflareds',
    'get_zero_trust_tunnel_cloudflareds_output',
]

@pulumi.output_type
class GetZeroTrustTunnelCloudflaredsResult:
    """
    A collection of values returned by getZeroTrustTunnelCloudflareds.
    """
    def __init__(__self__, account_id=None, exclude_prefix=None, existed_at=None, id=None, include_prefix=None, is_deleted=None, max_items=None, name=None, results=None, status=None, uuid=None, was_active_at=None, was_inactive_at=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if exclude_prefix and not isinstance(exclude_prefix, str):
            raise TypeError("Expected argument 'exclude_prefix' to be a str")
        pulumi.set(__self__, "exclude_prefix", exclude_prefix)
        if existed_at and not isinstance(existed_at, str):
            raise TypeError("Expected argument 'existed_at' to be a str")
        pulumi.set(__self__, "existed_at", existed_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_prefix and not isinstance(include_prefix, str):
            raise TypeError("Expected argument 'include_prefix' to be a str")
        pulumi.set(__self__, "include_prefix", include_prefix)
        if is_deleted and not isinstance(is_deleted, bool):
            raise TypeError("Expected argument 'is_deleted' to be a bool")
        pulumi.set(__self__, "is_deleted", is_deleted)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)
        if was_active_at and not isinstance(was_active_at, str):
            raise TypeError("Expected argument 'was_active_at' to be a str")
        pulumi.set(__self__, "was_active_at", was_active_at)
        if was_inactive_at and not isinstance(was_inactive_at, str):
            raise TypeError("Expected argument 'was_inactive_at' to be a str")
        pulumi.set(__self__, "was_inactive_at", was_inactive_at)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="excludePrefix")
    def exclude_prefix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "exclude_prefix")

    @_builtins.property
    @pulumi.getter(name="existedAt")
    def existed_at(self) -> Optional[_builtins.str]:
        """
        If provided, include only resources that were created (and not deleted) before this time. URL encoded.
        """
        return pulumi.get(self, "existed_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includePrefix")
    def include_prefix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "include_prefix")

    @_builtins.property
    @pulumi.getter(name="isDeleted")
    def is_deleted(self) -> Optional[_builtins.bool]:
        """
        If `true`, only include deleted tunnels. If `false`, exclude deleted tunnels. If empty, all tunnels will be included.
        """
        return pulumi.get(self, "is_deleted")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name for a tunnel.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetZeroTrustTunnelCloudflaredsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the tunnel. Valid values are `inactive` (tunnel has never been run), `degraded` (tunnel is active and able to serve traffic but in an unhealthy state), `healthy` (tunnel is active and able to serve traffic), or `down` (tunnel can not serve traffic as it has no connections to the Cloudflare Edge).
        Available values: "inactive", "degraded", "healthy", "down".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[_builtins.str]:
        """
        UUID of the tunnel.
        """
        return pulumi.get(self, "uuid")

    @_builtins.property
    @pulumi.getter(name="wasActiveAt")
    def was_active_at(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "was_active_at")

    @_builtins.property
    @pulumi.getter(name="wasInactiveAt")
    def was_inactive_at(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "was_inactive_at")


class AwaitableGetZeroTrustTunnelCloudflaredsResult(GetZeroTrustTunnelCloudflaredsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustTunnelCloudflaredsResult(
            account_id=self.account_id,
            exclude_prefix=self.exclude_prefix,
            existed_at=self.existed_at,
            id=self.id,
            include_prefix=self.include_prefix,
            is_deleted=self.is_deleted,
            max_items=self.max_items,
            name=self.name,
            results=self.results,
            status=self.status,
            uuid=self.uuid,
            was_active_at=self.was_active_at,
            was_inactive_at=self.was_inactive_at)


def get_zero_trust_tunnel_cloudflareds(account_id: Optional[_builtins.str] = None,
                                       exclude_prefix: Optional[_builtins.str] = None,
                                       existed_at: Optional[_builtins.str] = None,
                                       include_prefix: Optional[_builtins.str] = None,
                                       is_deleted: Optional[_builtins.bool] = None,
                                       max_items: Optional[_builtins.int] = None,
                                       name: Optional[_builtins.str] = None,
                                       status: Optional[_builtins.str] = None,
                                       uuid: Optional[_builtins.str] = None,
                                       was_active_at: Optional[_builtins.str] = None,
                                       was_inactive_at: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustTunnelCloudflaredsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_tunnel_cloudflareds = cloudflare.get_zero_trust_tunnel_cloudflareds(account_id="699d98642c564d2e855e9661899b7252",
        exclude_prefix="vpc1-",
        existed_at="2019-10-12T07%3A20%3A50.52Z",
        include_prefix="vpc1-",
        is_deleted=True,
        name="blog",
        status="healthy",
        uuid="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
        was_active_at="2009-11-10T23:00:00Z",
        was_inactive_at="2009-11-10T23:00:00Z")
    ```


    :param _builtins.str account_id: Cloudflare account ID
    :param _builtins.str existed_at: If provided, include only resources that were created (and not deleted) before this time. URL encoded.
    :param _builtins.bool is_deleted: If `true`, only include deleted tunnels. If `false`, exclude deleted tunnels. If empty, all tunnels will be included.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str name: A user-friendly name for a tunnel.
    :param _builtins.str status: The status of the tunnel. Valid values are `inactive` (tunnel has never been run), `degraded` (tunnel is active and able to serve traffic but in an unhealthy state), `healthy` (tunnel is active and able to serve traffic), or `down` (tunnel can not serve traffic as it has no connections to the Cloudflare Edge).
           Available values: "inactive", "degraded", "healthy", "down".
    :param _builtins.str uuid: UUID of the tunnel.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['excludePrefix'] = exclude_prefix
    __args__['existedAt'] = existed_at
    __args__['includePrefix'] = include_prefix
    __args__['isDeleted'] = is_deleted
    __args__['maxItems'] = max_items
    __args__['name'] = name
    __args__['status'] = status
    __args__['uuid'] = uuid
    __args__['wasActiveAt'] = was_active_at
    __args__['wasInactiveAt'] = was_inactive_at
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustTunnelCloudflareds:getZeroTrustTunnelCloudflareds', __args__, opts=opts, typ=GetZeroTrustTunnelCloudflaredsResult).value

    return AwaitableGetZeroTrustTunnelCloudflaredsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        exclude_prefix=pulumi.get(__ret__, 'exclude_prefix'),
        existed_at=pulumi.get(__ret__, 'existed_at'),
        id=pulumi.get(__ret__, 'id'),
        include_prefix=pulumi.get(__ret__, 'include_prefix'),
        is_deleted=pulumi.get(__ret__, 'is_deleted'),
        max_items=pulumi.get(__ret__, 'max_items'),
        name=pulumi.get(__ret__, 'name'),
        results=pulumi.get(__ret__, 'results'),
        status=pulumi.get(__ret__, 'status'),
        uuid=pulumi.get(__ret__, 'uuid'),
        was_active_at=pulumi.get(__ret__, 'was_active_at'),
        was_inactive_at=pulumi.get(__ret__, 'was_inactive_at'))
def get_zero_trust_tunnel_cloudflareds_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              exclude_prefix: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              existed_at: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              include_prefix: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              is_deleted: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                              max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              uuid: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              was_active_at: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              was_inactive_at: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustTunnelCloudflaredsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_tunnel_cloudflareds = cloudflare.get_zero_trust_tunnel_cloudflareds(account_id="699d98642c564d2e855e9661899b7252",
        exclude_prefix="vpc1-",
        existed_at="2019-10-12T07%3A20%3A50.52Z",
        include_prefix="vpc1-",
        is_deleted=True,
        name="blog",
        status="healthy",
        uuid="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
        was_active_at="2009-11-10T23:00:00Z",
        was_inactive_at="2009-11-10T23:00:00Z")
    ```


    :param _builtins.str account_id: Cloudflare account ID
    :param _builtins.str existed_at: If provided, include only resources that were created (and not deleted) before this time. URL encoded.
    :param _builtins.bool is_deleted: If `true`, only include deleted tunnels. If `false`, exclude deleted tunnels. If empty, all tunnels will be included.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str name: A user-friendly name for a tunnel.
    :param _builtins.str status: The status of the tunnel. Valid values are `inactive` (tunnel has never been run), `degraded` (tunnel is active and able to serve traffic but in an unhealthy state), `healthy` (tunnel is active and able to serve traffic), or `down` (tunnel can not serve traffic as it has no connections to the Cloudflare Edge).
           Available values: "inactive", "degraded", "healthy", "down".
    :param _builtins.str uuid: UUID of the tunnel.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['excludePrefix'] = exclude_prefix
    __args__['existedAt'] = existed_at
    __args__['includePrefix'] = include_prefix
    __args__['isDeleted'] = is_deleted
    __args__['maxItems'] = max_items
    __args__['name'] = name
    __args__['status'] = status
    __args__['uuid'] = uuid
    __args__['wasActiveAt'] = was_active_at
    __args__['wasInactiveAt'] = was_inactive_at
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustTunnelCloudflareds:getZeroTrustTunnelCloudflareds', __args__, opts=opts, typ=GetZeroTrustTunnelCloudflaredsResult)
    return __ret__.apply(lambda __response__: GetZeroTrustTunnelCloudflaredsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        exclude_prefix=pulumi.get(__response__, 'exclude_prefix'),
        existed_at=pulumi.get(__response__, 'existed_at'),
        id=pulumi.get(__response__, 'id'),
        include_prefix=pulumi.get(__response__, 'include_prefix'),
        is_deleted=pulumi.get(__response__, 'is_deleted'),
        max_items=pulumi.get(__response__, 'max_items'),
        name=pulumi.get(__response__, 'name'),
        results=pulumi.get(__response__, 'results'),
        status=pulumi.get(__response__, 'status'),
        uuid=pulumi.get(__response__, 'uuid'),
        was_active_at=pulumi.get(__response__, 'was_active_at'),
        was_inactive_at=pulumi.get(__response__, 'was_inactive_at')))
