# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MagicTransitSiteLanArgs', 'MagicTransitSiteLan']

@pulumi.input_type
class MagicTransitSiteLanArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 physport: pulumi.Input[_builtins.int],
                 site_id: pulumi.Input[_builtins.str],
                 ha_link: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat: Optional[pulumi.Input['MagicTransitSiteLanNatArgs']] = None,
                 routed_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['MagicTransitSiteLanRoutedSubnetArgs']]]] = None,
                 static_addressing: Optional[pulumi.Input['MagicTransitSiteLanStaticAddressingArgs']] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a MagicTransitSiteLan resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] site_id: Identifier
        :param pulumi.Input[_builtins.bool] ha_link: mark true to use this LAN for HA probing. only works for site with HA turned on. only one LAN can be set as the ha_link.
        :param pulumi.Input['MagicTransitSiteLanStaticAddressingArgs'] static_addressing: If the site is not configured in high availability mode, this configuration is optional (if omitted, use DHCP). However, if in high availability mode, static*address is required along with secondary and virtual address.
        :param pulumi.Input[_builtins.int] vlan_tag: VLAN ID. Use zero for untagged.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "physport", physport)
        pulumi.set(__self__, "site_id", site_id)
        if ha_link is not None:
            pulumi.set(__self__, "ha_link", ha_link)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat is not None:
            pulumi.set(__self__, "nat", nat)
        if routed_subnets is not None:
            pulumi.set(__self__, "routed_subnets", routed_subnets)
        if static_addressing is not None:
            pulumi.set(__self__, "static_addressing", static_addressing)
        if vlan_tag is not None:
            pulumi.set(__self__, "vlan_tag", vlan_tag)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def physport(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "physport")

    @physport.setter
    def physport(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "physport", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="haLink")
    def ha_link(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        mark true to use this LAN for HA probing. only works for site with HA turned on. only one LAN can be set as the ha_link.
        """
        return pulumi.get(self, "ha_link")

    @ha_link.setter
    def ha_link(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ha_link", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nat(self) -> Optional[pulumi.Input['MagicTransitSiteLanNatArgs']]:
        return pulumi.get(self, "nat")

    @nat.setter
    def nat(self, value: Optional[pulumi.Input['MagicTransitSiteLanNatArgs']]):
        pulumi.set(self, "nat", value)

    @_builtins.property
    @pulumi.getter(name="routedSubnets")
    def routed_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MagicTransitSiteLanRoutedSubnetArgs']]]]:
        return pulumi.get(self, "routed_subnets")

    @routed_subnets.setter
    def routed_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MagicTransitSiteLanRoutedSubnetArgs']]]]):
        pulumi.set(self, "routed_subnets", value)

    @_builtins.property
    @pulumi.getter(name="staticAddressing")
    def static_addressing(self) -> Optional[pulumi.Input['MagicTransitSiteLanStaticAddressingArgs']]:
        """
        If the site is not configured in high availability mode, this configuration is optional (if omitted, use DHCP). However, if in high availability mode, static*address is required along with secondary and virtual address.
        """
        return pulumi.get(self, "static_addressing")

    @static_addressing.setter
    def static_addressing(self, value: Optional[pulumi.Input['MagicTransitSiteLanStaticAddressingArgs']]):
        pulumi.set(self, "static_addressing", value)

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        VLAN ID. Use zero for untagged.
        """
        return pulumi.get(self, "vlan_tag")

    @vlan_tag.setter
    def vlan_tag(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_tag", value)


@pulumi.input_type
class _MagicTransitSiteLanState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_link: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat: Optional[pulumi.Input['MagicTransitSiteLanNatArgs']] = None,
                 physport: Optional[pulumi.Input[_builtins.int]] = None,
                 routed_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['MagicTransitSiteLanRoutedSubnetArgs']]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_addressing: Optional[pulumi.Input['MagicTransitSiteLanStaticAddressingArgs']] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering MagicTransitSiteLan resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.bool] ha_link: mark true to use this LAN for HA probing. only works for site with HA turned on. only one LAN can be set as the ha_link.
        :param pulumi.Input[_builtins.str] site_id: Identifier
        :param pulumi.Input['MagicTransitSiteLanStaticAddressingArgs'] static_addressing: If the site is not configured in high availability mode, this configuration is optional (if omitted, use DHCP). However, if in high availability mode, static*address is required along with secondary and virtual address.
        :param pulumi.Input[_builtins.int] vlan_tag: VLAN ID. Use zero for untagged.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if ha_link is not None:
            pulumi.set(__self__, "ha_link", ha_link)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat is not None:
            pulumi.set(__self__, "nat", nat)
        if physport is not None:
            pulumi.set(__self__, "physport", physport)
        if routed_subnets is not None:
            pulumi.set(__self__, "routed_subnets", routed_subnets)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if static_addressing is not None:
            pulumi.set(__self__, "static_addressing", static_addressing)
        if vlan_tag is not None:
            pulumi.set(__self__, "vlan_tag", vlan_tag)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="haLink")
    def ha_link(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        mark true to use this LAN for HA probing. only works for site with HA turned on. only one LAN can be set as the ha_link.
        """
        return pulumi.get(self, "ha_link")

    @ha_link.setter
    def ha_link(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ha_link", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nat(self) -> Optional[pulumi.Input['MagicTransitSiteLanNatArgs']]:
        return pulumi.get(self, "nat")

    @nat.setter
    def nat(self, value: Optional[pulumi.Input['MagicTransitSiteLanNatArgs']]):
        pulumi.set(self, "nat", value)

    @_builtins.property
    @pulumi.getter
    def physport(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "physport")

    @physport.setter
    def physport(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "physport", value)

    @_builtins.property
    @pulumi.getter(name="routedSubnets")
    def routed_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MagicTransitSiteLanRoutedSubnetArgs']]]]:
        return pulumi.get(self, "routed_subnets")

    @routed_subnets.setter
    def routed_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MagicTransitSiteLanRoutedSubnetArgs']]]]):
        pulumi.set(self, "routed_subnets", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="staticAddressing")
    def static_addressing(self) -> Optional[pulumi.Input['MagicTransitSiteLanStaticAddressingArgs']]:
        """
        If the site is not configured in high availability mode, this configuration is optional (if omitted, use DHCP). However, if in high availability mode, static*address is required along with secondary and virtual address.
        """
        return pulumi.get(self, "static_addressing")

    @static_addressing.setter
    def static_addressing(self, value: Optional[pulumi.Input['MagicTransitSiteLanStaticAddressingArgs']]):
        pulumi.set(self, "static_addressing", value)

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        VLAN ID. Use zero for untagged.
        """
        return pulumi.get(self, "vlan_tag")

    @vlan_tag.setter
    def vlan_tag(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_tag", value)


@pulumi.type_token("cloudflare:index/magicTransitSiteLan:MagicTransitSiteLan")
class MagicTransitSiteLan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_link: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat: Optional[pulumi.Input[Union['MagicTransitSiteLanNatArgs', 'MagicTransitSiteLanNatArgsDict']]] = None,
                 physport: Optional[pulumi.Input[_builtins.int]] = None,
                 routed_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MagicTransitSiteLanRoutedSubnetArgs', 'MagicTransitSiteLanRoutedSubnetArgsDict']]]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_addressing: Optional[pulumi.Input[Union['MagicTransitSiteLanStaticAddressingArgs', 'MagicTransitSiteLanStaticAddressingArgsDict']]] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicTransitSiteLan:MagicTransitSiteLan example '<account_id>/<site_id>/<lan_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.bool] ha_link: mark true to use this LAN for HA probing. only works for site with HA turned on. only one LAN can be set as the ha_link.
        :param pulumi.Input[_builtins.str] site_id: Identifier
        :param pulumi.Input[Union['MagicTransitSiteLanStaticAddressingArgs', 'MagicTransitSiteLanStaticAddressingArgsDict']] static_addressing: If the site is not configured in high availability mode, this configuration is optional (if omitted, use DHCP). However, if in high availability mode, static*address is required along with secondary and virtual address.
        :param pulumi.Input[_builtins.int] vlan_tag: VLAN ID. Use zero for untagged.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MagicTransitSiteLanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicTransitSiteLan:MagicTransitSiteLan example '<account_id>/<site_id>/<lan_id>'
        ```

        :param str resource_name: The name of the resource.
        :param MagicTransitSiteLanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MagicTransitSiteLanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_link: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat: Optional[pulumi.Input[Union['MagicTransitSiteLanNatArgs', 'MagicTransitSiteLanNatArgsDict']]] = None,
                 physport: Optional[pulumi.Input[_builtins.int]] = None,
                 routed_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MagicTransitSiteLanRoutedSubnetArgs', 'MagicTransitSiteLanRoutedSubnetArgsDict']]]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_addressing: Optional[pulumi.Input[Union['MagicTransitSiteLanStaticAddressingArgs', 'MagicTransitSiteLanStaticAddressingArgsDict']]] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MagicTransitSiteLanArgs.__new__(MagicTransitSiteLanArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["ha_link"] = ha_link
            __props__.__dict__["name"] = name
            __props__.__dict__["nat"] = nat
            if physport is None and not opts.urn:
                raise TypeError("Missing required property 'physport'")
            __props__.__dict__["physport"] = physport
            __props__.__dict__["routed_subnets"] = routed_subnets
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["static_addressing"] = static_addressing
            __props__.__dict__["vlan_tag"] = vlan_tag
        super(MagicTransitSiteLan, __self__).__init__(
            'cloudflare:index/magicTransitSiteLan:MagicTransitSiteLan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            ha_link: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nat: Optional[pulumi.Input[Union['MagicTransitSiteLanNatArgs', 'MagicTransitSiteLanNatArgsDict']]] = None,
            physport: Optional[pulumi.Input[_builtins.int]] = None,
            routed_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MagicTransitSiteLanRoutedSubnetArgs', 'MagicTransitSiteLanRoutedSubnetArgsDict']]]]] = None,
            site_id: Optional[pulumi.Input[_builtins.str]] = None,
            static_addressing: Optional[pulumi.Input[Union['MagicTransitSiteLanStaticAddressingArgs', 'MagicTransitSiteLanStaticAddressingArgsDict']]] = None,
            vlan_tag: Optional[pulumi.Input[_builtins.int]] = None) -> 'MagicTransitSiteLan':
        """
        Get an existing MagicTransitSiteLan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.bool] ha_link: mark true to use this LAN for HA probing. only works for site with HA turned on. only one LAN can be set as the ha_link.
        :param pulumi.Input[_builtins.str] site_id: Identifier
        :param pulumi.Input[Union['MagicTransitSiteLanStaticAddressingArgs', 'MagicTransitSiteLanStaticAddressingArgsDict']] static_addressing: If the site is not configured in high availability mode, this configuration is optional (if omitted, use DHCP). However, if in high availability mode, static*address is required along with secondary and virtual address.
        :param pulumi.Input[_builtins.int] vlan_tag: VLAN ID. Use zero for untagged.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MagicTransitSiteLanState.__new__(_MagicTransitSiteLanState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["ha_link"] = ha_link
        __props__.__dict__["name"] = name
        __props__.__dict__["nat"] = nat
        __props__.__dict__["physport"] = physport
        __props__.__dict__["routed_subnets"] = routed_subnets
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["static_addressing"] = static_addressing
        __props__.__dict__["vlan_tag"] = vlan_tag
        return MagicTransitSiteLan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="haLink")
    def ha_link(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        mark true to use this LAN for HA probing. only works for site with HA turned on. only one LAN can be set as the ha_link.
        """
        return pulumi.get(self, "ha_link")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nat(self) -> pulumi.Output[Optional['outputs.MagicTransitSiteLanNat']]:
        return pulumi.get(self, "nat")

    @_builtins.property
    @pulumi.getter
    def physport(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "physport")

    @_builtins.property
    @pulumi.getter(name="routedSubnets")
    def routed_subnets(self) -> pulumi.Output[Optional[Sequence['outputs.MagicTransitSiteLanRoutedSubnet']]]:
        return pulumi.get(self, "routed_subnets")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="staticAddressing")
    def static_addressing(self) -> pulumi.Output[Optional['outputs.MagicTransitSiteLanStaticAddressing']]:
        """
        If the site is not configured in high availability mode, this configuration is optional (if omitted, use DHCP). However, if in high availability mode, static*address is required along with secondary and virtual address.
        """
        return pulumi.get(self, "static_addressing")

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        VLAN ID. Use zero for untagged.
        """
        return pulumi.get(self, "vlan_tag")

