# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MagicWanGreTunnelArgs', 'MagicWanGreTunnel']

@pulumi.input_type
class MagicWanGreTunnelArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 cloudflare_gre_endpoint: pulumi.Input[_builtins.str],
                 customer_gre_endpoint: pulumi.Input[_builtins.str],
                 interface_address: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check: Optional[pulumi.Input['MagicWanGreTunnelHealthCheckArgs']] = None,
                 interface_address6: Optional[pulumi.Input[_builtins.str]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a MagicWanGreTunnel resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] cloudflare_gre_endpoint: The IP address assigned to the Cloudflare side of the GRE tunnel.
        :param pulumi.Input[_builtins.str] customer_gre_endpoint: The IP address assigned to the customer side of the GRE tunnel.
        :param pulumi.Input[_builtins.str] interface_address: A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        :param pulumi.Input[_builtins.str] name: The name of the tunnel. The name cannot contain spaces or special characters, must be 15 characters or less, and cannot share a name with another GRE tunnel.
        :param pulumi.Input[_builtins.str] description: An optional description of the GRE tunnel.
        :param pulumi.Input[_builtins.str] interface_address6: A 127 bit IPV6 prefix from within the virtual*subnet6 prefix space with the address being the first IP of the subnet and not same as the address of virtual*subnet6. Eg if virtual*subnet6 is 2606:54c1:7:0:a9fe:12d2::/127 , interface*address6 could be 2606:54c1:7:0:a9fe:12d2:1:200/127
        :param pulumi.Input[_builtins.int] mtu: Maximum Transmission Unit (MTU) in bytes for the GRE tunnel. The minimum value is 576.
        :param pulumi.Input[_builtins.int] ttl: Time To Live (TTL) in number of hops of the GRE tunnel.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "cloudflare_gre_endpoint", cloudflare_gre_endpoint)
        pulumi.set(__self__, "customer_gre_endpoint", customer_gre_endpoint)
        pulumi.set(__self__, "interface_address", interface_address)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if interface_address6 is not None:
            pulumi.set(__self__, "interface_address6", interface_address6)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudflareGreEndpoint")
    def cloudflare_gre_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address assigned to the Cloudflare side of the GRE tunnel.
        """
        return pulumi.get(self, "cloudflare_gre_endpoint")

    @cloudflare_gre_endpoint.setter
    def cloudflare_gre_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloudflare_gre_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="customerGreEndpoint")
    def customer_gre_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address assigned to the customer side of the GRE tunnel.
        """
        return pulumi.get(self, "customer_gre_endpoint")

    @customer_gre_endpoint.setter
    def customer_gre_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "customer_gre_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="interfaceAddress")
    def interface_address(self) -> pulumi.Input[_builtins.str]:
        """
        A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        """
        return pulumi.get(self, "interface_address")

    @interface_address.setter
    def interface_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "interface_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the tunnel. The name cannot contain spaces or special characters, must be 15 characters or less, and cannot share a name with another GRE tunnel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of the GRE tunnel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['MagicWanGreTunnelHealthCheckArgs']]:
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['MagicWanGreTunnelHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @_builtins.property
    @pulumi.getter(name="interfaceAddress6")
    def interface_address6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A 127 bit IPV6 prefix from within the virtual*subnet6 prefix space with the address being the first IP of the subnet and not same as the address of virtual*subnet6. Eg if virtual*subnet6 is 2606:54c1:7:0:a9fe:12d2::/127 , interface*address6 could be 2606:54c1:7:0:a9fe:12d2:1:200/127
        """
        return pulumi.get(self, "interface_address6")

    @interface_address6.setter
    def interface_address6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_address6", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum Transmission Unit (MTU) in bytes for the GRE tunnel. The minimum value is 576.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time To Live (TTL) in number of hops of the GRE tunnel.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _MagicWanGreTunnelState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloudflare_gre_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_gre_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check: Optional[pulumi.Input['MagicWanGreTunnelHealthCheckArgs']] = None,
                 interface_address: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_address6: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering MagicWanGreTunnel resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] cloudflare_gre_endpoint: The IP address assigned to the Cloudflare side of the GRE tunnel.
        :param pulumi.Input[_builtins.str] created_on: The date and time the tunnel was created.
        :param pulumi.Input[_builtins.str] customer_gre_endpoint: The IP address assigned to the customer side of the GRE tunnel.
        :param pulumi.Input[_builtins.str] description: An optional description of the GRE tunnel.
        :param pulumi.Input[_builtins.str] interface_address: A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        :param pulumi.Input[_builtins.str] interface_address6: A 127 bit IPV6 prefix from within the virtual*subnet6 prefix space with the address being the first IP of the subnet and not same as the address of virtual*subnet6. Eg if virtual*subnet6 is 2606:54c1:7:0:a9fe:12d2::/127 , interface*address6 could be 2606:54c1:7:0:a9fe:12d2:1:200/127
        :param pulumi.Input[_builtins.str] modified_on: The date and time the tunnel was last modified.
        :param pulumi.Input[_builtins.int] mtu: Maximum Transmission Unit (MTU) in bytes for the GRE tunnel. The minimum value is 576.
        :param pulumi.Input[_builtins.str] name: The name of the tunnel. The name cannot contain spaces or special characters, must be 15 characters or less, and cannot share a name with another GRE tunnel.
        :param pulumi.Input[_builtins.int] ttl: Time To Live (TTL) in number of hops of the GRE tunnel.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if cloudflare_gre_endpoint is not None:
            pulumi.set(__self__, "cloudflare_gre_endpoint", cloudflare_gre_endpoint)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if customer_gre_endpoint is not None:
            pulumi.set(__self__, "customer_gre_endpoint", customer_gre_endpoint)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if interface_address is not None:
            pulumi.set(__self__, "interface_address", interface_address)
        if interface_address6 is not None:
            pulumi.set(__self__, "interface_address6", interface_address6)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudflareGreEndpoint")
    def cloudflare_gre_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address assigned to the Cloudflare side of the GRE tunnel.
        """
        return pulumi.get(self, "cloudflare_gre_endpoint")

    @cloudflare_gre_endpoint.setter
    def cloudflare_gre_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloudflare_gre_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the tunnel was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter(name="customerGreEndpoint")
    def customer_gre_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address assigned to the customer side of the GRE tunnel.
        """
        return pulumi.get(self, "customer_gre_endpoint")

    @customer_gre_endpoint.setter
    def customer_gre_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_gre_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of the GRE tunnel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['MagicWanGreTunnelHealthCheckArgs']]:
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['MagicWanGreTunnelHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @_builtins.property
    @pulumi.getter(name="interfaceAddress")
    def interface_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        """
        return pulumi.get(self, "interface_address")

    @interface_address.setter
    def interface_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_address", value)

    @_builtins.property
    @pulumi.getter(name="interfaceAddress6")
    def interface_address6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A 127 bit IPV6 prefix from within the virtual*subnet6 prefix space with the address being the first IP of the subnet and not same as the address of virtual*subnet6. Eg if virtual*subnet6 is 2606:54c1:7:0:a9fe:12d2::/127 , interface*address6 could be 2606:54c1:7:0:a9fe:12d2:1:200/127
        """
        return pulumi.get(self, "interface_address6")

    @interface_address6.setter
    def interface_address6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_address6", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the tunnel was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum Transmission Unit (MTU) in bytes for the GRE tunnel. The minimum value is 576.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the tunnel. The name cannot contain spaces or special characters, must be 15 characters or less, and cannot share a name with another GRE tunnel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time To Live (TTL) in number of hops of the GRE tunnel.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("cloudflare:index/magicWanGreTunnel:MagicWanGreTunnel")
class MagicWanGreTunnel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloudflare_gre_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_gre_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check: Optional[pulumi.Input[Union['MagicWanGreTunnelHealthCheckArgs', 'MagicWanGreTunnelHealthCheckArgsDict']]] = None,
                 interface_address: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_address6: Optional[pulumi.Input[_builtins.str]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicWanGreTunnel:MagicWanGreTunnel example '<account_id>/<gre_tunnel_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] cloudflare_gre_endpoint: The IP address assigned to the Cloudflare side of the GRE tunnel.
        :param pulumi.Input[_builtins.str] customer_gre_endpoint: The IP address assigned to the customer side of the GRE tunnel.
        :param pulumi.Input[_builtins.str] description: An optional description of the GRE tunnel.
        :param pulumi.Input[_builtins.str] interface_address: A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        :param pulumi.Input[_builtins.str] interface_address6: A 127 bit IPV6 prefix from within the virtual*subnet6 prefix space with the address being the first IP of the subnet and not same as the address of virtual*subnet6. Eg if virtual*subnet6 is 2606:54c1:7:0:a9fe:12d2::/127 , interface*address6 could be 2606:54c1:7:0:a9fe:12d2:1:200/127
        :param pulumi.Input[_builtins.int] mtu: Maximum Transmission Unit (MTU) in bytes for the GRE tunnel. The minimum value is 576.
        :param pulumi.Input[_builtins.str] name: The name of the tunnel. The name cannot contain spaces or special characters, must be 15 characters or less, and cannot share a name with another GRE tunnel.
        :param pulumi.Input[_builtins.int] ttl: Time To Live (TTL) in number of hops of the GRE tunnel.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MagicWanGreTunnelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicWanGreTunnel:MagicWanGreTunnel example '<account_id>/<gre_tunnel_id>'
        ```

        :param str resource_name: The name of the resource.
        :param MagicWanGreTunnelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MagicWanGreTunnelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloudflare_gre_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_gre_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check: Optional[pulumi.Input[Union['MagicWanGreTunnelHealthCheckArgs', 'MagicWanGreTunnelHealthCheckArgsDict']]] = None,
                 interface_address: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_address6: Optional[pulumi.Input[_builtins.str]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MagicWanGreTunnelArgs.__new__(MagicWanGreTunnelArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if cloudflare_gre_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'cloudflare_gre_endpoint'")
            __props__.__dict__["cloudflare_gre_endpoint"] = cloudflare_gre_endpoint
            if customer_gre_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'customer_gre_endpoint'")
            __props__.__dict__["customer_gre_endpoint"] = customer_gre_endpoint
            __props__.__dict__["description"] = description
            __props__.__dict__["health_check"] = health_check
            if interface_address is None and not opts.urn:
                raise TypeError("Missing required property 'interface_address'")
            __props__.__dict__["interface_address"] = interface_address
            __props__.__dict__["interface_address6"] = interface_address6
            __props__.__dict__["mtu"] = mtu
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/greTunnel:GreTunnel")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(MagicWanGreTunnel, __self__).__init__(
            'cloudflare:index/magicWanGreTunnel:MagicWanGreTunnel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            cloudflare_gre_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            customer_gre_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            health_check: Optional[pulumi.Input[Union['MagicWanGreTunnelHealthCheckArgs', 'MagicWanGreTunnelHealthCheckArgsDict']]] = None,
            interface_address: Optional[pulumi.Input[_builtins.str]] = None,
            interface_address6: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            mtu: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None) -> 'MagicWanGreTunnel':
        """
        Get an existing MagicWanGreTunnel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] cloudflare_gre_endpoint: The IP address assigned to the Cloudflare side of the GRE tunnel.
        :param pulumi.Input[_builtins.str] created_on: The date and time the tunnel was created.
        :param pulumi.Input[_builtins.str] customer_gre_endpoint: The IP address assigned to the customer side of the GRE tunnel.
        :param pulumi.Input[_builtins.str] description: An optional description of the GRE tunnel.
        :param pulumi.Input[_builtins.str] interface_address: A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        :param pulumi.Input[_builtins.str] interface_address6: A 127 bit IPV6 prefix from within the virtual*subnet6 prefix space with the address being the first IP of the subnet and not same as the address of virtual*subnet6. Eg if virtual*subnet6 is 2606:54c1:7:0:a9fe:12d2::/127 , interface*address6 could be 2606:54c1:7:0:a9fe:12d2:1:200/127
        :param pulumi.Input[_builtins.str] modified_on: The date and time the tunnel was last modified.
        :param pulumi.Input[_builtins.int] mtu: Maximum Transmission Unit (MTU) in bytes for the GRE tunnel. The minimum value is 576.
        :param pulumi.Input[_builtins.str] name: The name of the tunnel. The name cannot contain spaces or special characters, must be 15 characters or less, and cannot share a name with another GRE tunnel.
        :param pulumi.Input[_builtins.int] ttl: Time To Live (TTL) in number of hops of the GRE tunnel.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MagicWanGreTunnelState.__new__(_MagicWanGreTunnelState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["cloudflare_gre_endpoint"] = cloudflare_gre_endpoint
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["customer_gre_endpoint"] = customer_gre_endpoint
        __props__.__dict__["description"] = description
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["interface_address"] = interface_address
        __props__.__dict__["interface_address6"] = interface_address6
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["name"] = name
        __props__.__dict__["ttl"] = ttl
        return MagicWanGreTunnel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="cloudflareGreEndpoint")
    def cloudflare_gre_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address assigned to the Cloudflare side of the GRE tunnel.
        """
        return pulumi.get(self, "cloudflare_gre_endpoint")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the tunnel was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="customerGreEndpoint")
    def customer_gre_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address assigned to the customer side of the GRE tunnel.
        """
        return pulumi.get(self, "customer_gre_endpoint")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of the GRE tunnel.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.MagicWanGreTunnelHealthCheck']:
        return pulumi.get(self, "health_check")

    @_builtins.property
    @pulumi.getter(name="interfaceAddress")
    def interface_address(self) -> pulumi.Output[_builtins.str]:
        """
        A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        """
        return pulumi.get(self, "interface_address")

    @_builtins.property
    @pulumi.getter(name="interfaceAddress6")
    def interface_address6(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A 127 bit IPV6 prefix from within the virtual*subnet6 prefix space with the address being the first IP of the subnet and not same as the address of virtual*subnet6. Eg if virtual*subnet6 is 2606:54c1:7:0:a9fe:12d2::/127 , interface*address6 could be 2606:54c1:7:0:a9fe:12d2:1:200/127
        """
        return pulumi.get(self, "interface_address6")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the tunnel was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum Transmission Unit (MTU) in bytes for the GRE tunnel. The minimum value is 576.
        """
        return pulumi.get(self, "mtu")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the tunnel. The name cannot contain spaces or special characters, must be 15 characters or less, and cannot share a name with another GRE tunnel.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.int]:
        """
        Time To Live (TTL) in number of hops of the GRE tunnel.
        """
        return pulumi.get(self, "ttl")

