# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QueueConsumerInitArgs', 'QueueConsumer']

@pulumi.input_type
class QueueConsumerInitArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 queue_id: pulumi.Input[_builtins.str],
                 consumer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_queue: Optional[pulumi.Input[_builtins.str]] = None,
                 script_name: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input['QueueConsumerSettingsArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a QueueConsumer resource.
        :param pulumi.Input[_builtins.str] account_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] queue_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] consumer_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] script_name: Name of a Worker
        :param pulumi.Input[_builtins.str] type: Available values: "worker", "http_pull".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "queue_id", queue_id)
        if consumer_id is not None:
            pulumi.set(__self__, "consumer_id", consumer_id)
        if dead_letter_queue is not None:
            pulumi.set(__self__, "dead_letter_queue", dead_letter_queue)
        if script_name is not None:
            pulumi.set(__self__, "script_name", script_name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> pulumi.Input[_builtins.str]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "queue_id")

    @queue_id.setter
    def queue_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "queue_id", value)

    @_builtins.property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "consumer_id")

    @consumer_id.setter
    def consumer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumer_id", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterQueue")
    def dead_letter_queue(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dead_letter_queue")

    @dead_letter_queue.setter
    def dead_letter_queue(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dead_letter_queue", value)

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a Worker
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_name", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['QueueConsumerSettingsArgs']]:
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['QueueConsumerSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Available values: "worker", "http_pull".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _QueueConsumerState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_queue: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                 script: Optional[pulumi.Input[_builtins.str]] = None,
                 script_name: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input['QueueConsumerSettingsArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering QueueConsumer resources.
        :param pulumi.Input[_builtins.str] account_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] consumer_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] queue_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] script: Name of a Worker
        :param pulumi.Input[_builtins.str] script_name: Name of a Worker
        :param pulumi.Input[_builtins.str] type: Available values: "worker", "http_pull".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if consumer_id is not None:
            pulumi.set(__self__, "consumer_id", consumer_id)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if dead_letter_queue is not None:
            pulumi.set(__self__, "dead_letter_queue", dead_letter_queue)
        if queue_id is not None:
            pulumi.set(__self__, "queue_id", queue_id)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if script_name is not None:
            pulumi.set(__self__, "script_name", script_name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "consumer_id")

    @consumer_id.setter
    def consumer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumer_id", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterQueue")
    def dead_letter_queue(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dead_letter_queue")

    @dead_letter_queue.setter
    def dead_letter_queue(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dead_letter_queue", value)

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "queue_id")

    @queue_id.setter
    def queue_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_id", value)

    @_builtins.property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a Worker
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script", value)

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a Worker
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_name", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['QueueConsumerSettingsArgs']]:
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['QueueConsumerSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Available values: "worker", "http_pull".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("cloudflare:index/queueConsumer:QueueConsumer")
class QueueConsumer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_queue: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                 script_name: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['QueueConsumerSettingsArgs', 'QueueConsumerSettingsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] consumer_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] queue_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] script_name: Name of a Worker
        :param pulumi.Input[_builtins.str] type: Available values: "worker", "http_pull".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueueConsumerInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param QueueConsumerInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueConsumerInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_queue: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                 script_name: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['QueueConsumerSettingsArgs', 'QueueConsumerSettingsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueConsumerInitArgs.__new__(QueueConsumerInitArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["consumer_id"] = consumer_id
            __props__.__dict__["dead_letter_queue"] = dead_letter_queue
            if queue_id is None and not opts.urn:
                raise TypeError("Missing required property 'queue_id'")
            __props__.__dict__["queue_id"] = queue_id
            __props__.__dict__["script_name"] = script_name
            __props__.__dict__["settings"] = settings
            __props__.__dict__["type"] = type
            __props__.__dict__["created_on"] = None
            __props__.__dict__["script"] = None
        super(QueueConsumer, __self__).__init__(
            'cloudflare:index/queueConsumer:QueueConsumer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            consumer_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            dead_letter_queue: Optional[pulumi.Input[_builtins.str]] = None,
            queue_id: Optional[pulumi.Input[_builtins.str]] = None,
            script: Optional[pulumi.Input[_builtins.str]] = None,
            script_name: Optional[pulumi.Input[_builtins.str]] = None,
            settings: Optional[pulumi.Input[Union['QueueConsumerSettingsArgs', 'QueueConsumerSettingsArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'QueueConsumer':
        """
        Get an existing QueueConsumer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] consumer_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] queue_id: A Resource identifier.
        :param pulumi.Input[_builtins.str] script: Name of a Worker
        :param pulumi.Input[_builtins.str] script_name: Name of a Worker
        :param pulumi.Input[_builtins.str] type: Available values: "worker", "http_pull".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueueConsumerState.__new__(_QueueConsumerState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["consumer_id"] = consumer_id
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["dead_letter_queue"] = dead_letter_queue
        __props__.__dict__["queue_id"] = queue_id
        __props__.__dict__["script"] = script
        __props__.__dict__["script_name"] = script_name
        __props__.__dict__["settings"] = settings
        __props__.__dict__["type"] = type
        return QueueConsumer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="consumerId")
    def consumer_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "consumer_id")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="deadLetterQueue")
    def dead_letter_queue(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "dead_letter_queue")

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> pulumi.Output[_builtins.str]:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "queue_id")

    @_builtins.property
    @pulumi.getter
    def script(self) -> pulumi.Output[_builtins.str]:
        """
        Name of a Worker
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of a Worker
        """
        return pulumi.get(self, "script_name")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional['outputs.QueueConsumerSettings']]:
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Available values: "worker", "http_pull".
        """
        return pulumi.get(self, "type")

